/********************************************************
*	
*
*			by malefactor
*
*   
********************************************************/
#include<math.h>	//sign and cos stuff
#include"gba.h"		//registers
#include"dispcnt.h"	//REG_DISPCNT
#include"backgrounds.h"	//EnableBackground
#include"time.h"	//Wait functions
#include"sprites.h"	//hrm..  wonder what this file does?
#include"keypad.h"	//input stuff
#include"iwram.h"	//puts functions in iwram

//Graphics data
#include"FEARWARE.h"
#include"KEEPER.h"
#include"UPPER.h"
#include"screens.h"	//screen default matrices

#define GAMEPAK_RAM  ((u8*)0x0E000000)	//to load: variable = pSaveMemory[index];
u8 *pSaveMemory = GAMEPAK_RAM;		//to save: pSaveMemory[index] = value;

//create an OAM variable and make it point to the address of OAM
u16* OAM = (u16*)0x7000000;

//create the array of sprites (128 is the maximum)
OAMEntry sprites[128];

s16 X[6] = {4,4,1,1,0,0}; 	//Sprite Positions
s16 Y[6] = {4,124,1,1,0,0};	//0)sprite[0] positon	1)sprite[1] position	2)sprite[0] char position for writing,
				//3)sprite[1] char position for writing		4)for storing 0 in save menu
				//5)stores 2 during save menu
int LastKey, CurrentKey;	//for Debouncing
char LetterCase = 0;		//0 = CAPS, 1 = lowercase
char LastSaving = 1;		//Easier to store last menu option than to reset it
char Saving = 0;			//0 = not in save menu, 1 = save selected, 2 = load selected
				//3 = rename selected, 4 = back selected, 5 = renaming
char QuickSave = 0;		//Current save slot

//create the rotation and scaling array (overlaps the OAMEntry array memory)
pRotData rotData = (pRotData)sprites;

FIXED angle = 0;
FIXED zoom = 1<<8;  //zoom is a fixed point number

FIXED SIN[360];		//my LUTs for sign and cosign
FIXED COS[360];

char RotIndexCounter = 0;  //global to keep track of rotation indexes used

u16* videoBuffer = (u16*)0x6000000;
u16* paletteMem = (u16*)0x5000000;

void PlotPixel(int x,int y, unsigned short int c) {videoBuffer[(y) *120 + (x)] = (c);}

///Palette Memory is 256 16 bit BGR values starting at 0x5000000


//this is my background structure defined in backgrounds.h
Bg bg2;  

//mainscreen map
u16 *pMap = (u16*)map;			//Map needs a pointer
//help map
u16 *pHelp = (u16*)help;		//Help needs a pointer
//save menu help map
u16 *pSaveHelp = (u16*)SaveHelp;	//SaveHelp needs a pointer
//save menu map
u16 *pSaveMenu = (u16*)SaveMenu;	//Help needs a pointer



void CopyOAM(){				//Copy sprite array to OAM
	u16 loop;
	u16* temp;
	temp = (u16*)sprites;
	for(loop = 0; loop < 128*4; loop++)	//128x4=512 # of character memory positions for 256 color sprites
		OAM[loop] = temp[loop];
}
void WaitForVsync(){			//wait for the screen to stop drawing
	while((volatile u16)REG_VCOUNT != 160){}
}
void InitializeSprites(){	//Move all sprites off screen
	u16 loop;
	for(loop = 0; loop < 128; loop++)
	{
		sprites[loop].attribute0 = 160; //y to >159
		sprites[loop].attribute1 = 240; //x to >239
	}
}
void UpdateSprite(char sprite, char visible){
	//make sprite invisible
	if(visible == 0)	sprites[sprite].attribute0 = SIZE_DOUBLE;
	//update the Y position and make visible
	else			sprites[sprite].attribute0 = COLOR_256 | SQUARE | Y[sprite];
	//update the X position
	sprites[sprite].attribute1 = SIZE_16 | X[sprite];
	WaitForVsync();	//wait for screen to stop drawing
	CopyOAM();	//copy sprite array to OAM
}
void MoveSprite(char sprite, int x1, int y1){
	while(x1 != X[sprite] || y1 != Y[sprite]){	//gradually move sprite
		if (x1 < X[sprite])
			x1++;
		if (x1 > X[sprite])
			x1--;
		if (y1 < Y[sprite])
			y1++;
		if (y1 > Y[sprite])
			y1--;
		sprites[sprite].attribute0 = COLOR_256 | SQUARE | y1;	//set 256 colors, square? shape, y position
		sprites[sprite].attribute1 = SIZE_16 | x1;		//set 16x16 and x position
		WaitForVsync();		//Wait for the screen to stop drawing
		CopyOAM();		//Copy sprite array to OAM
	}
}
void CheckDPad(char sprite){
	int x3 = X[sprite];	int y3 = Y[sprite];	//save sprite position
	int UpperBound, LeftBound;
	if(Saving == 5){
		UpperBound = 12 + (sprite * 116);
		LeftBound = 20 - (sprite * 16);
	}
	else{
		UpperBound = 4 + (sprite * 124);
		LeftBound = 4;
	}
	if(!(CurrentKey & KEY_UP)){			//if the up key is pressed
		if(Y[sprite] > UpperBound){		//check bounds
			Y[sprite] = Y[sprite] - 8;	//change sprite position
			Y[sprite + 2]--;		//change sprite char position
			QuickSave--;			//selected save slot
		}
	}
	if(!(CurrentKey & KEY_DOWN)){			//if the down key is pressed
		if(Y[sprite] < (108 + (sprite * 30))){	//check bounds
			Y[sprite] = Y[sprite] + 8;	//change sprite position
			Y[sprite + 2]++;		//change sprite char position
			QuickSave++;			//selected save slot
		}
	}
	if((Saving == 0) || (Saving == 5)){
		if(!(CurrentKey & KEY_LEFT)){			//if the left key is pressed
			if(X[sprite] > LeftBound){		//check bounds
				X[sprite] = X[sprite] - 8;	//change sprite position
				X[sprite + 2]--;		//change sprite char position
			}
		}
		if(!(CurrentKey & KEY_RIGHT)){			//if the right key is pressed
			if(X[sprite] < (220 - (sprite * 100))){	//check bounds
				X[sprite] = X[sprite] + 8;	//change sprite position
				X[sprite + 2]++;		//sprite char position
			}
		}
	}
	MoveSprite(sprite,x3,y3);
}
void DispSaveMenu(){
	int loop, index;
	if(pSaveMemory[0] == 1){			//if there are saved names
		for(index = 2; index < 28; index++){	//load them
			for(loop = 1; loop < 14; loop++)
				SaveMenu[loop+1][index+1] = pSaveMemory[(loop*28)+index];
		}
	}
	for(loop = 0; loop < 32*32; loop++)
		bg2.mapData[loop] = pSaveMenu[loop];	//write SaveMenu map
	X[4] = X[0];	Y[4] = Y[0];			//save sprite[0] postion
	X[0] = 4;	Y[0] = 4+(8*QuickSave);		//set new postion
	X[5] = X[2];	Y[5] = Y[2];			//save sprite[0] char position
	X[2] = 3;	Y[2] = 1+QuickSave;		//set new char position
	UpdateSprite(1,0);	UpdateSprite(0,1);
	if(Saving == 5)	Saving = 3;
	else		Saving = LastSaving;	//Which option was last selected?
}
void ExitSaveMenu(){
	int loop;
	LastSaving = Saving;
	Saving = 0;
	for(loop = 0; loop < 32*32; loop++) 	//32x32 tiles /2 if 16 bit copy
		bg2.mapData[loop] = pMap[loop];	//rewrite map
	Y[0] = Y[4];	X[0] = X[4];		//load sprite[0] position
	X[2] = X[5];	Y[2] = Y[5];		//load sprite[0] char position
	UpdateSprite(0,1);	UpdateSprite(1,1);
}
void ShowHelp(){
	int loop;	//declare variable for looping
	while(!(*KEYS & KEY_L)){
		for(loop = 0; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
			if (Saving == 5)	bg2.mapData[loop] = pSaveHelp[loop];	//write help map to screen
			else			bg2.mapData[loop] = pHelp[loop];
		UpdateSprite(0,0);	UpdateSprite(1,0);	//make sprites invisible
	}
	for(loop = 0; loop < 32*32; loop++)
		if (Saving == 5)	bg2.mapData[loop] = pSaveMenu[loop];	//rewrite save  menu map
		else			bg2.mapData[loop] = pMap[loop];		//rewrite maine screen map
	for(loop = 240; loop < 32*32; loop++)
		bg2.mapData[loop] = pMap[loop];			//write keyboard to screen
	UpdateSprite(0,1);	UpdateSprite(1,1);
}
void ChangeCase(){
	int loop, index;	//declare looping variables
	for(loop = 16; loop < 19; loop++)
		for(index = 1; index < 17; index++){
			if((loop == 16) && (index < 3))
				index = 3;
			if (LetterCase == 0)	map[loop][index] = map[loop][index] + 64;
			else			map[loop][index] = map[loop][index] - 64;
		}
	for(loop = 240; loop < 32*32; loop++) //32x32 tiles /2 if 16 bit copy
		bg2.mapData[loop] = pMap[loop];	//write map to screen
	if(LetterCase == 0)	LetterCase = 1;
	else			LetterCase = 0;
}
void GetInput(){
	int y2, x2, loop, index;
	WaitForVsync();	//wait for screen to stop drawing
	CurrentKey = *KEYS;	//for debouncing
	y2 = Y[0];	x2 = X[0];
	if(Saving == 5 && !(CurrentKey & KEY_R)){	//renaming and holding R
		if(!(CurrentKey & KEY_A)){		//if R and A is pressed
		        if(Y[0] < 108){			//check bounds
				Y[0] = Y[0]+8;	X[0] = 20;	//goto beginning of next line
				Y[2]++;	X[2] = 3;	//char position
			}
		}
		MoveSprite(0, x2, y2);
		CheckDPad(0);
	}
	else if(Saving == 5){	//Not holding R
		y2 = Y[1];	x2 = X[1];
		CheckDPad(1);
		if(!(CurrentKey & KEY_A)){       	//if the A key is pressed write text
			if(LastKey & KEY_A){			//Debounce
				if ((X[3] < 3) && (Y[3] == 1))
					SaveMenu[Y[2]][X[2]] = 0;
				else if (Y[3] == 1)
					SaveMenu[Y[2]][X[2]] = X[3] - 2 + (64 * LetterCase);
				else if (Y[3] == 2)
					SaveMenu[Y[2]][X[2]] = X[3] + 14 + (64 * LetterCase);
				else if (Y[3] == 3)
					SaveMenu[Y[2]][X[2]] = X[3] + 30 + (64 * LetterCase);
				for(loop = 0; loop < 240; loop++) //32x32 tiles /2 if 16 bit copy
					bg2.mapData[loop] = pSaveMenu[loop];	//rewrite map
				if(X[0] < 220){	
        				X[0] = X[0] + 8;	X[2] = X[2] + 1;	UpdateSprite(0,1);
				}
			}
		}
		if(!(CurrentKey & KEY_B))	//if the B key is pressed change case
			if(LastKey & KEY_B)	ChangeCase();
		if(!(CurrentKey & KEY_L))	ShowHelp();   	//if the L key is pressed display help screen
		if(!(CurrentKey & KEY_SELECT)){			//if select is pressed, save names
			pSaveMemory[0] = 1;			//we now have saved names
			for(index = 2; index < 28; index++){	//save them
				for(loop = 1; loop < 14; loop++)
					pSaveMemory[(loop*28)+index] = SaveMenu[loop+1][index+1];
			}
			DispSaveMenu();
		}
	}
	else if(Saving > 0){		//if in save menu
		CheckDPad(0);
		if(!(CurrentKey & KEY_RIGHT)){            //if the LEFT key is pressed move left
			if(LastKey & KEY_RIGHT){	//for debouncing
				if(Saving == 1){
					for(loop = 3; loop < 7; loop++)		//change save to lowercase
						SaveMenu[17][loop] = SaveMenu[17][loop] + 64;
					for(loop = 9; loop < 13; loop++)	//change load to CAPS
						SaveMenu[17][loop] = SaveMenu[17][loop] - 64;
					for(loop = 0; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
						bg2.mapData[loop] = pSaveMenu[loop];	//write save map to screen
					Saving = 2;
				}
				else if(Saving == 2){
					for(loop = 9; loop < 13; loop++)	//change load to lowercase
						SaveMenu[17][loop] = SaveMenu[17][loop] + 64;
					for(loop = 15; loop < 21; loop++)	//change rename to CAPS
						SaveMenu[17][loop] = SaveMenu[17][loop] - 64;
					for(loop = 0; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
						bg2.mapData[loop] = pSaveMenu[loop];	//write save map to screen
					Saving = 3;
				}	
				else if(Saving == 3){
					for(loop = 15; loop < 21; loop++)	//change rename to lowercase
						SaveMenu[17][loop] = SaveMenu[17][loop] + 64;
					for(loop = 23; loop < 27; loop++)	//change back to CAPS
						SaveMenu[17][loop] = SaveMenu[17][loop] - 64;
					for(loop = 0; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
						bg2.mapData[loop] = pSaveMenu[loop];	//write save map to screen
					Saving = 4;
				}	
				else if(Saving == 4){
					for(loop = 23; loop < 27; loop++)	//change back to lowercase
						SaveMenu[17][loop] = SaveMenu[17][loop] + 64;
					for(loop = 3; loop < 7; loop++)		//change save to CAPS
						SaveMenu[17][loop] = SaveMenu[17][loop] - 64;
					for(loop = 0; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
						bg2.mapData[loop] = pSaveMenu[loop];	//write save map to screen
					Saving = 1;
				}	
			}
		}
		if(!(CurrentKey & KEY_LEFT)){                //if the RIGHT key is pressed move right
			if(LastKey & KEY_LEFT){	//for debouncing
				if(Saving == 1){
					for(loop = 3; loop < 7; loop++)		//change save to lowercase
						SaveMenu[17][loop] = SaveMenu[17][loop] + 64;
					for(loop = 23; loop < 27; loop++)	//change back to CAPS
						SaveMenu[17][loop] = SaveMenu[17][loop] - 64;
					for(loop = 0; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
						bg2.mapData[loop] = pSaveMenu[loop];	//write save map to screen
					Saving = 4;
				}
				else if(Saving == 4){
					for(loop = 23; loop < 27; loop++)	//change back to lowercase
						SaveMenu[17][loop] = SaveMenu[17][loop] + 64;
					for(loop = 15; loop < 21; loop++)	//change rename to CAPS
						SaveMenu[17][loop] = SaveMenu[17][loop] - 64;
					for(loop = 0; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
						bg2.mapData[loop] = pSaveMenu[loop];	//write save map to screen
					Saving = 3;
				}	
				else if(Saving == 3){
					for(loop = 15; loop < 21; loop++)	//change rename to lowercase
						SaveMenu[17][loop] = SaveMenu[17][loop] + 64;
					for(loop = 9; loop < 13; loop++)	//change load to CAPS
						SaveMenu[17][loop] = SaveMenu[17][loop] - 64;
					for(loop = 0; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
						bg2.mapData[loop] = pSaveMenu[loop];	//write save map to screen
					Saving = 2;
				}	
				else if(Saving == 2){
					for(loop = 9; loop < 13; loop++)	//change load to lowercase
						SaveMenu[17][loop] = SaveMenu[17][loop] + 64;
					for(loop = 3; loop < 7; loop++)		//change save to CAPS
						SaveMenu[17][loop] = SaveMenu[17][loop] - 64;
					for(loop = 0; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
						bg2.mapData[loop] = pSaveMenu[loop];	//write save map to screen
					Saving = 1;
				}	
			}
		}
		if(!(CurrentKey & KEY_A)){	//if A is pressed
			if((Saving == 1) && (QuickSave > 0)){
				for(index = 0; index < 28; index++){		//save
					for(loop = 0; loop < 14; loop++)
						pSaveMemory[(loop*28)+index+(QuickSave*392)] = map[loop+1][index+1];
				}
				ExitSaveMenu();
			}
			else if(Saving == 2){					//load
				if(QuickSave > 0){
					for(index = 0; index < 28; index++){
						for(loop = 0; loop < 14; loop++)
							map[loop+1][index+1] = pSaveMemory[(loop*28)+index+(QuickSave*392)];
					}
				}
				else{
					for(index = 0; index < 28; index++){
						for(loop = 0; loop < 14; loop++)
							map[loop+1][index+1] = 0;
					}
				}
				ExitSaveMenu();
			}
			else if(Saving == 3){
				for(loop = 240; loop < 32*32; loop++) 		//32x32 tiles /2 if 16 bit copy
					bg2.mapData[loop] = pMap[loop];	//write keyboard to screen
				if(Y[0] < 12){		//if slot 0 (new/blank) selected
					Y[0] = 12;	//move sprite[0] to next line
					Y[2] = 2;	//sprite[0] char position
					QuickSave = 1;
				}
				X[0] = 20;		//move sprite[0]
				X[2] = 3;		//change sprite[0] char position
				UpdateSprite(0,1);	UpdateSprite(1,1);
				Saving = 5;
			}
			else if(Saving == 4)	ExitSaveMenu();	//return to main screen
		}
		if(!(CurrentKey & KEY_B))	ExitSaveMenu();	//if B is pressed, return to main screen
	}
	else if(!(CurrentKey & KEY_R)){
		y2 = Y[0];	x2 = X[0];
		if(!(CurrentKey & KEY_A)){		//if R and A is pressed
		        if(Y[0] < 108){	//check bounds
				Y[0] = Y[0]+8;	X[0] = 4;	//goto beginning of next line
				Y[2]++;	X[2] = 1;	//char position
			}
		}
		MoveSprite(0, x2, y2);
		CheckDPad(0);
	}
	else{
		CheckDPad(1);
		if(!(CurrentKey & KEY_L))   ShowHelp();	//if the L key is pressed display help screen
		if(!(CurrentKey & KEY_A)){       	//if the A key is pressed write text
			if(LastKey & KEY_A){			//Debounce
				if ((X[3] < 3) && (Y[3] == 1))
					map[Y[2]][X[2]] = 0;
				else if (Y[3] == 1)
					map[Y[2]][X[2]] = X[3] - 2 + (64 * LetterCase);
				else if (Y[3] == 2)
					map[Y[2]][X[2]] = X[3] + 14 + (64 * LetterCase);
				else if (Y[3] == 3)
					map[Y[2]][X[2]] = X[3] + 30 + (64 * LetterCase);
				for(loop = 0; loop < 32*32; loop++) //32x32 tiles /2 if 16 bit copy
					bg2.mapData[loop] = pMap[loop];	//rewrite map
				if(X[0] < 220){	
        				X[0] = X[0] + 8;	X[2] = X[2] + 1;	UpdateSprite(0,1);
				}
			}
		}
		if(!(CurrentKey & KEY_B))	//if the B key is pressed change case
			if(CurrentKey != LastKey)	ChangeCase();
		if(!(*KEYS & KEY_SELECT))	DispSaveMenu();
		if(!(*KEYS & KEY_START))	doReset();
	}
//	WaitTime(0,495000);
	LastKey = CurrentKey;		//for debouncing
}

int AgbMain(void){
	int x,y, loop;
	
	SetMode(MODE_4 | BG2_ENABLE ); //set mode 4

	for(loop = 0; loop < 256; loop++)
		paletteMem[loop] = FEARWAREPalette[loop];	//loop through and store the palette from FEARWARE
	
	for(y = 0; y < 160; y++)
	{
		for(x = 0; x < 120; x++)

		{
			PlotPixel(x,y,FEARWAREData[y*120+x]);//FEARWAREData contains the color values
			
		}
	}

	WaitTime(2,0); //Wait for 2 seconds, 0 milliseconds
	
	//set mode 2 and enable sprites and 1d mapping
	SetMode(MODE_1 | OBJ_ENABLE | OBJ_MAP_1D);  

//Let us set up the backgroud two structure and enable the background

	bg2.number = 2;				//background number 0-3
	bg2.charBaseBlock = 0;
	bg2.screenBaseBlock = 28;
	bg2.colorMode = BG_COLOR_256;
	bg2.size = ROTBG_SIZE_256x256;
	bg2.mosiac = 0;
	bg2.x_scroll = 4;
	bg2.y_scroll = 4;

//This call enables the background with the suplied attributes and when it returns
//bg2.mapdata and tiledata will be valid pointers to the correct place
//for the map and tile data in VRAM
	
	EnableBackground(&bg2);

//Now let us copy in the background tile palette
	for(loop = 0; loop < 256; loop++)
		BGPaletteMem[loop] =KEEPERPalette[loop];
//now for the actual tile graphics created by pcx2sprite 
	for(loop = 0; loop < KEEPER_WIDTH * KEEPER_HEIGHT /2; loop++)
		bg2.tileData[loop] =KEEPERData[loop];
//now the map
	for(loop = 0; loop < 32*32; loop++) //32x32 tiles /2 if 16 bit copy
		bg2.mapData[loop] = pMap[loop];


//Copy sprite palette to memory(same palette for all sprites)
	for(loop = 0; loop <256; loop++)
		OBJPaletteMem[loop] = UPPERPalette[loop];
//Set sprites to be displayed offscreen
	InitializeSprites();
	sprites[0].attribute2 = 8;								//first sprite
	UpdateSprite(0,1);
	sprites[1].attribute2 = 0;
	UpdateSprite(1,1);
//Copy sprite image data into memory
	for(loop = 0; loop < 256; loop++)
		OAMData[loop] = UPPERData[loop];

	//Wait for the screen to stop drawing
	WaitForVsync();
	//Copy sprite array to OAM
	CopyOAM();
	while(1)
	{
		GetInput();
	}

	return(1);
}
