//reset.c brouight to you by herg
#include "gba.h"

//extern void AgbMain(void);
extern u8 __boot_method;

/***************************************************************
  Reset the GBA
***************************************************************/
void doReset(void)
{
#define ROM_START (u16 *)(0x096B592E)
#define WRITE_LOC_1 (volatile u16 *)(0x987654*2+0x8000000)
#define WRITE_LOC_2 (volatile u16 *)(0x012345*2+0x8000000)
#define WRITE_LOC_3 (volatile u16 *)(0x007654*2+0x8000000)
#define WRITE_LOC_4 (volatile u16 *)(0x765400*2+0x8000000)
#define WRITE_LOC_5 (volatile u16 *)(0x013450*2+0x8000000)
  u16 i;

  // only try to reset like this if we booted from a ROM...
  if(__boot_method == 0)
  {
	  for(i=0;i<1;i++) *WRITE_LOC_1=0x5354;
	  for(i=0;i<500;i++) *WRITE_LOC_2=0x1234;
	  for(i=0;i<1;i++) *WRITE_LOC_2=0x5354;
	  for(i=0;i<500;i++) *WRITE_LOC_2=0x5678;
	  for(i=0;i<1;i++) *WRITE_LOC_1=0x5354;
	  for(i=0;i<1;i++) *WRITE_LOC_2=0x5354;
	  for(i=0;i<1;i++) *WRITE_LOC_4=0x5678;
	  for(i=0;i<1;i++) *WRITE_LOC_5=0x1234;
	  for(i=0;i<500;i++) *WRITE_LOC_2=0xabcd;
	  for(i=0;i<1;i++) *WRITE_LOC_1=0x5354;	

	  *ROM_START=0;
#if defined __GNUC__
		asm("swi 1");
		asm("swi 0");
#else
	  __asm
	  {
		swi		1
		swi		0
	  }
#endif
  }
  
  //If you make it to here, you're probably running in an emu
  //that doesn't support BIOS calls.  We'll just fake it
  //AgbMain();
}

