/**************************************************************************
*    Ascii Paint 0.4a by Toby Jacobs - AKA Tobriand                        *
*    Makefile from one of Mr_Mirko's examples - Thanks Mr_Mirko!          *
*    There's no way I could have written my own yet!                      *
*    Framebuffer and clearing code by Synkro from his "Hello World"       *
*    tutorial. If you're new to C++ for the GP and don't know where to    *
*    start, there's nowhere better imo than that tutorial. Thanks Synkro! *
*    Delay code from Don on the GP32x boards - and its a lot cleaner than *
*    what I had before, I can tell you! So thanks Don, too :)             *
*                                                                         *
*    Coded using Mr_Mirko's SDK 0.7 and Devkitadvance combined and made   *
*    compile after a long time of sitting there doing nothing. Thanks     *
*    again Mr_Mirko - your SDK is unbelievably clearer to the novice      *
*    programmer than the official one!                                    *
*                                                                         *
*    Special thanks go to Herb12 who helped me fiddle with a fair bit of  *
*    code yesterday when I was still very very very green around the edges*
*    as opposed to just very very green.                                  *
***************************************************************************/

#include <gp32.h>            // Includes the SDK header with all definitions
#include <string.h>          // Includes a file called string.h that supposedly
                             // lets me manipulate strings better. I don't think it works.

unsigned short *framebuffer; // A framebuffer pointer


////////////////////////////////////////////////////////////////////////////////
/////////////////////////Don's Delay function - thanks Don//////////////////////
////////////////////////////////////////////////////////////////////////////////

void Delay(int ticks)
{
       gp_InstallRTC();
       int i=0;
       gp_ResetRTC();
       while(i!=ticks)
       {
               i=gp_GetRTC();
       }
}

////////////////////////////////////////////////////////////////////////////////

void main(void)
{
  framebuffer = (unsigned short*) FRAMEBUFFER;
  // We point the framebuffer pointer to a memory area used
  // for the screen. We manipulate the screen by manipulating
  // this framebuffer.

  gp_SetScreen(framebuffer, 16);
  // We set the framebuffer into 16bit mode. We will always use
  // the 16bit mode because I am to lazy to write about palette
  // handling and it is just the best screen mode.

  int i;
  for (i=0; i<320*240; i++) framebuffer[i]=0xFFFF;
  // Though the screen is two dimensional, it is possible
  // to access the framebuffer linear. All data in memory
  // is aligned the same way. In this loop we set every
  // pixel white (0xFFFF), we clear the screen.

  gp_SetCpuSpeed(66);
  // We set the CPU clock to 66MHz. It compromises battery
  // life and performance. This is also the normal GP32 speed.

/**********************************************************************
*         Universal Variable Initialisation Stage                     *
**********************************************************************/
  
  int x_pos   = 150;     // This int stores the x-position of the cursor

  int y_pos   = 110;

  int length  = 1;     // length of the char[] to be drawn - in theory 
                       // I could get rid of this and replace every "length" in
                       // the code with 1, but its just possible a future version
                       // might need it somewhere, so I've left it in.

  int color   = 0x0000; // The colour of the brush currently in use. "0x" says
                        // the value is in HEX, then each of the characters after
                        // that are for RED, GREEN, and BLUE respectively, followed
                        // by the INTENSITY (alpha?) channel.

  int colornumb = 0; // The current index of colour used - not many at the moment, 
                     // since too many would just be annoying if you went past the
                     // one you were after

  int brushnumb = 0; // The current index of brush used; again, not too many, but not too
                     // few, I think, either.

  char brush[1] = "^";   // The current character of brush. Note how it is initially given
  brush[0] = '^';        // a value using the " sort of quotation mark. This should only
                         // be done the first time, however, as a char actually stores
                         // a from 0-255 which corresponds to a character. The single
                         // quote - ' - is used to say that you want to retrieve the number
                         // that whatever is inside them comes out as as opposed to the 
                         // characters themselves. It just so happens, though, that for char
                         // variables that's exactly what the number is. Whereas the character
                         // is just gobbledegook.

  int ticks = 0;     // Don's ticks variable for the Delay counter. Its here to make sure
                     // its a universal, since otherwise some errors turn up when compiling
                     // whether they should or not.
    
  int x_pos_array;      // These three integer values will be used to store the co-ordinates
  int y_pos_array;      // of each drawn character in an array. x_pos_array for x, y_pos_array
  int linear_pos_array; // for y and linear_pos_array for the converted value as a linear 
                        // referece (pretty much as with framebuffers, but more smaller).

  char TotalArray[2814]; // This is the array into which we're going to dump colour and 
                         // brush data for saving and loading purposes.
  for (i=0; i<936; i++) // The playfield is 26x36, so that gives 936 as a resolution
   {                    // This loop is initialising the whole lot. Note the lack of ''s
    TotalArray[i] = 0;  // here; that's because for the first part - brushes - we want blank
                        // data when there's nothing there, and the ascii "space" character
                        // is at 0.
    TotalArray[939 + i] = '0'; // For colour, on the other hand, we're setting it to the char
                               // 0, since that will in due course be of more use.
    TotalArray[1878 + i] = 58; // For the brush index, which is much better for re-calculating
                                // the brush when loading
   };
  for (i=0; i<936; i=i+36)
   {
    TotalArray[i] = '\n'; // Now you see why its 36 and not 35; at the end of each line we
                          // want a line-break, so we stick one in every 36 characters :)
    TotalArray[i+939] = '\n'; // You can also see how a different bit of the array is used 
                              // here for colour by adding a fair whack onto i. This avoids
                              // another loop, so overall it should be a bit faster. Maybe.
    TotalArray[i+1878] = '\n';
   };
  TotalArray[936] = '\n'; // Now we're just setting up the 2 blocks so that they're separate
  TotalArray[937] = '-';  // This is done last, as otherwise a badly configured for loop might 
  TotalArray[938] = '\n'; // wipe over what we actually want there - a line break, a - and
  TotalArray[1875] = '\n';// another break.
  TotalArray[1876] = '-';
  TotalArray[1877] = '\n';

  int *pTotalArray; // This variable you'll note doesn't look like the others. That's 
                    // because its a pointer, not a standard variable - note the *
                    // before the name. A pointer stores a memory address rather than
                    // what is actually stored there - and so is particularly useful 
                    // when loading raw data from one variable to another incompatible
                    // type (possibly - I'm not very familiar with them), or, as we will
                    // do, loading in data from a file that doesn't hve any innate
                    // address to go to. The p is apparrently a convention to say its
                    // a pointer, as the * won't actually be used when we refer to it.

  pTotalArray = &TotalArray; // This *should* set it to the address of TotalArray - that's
                             // what "&" does aparrently.

 // These are where colours and brushes (except the first one) get retrieved from. They
 // avoid a LOT of if statements all over the place and generally make the code more elegant.
 // If you want to add either a colour or a brush, this is partly where you do it.
  int colorbank[7] = {0x0000, 0xF000, 0x0F00, 0x00F0, 0xF0F0, 0xFF00, 0x0FF0, 0xFFFF};     
  char brushbank[] = "^=0-|#~\\/N";

 // directory1 is a string which we store where we're going to load/save from. Here, we
 // create is, and then we correct it. It would be very very easy to create it *as* 
 // ASCIIART.TXT - change the J to an R - but I've kept in the J and changed it to an R one
 // line later because that is a good reminder of *how* strings can be manipulated. It took
 // me a LONG time to work it out (I tried this about 7 times before I got a working one).
  char directory1[32] = "dev0:\\GPMM\\ASCIIART\\ASCIIAJT.TXT";
  directory1[26] = 'R';
  int *pdirectory1 = &directory1;

 // This line loads the last saved file into memory from a constant save-file "LASTOPEN.TXT"
 // One thing to notice is how I've had to manually re-apply the null string character
 // at the end of it once loaded - that's because it doesn't seem to save it as a \0, but
 // rather as a space. I've also put the \\ es in just to be on the safe side (the other 
 // character that gets replaced by C) though they *probably* aren't necessary.
  smc_read("dev0:\\GPMM\\ASCIIART\\LASTOPEN.TXT",pdirectory1,0,sizeof(directory1));
  directory1[5] = '\\';
  directory1[10] = '\\';
  directory1[19] = '\\';
  directory1[32] = '\0';

 // These three are used when drawing the save name in the intro. As with a few others, its
 // very possible I could get rid of them and just use brush/brushnumb, but this way works
 // and acts as a bookmark to the code using it (CTRL-F directorybrush).
  char directorybrush[] = "A";
  int directorybrushnumb = 0;
  directorybrush[0] = directory1[20];

 // This basically sets whether or not to run the LoadItAll() function when re-drawing
 // everything. If set to 1, it will, otherwise, it won't.
  int loadornot = 1;


  


/***********************************************************************
*                    Toolkit Drawing Function                          *
************************************************************************/

  void Toolkit()
   {
    // These lines draw the list of characters on the left side of the screen.
    // The "if/else" switch is used so that when the field is cleared by pressing
    // Start, you still get a red one of the brush you're using. Otherwise, either
    // one brush would always be red after a clear, whether or not it were the correct
    // one, or none of them would be until you changed brushes.

    if (brushnumb != 0)                                  // If the variable brushnumb is not
                                                         // equal to 0 - i.e. if the "^" brush
                                                         // is not selected...
     {gp_SetFont8(5, 10, 1, "^", 0x0000, framebuffer);}  // ... then do this, and create a
                                                         // black "^" at co-ordinates (5,10)
     else                                                // If on the other hand, it IS the
                                                         // current brush...
     {gp_SetFont8(5, 10, 1, "^", 0xF000, framebuffer);}; // make that a red one (0xF000 is red)

    if (brushnumb != 1)                                  // Note how now we're testing for 
                                                         // brushnumb not being 1 - that's
                                                         // because 1 is "=", the second
                                                         // brush.
     {gp_SetFont8(5, 18, 1, "=", 0x0000, framebuffer);}
     else
     {gp_SetFont8(5, 18, 1, "=", 0xF000, framebuffer);};
    if (brushnumb != 2) 
     {gp_SetFont8(5, 26, 1, "0", 0x0000, framebuffer);}
     else
     {gp_SetFont8(5, 26, 1, "0", 0xF000, framebuffer);};
    if (brushnumb != 3) 
     {gp_SetFont8(5, 34, 1, "-", 0x0000, framebuffer);}
     else
     {gp_SetFont8(5, 34, 1, "-", 0xF000, framebuffer);};
    if (brushnumb != 4) 
     {gp_SetFont8(5, 42, 1, "|", 0x0000, framebuffer);}
     else
     {gp_SetFont8(5, 42, 1, "|", 0xF000, framebuffer);};
    if (brushnumb != 5) 
     {gp_SetFont8(5, 50, 1, "#", 0x0000, framebuffer);}
     else
     {gp_SetFont8(5, 50, 1, "#", 0xF000, framebuffer);};
    if (brushnumb != 6) 
     {gp_SetFont8(5, 58, 1, "~", 0x0000, framebuffer);}
     else
     {gp_SetFont8(5, 58, 1, "~", 0xF000, framebuffer);};
    if (brushnumb != 7) 
     {gp_SetFont8(5, 66, 1, "\\", 0x0000, framebuffer);}
     else
     {gp_SetFont8(5, 66, 1, "\\", 0xF000, framebuffer);};
    if (brushnumb != 8) 
     {gp_SetFont8(5, 74, 1, "/", 0x0000, framebuffer);}
     else
     {gp_SetFont8(5, 74, 1, "/", 0xF000, framebuffer);};
    if (brushnumb != 9) 
     {gp_SetFont8(5, 82, 1, "N", 0x0000, framebuffer);}
     else
     {gp_SetFont8(5, 82, 1, "N", 0xF000, framebuffer);};

    // These two lines create the colour blob under the tools.
    // Note how I couldn't find the ascii character for a square, so I used
    // the combination of N and | on top of one another, which covers most points around.

    gp_SetFont8(5, 100, 1, "N", color, framebuffer);
    gp_SetFont8(5, 100, 1, "|", color, framebuffer);

    
    // Now we draw the field with the next few bits.

    for (y_pos=10; y_pos < 220; y_pos = y_pos + 8) // If you've never come across a for loop
                                                   // before, you have now. This one sets
                                                   // our starting y position to 10 pixels
                                                   // in from the top, tells the loop to 
                                                   // continue until y_pos is no longer less
                                                   // than 220 in, and at the end of each
                                                   // iteration to add an additional 8 pixels
                                                   // to the counter.
     { 
        gp_SetFont8(15, y_pos, 1, "|", 0x0000, framebuffer);  // This line draws a black "|"
                                                              // on the left of the field
        gp_SetFont8(300, y_pos, 1, "|", 0x0000, framebuffer); // whilst this one does the 
                                                              // right side.
     };

    for (x_pos=19; x_pos < 298; x_pos = x_pos + 5) // As with the one for the vertical lines
                                                   // this for loop manages the horizontal
                                                   // ones. Note that we're adding less than
                                                   // 8 here, as the "-" character is slightly
                                                   // too short.
     { 
        gp_SetFont8(x_pos, 7, 1, "-", 0x0000, framebuffer); // We're drawing 2 lines, also,
        gp_SetFont8(x_pos, 8, 1, "-", 0x0000, framebuffer); // as its somewhat thinner too.
        gp_SetFont8(x_pos, 221, 1, "-", 0x0000, framebuffer);
        gp_SetFont8(x_pos, 222, 1, "-", 0x0000, framebuffer);
     };
    gp_SetFont8(298, 221, 1, "-", 0x0000, framebuffer); // These 4 lines finish off the right
    gp_SetFont8(298, 222, 1, "-", 0x0000, framebuffer); // side of the horizontal bounds.
    gp_SetFont8(298, 7, 1, "-", 0x0000, framebuffer);   // Using 1 instead of 5 earlier would
    gp_SetFont8(298, 8, 1, "-", 0x0000, framebuffer);   // have removed their need, but slowed
                                                        // down the loop a LOT too...

   }
/////////////////////////////////END OF TOOLKIT FUNCTION///////////////////////////////////

/******************************************************************************************
*                                   Colour Changing Function                              *
*******************************************************************************************/
  void ColorChange(signed int plusorminus) // We start the colour changing code here.
                                           // If you haven't come across functions with
                                           // parameters before, here's your first. Basically
                                           // it means rather than calling the function
                                           // as ColorChange(), it is called as ColorChange(1)
                                           // or similar, and that one can then be used in
                                           // calculation.
   {
     if (plusorminus == 1) // Like here, for example, we test to see if it is 1.
      {colornumb ++;}      // if it is, we add one to colornumb - our retrieval value from
                           // the bank (++ = +1 to self).
     else
      {colornumb --;};     // if not, we take one away.

     if (colornumb == 8)   // Then we make certain that colornumb isn't too big or too small
      {colornumb = 0;};    // if it were, it would return a null value from the color array
     if (colornumb == -1)  // and the chances are nothing would happen. But it could start
      {colornumb = 8;};    // picking up colours from elsewhere in memory eventually, and just
                           // look strange

     color = colorbank[colornumb]; // Now we pull off a fairly cunning stunt. Earlier, we
                                   // created an array called colorbank with a series of 
                                   // hexadecimal numbers in them which act as common colours
                                   // Now, we pick out the colour at the index "colornumb"
                                   // from there, and use it as the value of "color". The 
                                   // alternative would be a lot of if statements.

     gp_SetFont8(x_pos, y_pos, 1, brush, color, framebuffer); // These lines create the swab
     gp_SetFont8(5, 100, 1, "N", color, framebuffer);         // of colour on the left, just
     gp_SetFont8(5, 100, 1, "|", color, framebuffer);         // so you know what you're painting
                                                              // with
     Delay(10); // And lastly, we delay, so it doesn't just flicker and allows people
                // time to choose their colour.
   }

//////////////////////////////END OF COLOUR CHANGING FUNCTION//////////////////////////////

/******************************************************************************************
*                                Loading function                                         *
*******************************************************************************************/

 // This function loads everything from the saved file on the SMC back into memory, before
 // stuffing it fairly crudely back onto the page, complete with colour data I didn't think
 // I'd be able to keep originally (irony of ironies, it's been a LOT easier to do than brush
 // data).
  void LoadItAll()
  {

  // Firstly we load everything from ASCIIART.TXT (or wherever) into memory at the address
  // found in the pointer pTotalArray - pointing at the start of TotalArray. The file offset
  // is 0, since we're reading and parsing everything (much easier than loading individual 
  // sections, which offset could be used for - and a lot more efficient, too, unless there 
  // were to be more than 1 drawing in the file - which at the moment isn't how it works.)
   smc_read(directory1,pTotalArray,0,sizeof(TotalArray));

  // We now set x and y positions to the place where the first character would be - (22,14)
  // is the character in the top left of the drawing field.
   x_pos = 22;
   y_pos = 14;

/* This bit of code may one day help in the use of coloured backgrounds. However, right at
   the moment, I can't be arsed to do them.
  int i;
  int n;
  for (i=0; i<2000; i++) 
   {
    y_pos_array = (y_pos - 6)/8;
    x_pos_array = (x_pos - 14)/8;
    linear_pos_array = (x_pos_array) + ((y_pos_array - 1) * 36);
    n = (22 * (i+1)) + 14*(i);
    framebuffer[i]=0xFF0F;    
   };
*/

  // And now we fill up the drawing field - 936 is how big it is in linear terms, as may 
  // already have been mentioned. This for loop works through each "pixel" and puts colour
  // and brush data into it.
   for(i=1; i<936; i++)
    {
     int brushnumb2; // An integer we need to store the brush number in; we could
                     // probably use brushnumb, but we'd have to reset it at the end, anyway
                     // so there'd be little point imo.


    // Now we load brushnumb2 and colornumb with data from the array - the -48 converts it 
    // from character data stored in the file (48 = '0', 49 = '1' etc., so '0' - 48 = 0)
    // Note we aren't even bothering with the first part of the array. That's because the 
    // only point to that at all is in making ascii drawings viewable in Notepad or Metapad
    // or whatever; data from 0-936 gets stored, but never loaded.
     brushnumb2 = (TotalArray[i+1878] -48);
     colornumb = (TotalArray[i+939] - 48);
     brush[0] = brushbank[brushnumb2];

    // Once upon a time there were 10 if statements here to drawy everything we'd just loaded
    // correctly. I've got it down to a line and one if statement - mainly because for some 
    // reason, brushnumb2 IS 0, it doesn't draw anything in the first place. Technically,
    // I suppose, this is a hack, since it doesn't find out *why* it doesn't do anything,
    // but it works and it doesn't put that much more strain on the processor, so there we 
    // go.
     gp_SetFont8(x_pos, y_pos, 1, brush, colorbank[colornumb], framebuffer);
     if (brushnumb2==0) gp_SetFont8(x_pos, y_pos, 1, "^", colorbank[colornumb], framebuffer);
          
     if (x_pos < 302) x_pos = x_pos + 8;
     if (x_pos == 302)
      {
       if (y_pos < 214) y_pos = y_pos + 8;
       x_pos = 22;
       i++;
      };
    };
  // Brush and colour data are now set to what they're specified as in their appropriate
  // arrays, which should mean we don't run into mis-draws all over the place.
   brush[0] = brushbank[brushnumb];
   if (brushnumb == 0) brush[0] = '^';
   color = colorbank[colornumb];
  // In addition, the correct colour has to be dumped to the swab, or we get slightly 
  // strange (although irrelevent) results there.
   gp_SetFont8(5, 100, 1, "N", color, framebuffer);
   gp_SetFont8(5, 100, 1, "|", color, framebuffer);

   Delay(10);
  }

//////////////////////////////END OF LOADING FUNCTION//////////////////////////////////////

/******************************************************************************************
*                     Function to draw from the array without loading it                  *
******************************************************************************************/
// This function is identical to the function LoadItAll(), except that it doesn't read the
// SMC into memory first. Maybe I'll combine the two, though I doubt it; they work fine 
// separately.
void DrawFromBuffer()
{
   x_pos = 22;
   y_pos = 14;
   for(i=1; i<936; i++)
    {
     int brushnumb2; 
     brushnumb2 = (TotalArray[i+1878] -48);
     colornumb = (TotalArray[i+939] - 48);
     brush[0] = brushbank[brushnumb2];
     gp_SetFont8(x_pos, y_pos, 1, brush, colorbank[colornumb], framebuffer);
     if (brushnumb2==0) gp_SetFont8(x_pos, y_pos, 1, "^", colorbank[colornumb], framebuffer);
          
     if (x_pos < 302) x_pos = x_pos + 8;
     if (x_pos == 302)
      {
       if (y_pos < 214) y_pos = y_pos + 8;
       x_pos = 22;
       i++;
      };
    };
   brush[0] = brushbank[brushnumb];
   if (brushnumb == 0) brush[0] = '^';
   color = colorbank[colornumb];
   Delay(10);
}

//////////////////////////////END OF DRAWING FROM ARRAY CODE///////////////////////////////







void ActualProggy()
{
 /***********************************************************************
 *             First positioning of the cursor                          *
 ***********************************************************************/
  
  int q = 1;
  
  Toolkit(); // Now we actually draw the toolkit and bounds

 // This loads the specified file from the SMC (the one in directory1) IF, and only if,
 // loadornot == 1. If it doesn't, then it draws the screen directly from the existing
 // array - so if you want to effectively resave a drawing in a different filename, you
 // can drop to the menu, set load off, change the name, and come back, and it SHOULD be
 // much the same or identical to what it was.
  if (loadornot == 1) {LoadItAll();} else {DrawFromBuffer();}; 

 // Having done that, we need to go back to some decent 
 // values of x_pos and y_pos. We couldn't put them inside Toolkit since doing so would 
 // have messed up the clearing routing on pressing start, which is basically running
 // Toolkit() again.

  x_pos = 150;
  y_pos = 110;
  gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);
  
  
 /****************************************************************************************
 *                                The Main Loop                                          *
 *                                                                                       *
 *  This is the loop within which everything happens. Whilst we're already inside Main(),*
 *  to allow that to repeat normally would mean we probably would get flickering since   *
 *  I am not doublebuffering, and certainly would get anything drawn erased every time a *
 *  button was released. So instead we've got a "while" loop repeating for (1) - i.e.    *
 *  always.                                                                              *
 *****************************************************************************************/

  while(q==1)
  {
  // At the end of each time through this loop (i.e. when no buttons are pressed), it
  // stores character and colour numbers into the save array. There are MUCH more detailed
  // descriptions of each line elsewhere, so I'm not going to bother here.
  // The main reason to do it outside buttons being pressed as well as inside, is that 
  // occasionally when erasing, the last square ended on (which should be allowed to be drawn)
  // isn't, at least in the save array.
   y_pos_array = (y_pos - 6)/8;
   x_pos_array = (x_pos - 14)/8;
   linear_pos_array = (x_pos_array) + ((y_pos_array - 1) * 36); 
   TotalArray[linear_pos_array] = brush[0];
   TotalArray[linear_pos_array + 939] = 48 + colornumb;
   TotalArray[linear_pos_array + 1878] = 48 + brushnumb;
   
   gp_ButtonInit(); // Initialise the button-taking system. Without this, we couldn't
                    // test for results of a given button and go any further. Which would
                    // suck.

   /******************************************************************************
   *                               Movement Code                                 *
   *******************************************************************************/


   // Up

   while (gp_ButtonResult()&BUP) // Tests for the recent pressing of the pad in the up
                                 // direction, and continues to execute as long as that
                                 // is the case - until up is released. From what I can
                                 // tell, if up is released in the middle of a loop, though,
                                 // that loop will finish its current time through before
                                 // finding that the condition for it is no longer true.
    {
    // First we set the cursor to the current colour (no need for erased anymore - that's
    // all handled in the erasing section).
     gp_SetFont8(x_pos, y_pos, length, brush, color, framebuffer);

     y_pos_array = (y_pos - 6)/8;  // This line converts the y co-ordinate in pixels to a
                                   // co-ordinate in squares within the grid.
     x_pos_array = (x_pos - 14)/8; // Likewise, but for the x value.
     linear_pos_array = (x_pos_array) + ((y_pos_array - 1) * 36); // We then have to make
                                                                  // them into a linear
                                                                  // position to store.
     TotalArray[linear_pos_array] = brush[0];              // This line and the next store the
     TotalArray[linear_pos_array + 939] = 48 + colornumb;  // values in 2 an array that can 
     TotalArray[linear_pos_array + 1878] = 48 + brushnumb; // then be written to disk as a
                                                           // nice small text file.

    // This if switch tests to see if the cursor is too close to the edge of the drawing
    // field. If it isn't, then the cursor is moved up; if not, then it does nothing.
     if (y_pos > 14) {y_pos = y_pos - 8;};

    // The next 4 lines just stick a blank on top of where the red cursor is going to go.
    // Much as I prefer the ability to have composite characters, since I cannot save them
    // (at least, not without fiddling around with vectors and screwing saving and loading
    // code up completely), I'd much rather get rid of them completely so no-one gets
    // disappointed when their drawing doesn't show up like it was supposed to.
    // If anyone wants to re-implement them, just get rid of these 4 lines in each of the
    // directions.
     gp_SetFont8(x_pos, y_pos, 1, "N", 0xFFFF, framebuffer); 
     gp_SetFont8(x_pos, y_pos, 1, "|", 0xFFFF, framebuffer); 
     gp_SetFont8(x_pos, y_pos, 1, "#", 0xFFFF, framebuffer);
     gp_SetFont8(x_pos, y_pos, 1, "^", 0xFFFF, framebuffer);

    // The new position of the cursor is now painted and set to red so it is obvious where
    // it is (unless the colour IS red, of course, which is annoying, but inevitable).
     gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);

    // A 10 tick delay is requested so as to avoid a cursor moving fast enough to skin an 
    // antelope and destroy any ability to draw that might otherwise exist.
     Delay(10); 
    };

   // Down - as for up, so not commented
   while (gp_ButtonResult()&BDOWN)
    {
     gp_SetFont8(x_pos, y_pos, length, brush, color, framebuffer);
     y_pos_array = (y_pos - 6)/8;
     x_pos_array = (x_pos - 14)/8;
     linear_pos_array = (x_pos_array) + ((y_pos_array - 1) * 36);
     TotalArray[linear_pos_array] = brush[0];
     TotalArray[linear_pos_array + 939] = 48 + colornumb;
     TotalArray[linear_pos_array + 1878] = 48 + brushnumb;
     if (y_pos < 214) {y_pos = y_pos + 8;};
     gp_SetFont8(x_pos, y_pos, 1, "N", 0xFFFF, framebuffer); 
     gp_SetFont8(x_pos, y_pos, 1, "|", 0xFFFF, framebuffer); 
     gp_SetFont8(x_pos, y_pos, 1, "#", 0xFFFF, framebuffer);
     gp_SetFont8(x_pos, y_pos, 1, "^", 0xFFFF, framebuffer);
     gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);
     Delay(10);
    };

   // Left - as for up, so not commented
   while (gp_ButtonResult()&BLEFT)
    {
     gp_SetFont8(x_pos, y_pos, length, brush, color, framebuffer);
     y_pos_array = (y_pos - 6)/8;
     x_pos_array = (x_pos - 14)/8;
     linear_pos_array = (x_pos_array) + ((y_pos_array - 1) * 36);
     TotalArray[linear_pos_array] = brush[0];
     TotalArray[linear_pos_array + 939] = 48 + colornumb;
     TotalArray[linear_pos_array + 1878] = 48 + brushnumb;
     if (x_pos > 22) {x_pos = x_pos - 8;};
     gp_SetFont8(x_pos, y_pos, 1, "N", 0xFFFF, framebuffer); 
     gp_SetFont8(x_pos, y_pos, 1, "|", 0xFFFF, framebuffer); 
     gp_SetFont8(x_pos, y_pos, 1, "#", 0xFFFF, framebuffer);
     gp_SetFont8(x_pos, y_pos, 1, "^", 0xFFFF, framebuffer);
     gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);
     Delay(10);
    };

   // Right - as for up, so not commented
   while (gp_ButtonResult()&BRIGHT)
    {
     gp_SetFont8(x_pos, y_pos, length, brush, color, framebuffer);
     y_pos_array = (y_pos - 6)/8;
     x_pos_array = (x_pos - 14)/8;
     linear_pos_array = (x_pos_array) + ((y_pos_array - 1) * 36);
     TotalArray[linear_pos_array] = brush[0];
     TotalArray[linear_pos_array + 939] = 48 + colornumb;
     TotalArray[linear_pos_array + 1878] = 48 + brushnumb;
     if (x_pos < 294) {x_pos = x_pos + 8;};
     gp_SetFont8(x_pos, y_pos, 1, "N", 0xFFFF, framebuffer); 
     gp_SetFont8(x_pos, y_pos, 1, "|", 0xFFFF, framebuffer); 
     gp_SetFont8(x_pos, y_pos, 1, "#", 0xFFFF, framebuffer);
     gp_SetFont8(x_pos, y_pos, 1, "^", 0xFFFF, framebuffer);
     gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);
     Delay(10);
    }; 

  /*************************************************************************
  *                       Colour Changing Code                             *
  **************************************************************************/

   if (gp_ButtonResult()&BR) // On pressing the R shoulderpad, this switch is brought
                             // into effect. Note the use of an if switch, since I don't
                             // actually want it to loop - although I suspect it may do
                             // anyway.
    {
     ColorChange(1); // Earlier you saw the function to change colours - now we call
                     // it. The 1 is to tell that function which direction to move.
                     // I had planned to have A+R = colours forward, and A+L converse
                     // but unfortunately in this context, it executes the brush-changing
                     // code in preference. I'll find a way round it but not yet.

     y_pos_array = (y_pos - 6)/8;  // Now we add the new colour to the Array as per normal.
     x_pos_array = (x_pos - 14)/8; // This line ans the one above convert x_pos/y_pos to 
                                   // array-relative co-ordinates,
     linear_pos_array = (x_pos_array) + ((y_pos_array - 1) * 36); // and this then further
                                                                  // converts to a linear
                                                                  // version.
     TotalArray[linear_pos_array] = brush[0];              // These lines then store brush
     TotalArray[linear_pos_array + 939] = 48 + colornumb;  // colour index
     TotalArray[linear_pos_array + 1878] = 48 + brushnumb; // and brush index    
    }                                                      // to the array for later saving.
 
  /***************************************************************************
  *                         Brush-changing code                              *
  *                                                                          *
  * This is the code to change brushes. Unlike with colours, its somewhat    *
  * more awkward to change a brush since there are 3 places where they are   *
  * stored, but its still fairly easy. Adding a brush is another matter,     *
  * though, if only becuase we'd have to move the colour splat as well.      *
  ****************************************************************************/

   // This code executes when the L button is held/pressed, and changes the brushes
   // as said above.
   if (gp_ButtonResult()&BL)
    {

    // Firstly, we paint the current brush in the toolkit black. Doing this now saves a lot
    // of hastle later, and also means we can avoid creating another variable. Of course,
    // the reason we do it is to give the impression of the red highlighting of the selected
    // brush. The current one starts red - so we set it black. The number, (10 + 8*brushnumb))
    // is obtained by taking the y-position of the first brush (10) and adding to it 8 lots
    // of brushnumb - 8 because that's how far apart they are. Interestingly, brushnumb itself
    // does *not* need to be added or taken from (as I originally thought) since the first is
    // at 10 + 0*8 = 10 pixels in. Which was lucky :).
     gp_SetFont8(5, (10 + 8*(brushnumb)), 1, brush, 0x0000, framebuffer);

     brushnumb ++; // Then we add one to brushnumb. Since this function was written after I
                   // realised that having combined buttons for forward/backward in a set
                   // of options (brushes/colours) didn't work the way I'd come up with, it
                   // isn't triggered based on a parameter. Brush selection only works one
                   // way, but at least it tells you where it is at any one moment.

     if (brushnumb == 10) brushnumb = 0; // There are 10 brushes (including 0)
                                         // so we've got to reset brushnumb if we increase
                                         // it to 10. Wow. The adventure.

    // This erases the current position where whe cursor is so we don't get nasty overlay
    // errors. Don't mistake this kind of erasing, though, for that done with the erase
    // function - this selectively erases the current brush before we've actually set the
    // new brush up.
     gp_SetFont8(x_pos, y_pos, 1, brush, 0xFFFF, framebuffer);


    // Now we set up the new brush. For some reason, something almost identical to this 
    // didn't work when I was first coding the brush function, which lead to the bloat that
    // it was before this more optimised one.
     brush[0] = brushbank[brushnumb];
     if (brushnumb==0) brush[0] = '^';

    // Once again you see the (10 + 8*(brushnumb)) expression which we're painting to - this
    // time in red (0xF000). You'll notice that this one is based *after* adding to brushnumb
    // and even correcting for a too big result, so its basically the name line as before.
    // It just has its effect somewhere else and with a different brush head.
     gp_SetFont8(5, (10 + 8*(brushnumb)), 1, brush, 0xF000, framebuffer);

    // This line writes the new brush head to the current position of the cursor.
     gp_SetFont8(x_pos, y_pos, 1, brush, color, framebuffer);

    // Then we finally dump all the new information (including brush changes) into the save
    // array. There's a better explanation line-by-line in the colour-changing code, but
    // simply, we calculate the position of the cursor in the array as a linear value, and
    // then dump data involving the brush at that point, colornumb at one 939 (a full 
    // "resolution" away plus a break line or two) points ahead, and brushnumb (what we
    // actually use to recreate the brush) at one 939 or so ahead of *that*.
     y_pos_array = (y_pos - 6)/8;  
     x_pos_array = (x_pos - 14)/8; 
     linear_pos_array = (x_pos_array) + ((y_pos_array - 1) * 36);
     TotalArray[linear_pos_array] = brush[0];
     TotalArray[linear_pos_array + 939] = 48 + colornumb;
     TotalArray[linear_pos_array + 1878] = 48 + brushnumb;
     
     Delay(10); // Add in that nice delay so people don't just see duguhduguhduguh - phwoomph
                // and an apparrently random brush appearing, but rather, a nice, smooth, 
                // scrolling side selection and quickly - but manageably - fast changing
                // cursor.
    };

  /*********************************************************************************
  *                                Erase Head code                                 *
  **********************************************************************************/

   // Fairly obviously the loop is called when the B button is pressed
   while (gp_ButtonResult()&BB) // If you looked at this function in earlier versions, you'd
                                // have found an if switch, not a loop. The reason for this
                                // was because B simply erased the square the cursor was on.
                                // The new and improved version of the Erase code allows
                                // effectively painting with an erase cursor!
    { 
      y_pos_array = (y_pos - 6)/8;
      x_pos_array = (x_pos - 14)/8;
      linear_pos_array = (x_pos_array) + ((y_pos_array - 1) * 36);
      TotalArray[linear_pos_array] = 0;
      TotalArray[linear_pos_array + 939] = 48;
      TotalArray[linear_pos_array + 1878] = 58;

      gp_SetFont8(x_pos, y_pos, 1, "N", 0xFFFF, framebuffer); // These 4 lines are basically
      gp_SetFont8(x_pos, y_pos, 1, "|", 0xFFFF, framebuffer); // the entire function. The
      gp_SetFont8(x_pos, y_pos, 1, "#", 0xFFFF, framebuffer); // characters used erase every
      gp_SetFont8(x_pos, y_pos, 1, "^", 0xFFFF, framebuffer); // point that the current brushes
                                                              // can possibly paint in a
                                                              // square when combined. And
                                                              // they are all set to white.

      gp_ButtonInit();

      if (gp_ButtonResult()&BUP)
       {
        TotalArray[linear_pos_array] = ' ';
        TotalArray[linear_pos_array + 939] = 48;
        TotalArray[linear_pos_array + 1878] = 58;
 
        if (y_pos > 14) {y_pos = y_pos - 8;};
        gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);
       };

      if (gp_ButtonResult()&BDOWN)
       {
        TotalArray[linear_pos_array] = ' ';
        TotalArray[linear_pos_array + 939] = 48;
        TotalArray[linear_pos_array + 1878] = 58;

        if (y_pos < 214) {y_pos = y_pos + 8;};
        gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);
       };

      if (gp_ButtonResult()&BLEFT)
       {
        TotalArray[linear_pos_array] = ' ';
        TotalArray[linear_pos_array + 939] = 48;
        TotalArray[linear_pos_array + 1878] = 58;

        if (x_pos > 22) {x_pos = x_pos - 8;};
        gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);
       };

      if (gp_ButtonResult()&BRIGHT)
       {
        TotalArray[linear_pos_array] = ' ';
        TotalArray[linear_pos_array + 939] = 48;
        TotalArray[linear_pos_array + 1878] = 58;

        if (x_pos < 294) {x_pos = x_pos + 8;};
        gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);
       };

    gp_SetFont8(x_pos, y_pos, length, brush, 0xF000, framebuffer);
    Delay(10);
    }; 
   
  /*********************************************************************************
  *                           Area Cleaning code                                   *
  **********************************************************************************/

  // This whole section is pretty much the equivalent of saying "New drawing" in a more
  // sophisticated piece of art software. It just wipes the framebuffer (where we're been
  // drawing everything to) and then re-draws the toolkit, leaving the cursor where it is.

   // Called on pressing start. I may change that to start and select in a future version,
   // but probably not.
   if (gp_ButtonResult()&BSTART)
    {
      int y_pos_bak = y_pos; // First we back up the co-ordinates where the cursor is at the
      int x_pos_bak = x_pos; // moment, else it would be re-positioned dramatically by the
                             // Toolkit() function.

      int i; // Then we re-create i, our (actually global - this line *probably* isn't 
             // needed here) value for framebuffer clearage.
      for (i=0; i<320*240; i++) framebuffer[i]=0xFFFF; // Next, for every value of i between
                                                       // 0 and 320 times 240, we set that
                                                       // pixel to white, clearing the screen.
      
      Toolkit(); // Then we run our good ole Toolkit() function to re-create the list of
                 // brushes, and colour swab, as well as the field.
      x_pos = x_pos_bak; // And replace our old values of x and y for the cursor.
      y_pos = y_pos_bak;
      gp_SetFont8(x_pos, y_pos, 1, brush, 0xF000, framebuffer); // Finally, we set that point
                                                                // to red so we can see
                                                                // where it is.
      Delay(2);                     // Now we're saving as well, we also need to wipe the 
      gp_ButtonInit();              // save array. So that's what this bit does. However, 
      if (gp_ButtonResult()&BSTART) // we may not want to - for whatever reason - so just in
       {                            // case not, we re-init the buttons and add a *small*
        for (i=0; i<936; i++)       // delay, so that it only gets wiped too if the button is
         {                          // held slightly. I hope.
          TotalArray[i] = 0; 
          TotalArray[939 + i] = '0'; 
          TotalArray[1878 + i] = 58;      
         };
        for (i=0; i<936; i=i+36)
         {
          TotalArray[i] = '\n'; 
          TotalArray[i+939] = '\n'; 
          TotalArray[i+1878] = '\n';
         };
        TotalArray[936] = '\n'; 
        TotalArray[937] = '-';  
        TotalArray[938] = '\n'; 
        TotalArray[1875] = '\n';
        TotalArray[1876] = '-';
        TotalArray[1877] = '\n';
       };
      
    };
 /*************************************************************************************
 *                              Reset Code                                            *
 **************************************************************************************/

 // This little bit restarts the gamepark. Funny that. You need to get all three buttons
 // down at once, though.
  while (gp_ButtonResult()&BR && gp_ButtonResult()&BL && gp_ButtonResult()&BSTART)
   {
    gp_Reset(); // Resets the gamepark if you didn't guess ;)
   };

 // This is darn clever imo. By setting a single integer to 0, we drop ourselves back to
 // the intro screen *without* calling a function within a function (which I think would
 // lead to cluttered memory very very fast.) We also set loadornot to 0 so someone doesn't
 // accidentally wipe their own work.
  if (gp_ButtonResult()&BA)
   {
    loadornot = 0;
    q = 0;
    Delay(10);
   };


 /*************************************************************************************
 *                              Save Code                                             *
 **************************************************************************************/

  if (gp_ButtonResult()&BSELECT)
   { 
    // First we set the current character blue - simply because it makes it easy to tell
    // when its done saving.
     gp_SetFont8(x_pos, y_pos, 1, brush, 0x00F0, framebuffer); 

    // Then we actually save - the first of these 2 lines writes to the file you chose
    // earlier in the intro section (or later if you're examining the code as opposed to 
    // just using it). The second one writes where that file is to a constant place you 
    // might remember loading right at the start. That effectively allows us to memorise
    // the last saved file and load it automatically when next loaded.
     smc_write(directory1,(char*)TotalArray,sizeof(TotalArray));
     smc_write("dev0:\\GPMM\\ASCIIART\\LASTOPEN.TXT",(char*)directory1,sizeof(directory1));

    // Finally, re-set the cursor to red :)
     gp_SetFont8(x_pos, y_pos, 1, brush, 0xF000, framebuffer);
   };

  }; // You remember that while(1) loop we made earlier? Well here's where it ends.
     // any code after here shouldn't get executed unless a "break" statement appears somewhere
     // in the while(1) loop we've just left.
 } // Similarly, this is where the function ActualProggy() leaves off. The purpose of having 
   // the program in a loop like this is so as to be able to sketch in a title-screen, and,
   // maybe, some help to make it look nice and professional.
   // Of course, this will never be returned to once the actual program activates, but it's
   // worth putting in before everything's set up.

/*****************************************************************************************
*                                 Intro Code                                             *
*****************************************************************************************/
void Intro()
 {
 // First we define a bunch of character variables to be printed in a bit - things like
 // title, author, and the text to go at the bottom.
  char Title[17] = "ASCIIpaint GP 0.3";
  char Author[20] = "Tobriand/Toby Jacobs";
  char Menu[37] = "Press Start to load your last drawing";
  char Menu2[37] = "or A to see Help. Or Select to change";
  char Menu3[35] = "the name of the savefile to be used";
  int q=0; // We also have to declare q so as to be able to use it in that while loop in
           // a little bit.


 // Next we dump everything to the screen. For those as are interested, the centrality of
 // it all comes from multiplying the length of an element by 8 (the pixel width of a 
 // character most of the time) and then subtracting that from 320 and dividing the result
 // by 2. There's probably a better way to do it - as well as multiple lines - but this
 // will suffice.
  gp_SetFont8(92, 45, sizeof(Title), Title, 0x0000, framebuffer);
  gp_SetFont8(152, 61, 2, "by", 0x0000, framebuffer);
  gp_SetFont8(80, 77, sizeof(Author), Author, 0x0000, framebuffer);
  gp_SetFont8(12, 150, sizeof(Menu), Menu, 0x0000, framebuffer);
  gp_SetFont8(12, 160, sizeof(Menu2), Menu2, 0x0000, framebuffer);
  gp_SetFont8(12, 170, sizeof(Menu3), Menu3, 0x0000, framebuffer);
  gp_SetFont8(0, 232, 31, "GBAX.COM 2004 - www.gp32emu.com", 0x0000, framebuffer);
 // We also test to see whether or not we're loading, and writing (or not) to the corner
 // accordingly.
  if (loadornot == 1) gp_SetFont8(0, 0, 4, "LOAD", 0xF000, framebuffer);
  

  gp_ButtonInit();  // initialise the buttons outside of the loop; it's one less command to
                    // run through each time, and it works like this so ner.
          
  while(q==0)
  {
   gp_ButtonInit();

   if (gp_ButtonResult()&BB)
    {
     if (loadornot == 0) {loadornot = 1;} else {loadornot = 0;};
     if (loadornot == 1) gp_SetFont8(0, 0, 4, "LOAD", 0xF000, framebuffer);
     if (loadornot == 0) gp_SetFont8(0, 0, 4, "LOAD", 0xFFFF, framebuffer);
     Delay(10);
    };

   if (gp_ButtonResult()&BSTART) q=1; // Pressing start quits the loop by setting the 
                                      // condition to false. This also finishes Intro()
                                      // and therefore allows ActualProggy() to proceed
   if (gp_ButtonResult()&BA) // If A is pressed on the other hand...
    {
     int i; // First we wipe the framebuffer as usual
     for (i=0; i<320*240; i++) framebuffer[i]=0xFFFF;
     
    // We also re-draw the title and author info so as to waste space - the instructions
    // don't take up anything like enough of the page to be left on their own!
     gp_SetFont8(92, 45, sizeof(Title), Title, 0x0000, framebuffer);
     gp_SetFont8(152, 61, 2, "by", 0x0000, framebuffer);
     gp_SetFont8(80, 77, sizeof(Author), Author, 0x0000, framebuffer);
     if (loadornot == 1) gp_SetFont8(0, 0, 4, "LOAD", 0xF000, framebuffer);


    // Then, line by line, character by character, we draw the instructions.
    // I had intended to dump everything into one variable, but gp_SetFont8() doesn't
    // understand the "\n" escape character, so I had to separate them into different
    // lines. If anyone knows a better way of doing it, by all means tell me, but its
    // only the intro, so in this case, inefficiency doesn't really matter.
     gp_SetFont8(40, 130, 13, "Instructions:", 0x0000, framebuffer);
     gp_SetFont8(40, 140, 28, "Move the joypad to paint with", 0x0000, framebuffer);
     gp_SetFont8(40, 150, 27, "the currently selected brush", 0x0000, framebuffer);
     gp_SetFont8(40, 160, 14, "A: Resets GP32", 0x0000, framebuffer);
     gp_SetFont8(40, 170, 29, "B: Erases the current square", 0x0000, framebuffer);
     gp_SetFont8(40, 180, 29, "START: Creates a new drawing", 0x0000, framebuffer);
     gp_SetFont8(40, 190, 33, "SELECT: Saves current work to SMC", 0x0000, framebuffer);
     gp_SetFont8(40, 200, 19, "L: Changes the brush", 0x0000, framebuffer);
     gp_SetFont8(40, 210, 18, "R: Changes the colour ", 0x0000, framebuffer);
    };

   if (gp_ButtonResult()&BSELECT) // If SELECT is pressed, we go to name-changeing mode...
    {
    // As usual, wipe the framebuffer.
     int i; // First we wipe the framebuffer as usual
     for (i=0; i<320*240; i++) framebuffer[i]=0xFFFF;
     
    // Then re-draw the title and author info so as to waste space - it looks like a
    // test-mode desert otherwise.
     gp_SetFont8(92, 45, sizeof(Title), Title, 0x0000, framebuffer);
     gp_SetFont8(152, 61, 2, "by", 0x0000, framebuffer);
     gp_SetFont8(80, 77, sizeof(Author), Author, 0x0000, framebuffer);
    // And of course, the background colour tile.
     gp_SetFont8(156, 120, 1, "N", 0xFFFF, framebuffer);
     gp_SetFont8(156, 120, 1, "|", 0xFFFF, framebuffer);

     colornumb = 7;
     color = colorbank[colornumb];

     ////////////RELEVANT VARIABLES////////////
     // char directorybrush[] = "A";         //
     // int directorybrushnumb = 0;          //
     // directorybrush[0] = directory1[20];  //
     //////////////////////////////////////////

    // We must this to 0; that way, if we're returning to the menu, we don't get
    // overlay errors with lots of Ts.
     directorybrushnumb = 0;
     directorybrush[0] = directory1[20];

    // Then we draw, firstly, directory1 - note how we start it far to the right of the 
    // screen; that's because the gp_SetFont8() function wraps when a string is too big.
    // So, first we draw it all in black. And then we draw *up to* the start of the
    // filename (the bit we're going to change) in white - effectively erasing it.
    // You might realise that if directory1 was a bit longer, we'd get overlay errors,
    // but since it isn't, they don't matter.
     gp_SetFont8(272, 180, sizeof(directory1), directory1, 0x0000, framebuffer);
     gp_SetFont8(272, 180, (sizeof(directory1)-13), directory1, 0xFFFF, framebuffer);
    // Then we wipe over the first letter of the directory1 filename with a red version
    // of itself - to say which letter is selected for editing.
     gp_SetFont8(112, 180, 1, directorybrush, 0xF000, framebuffer);
     x_pos = 112;

    // Finally we drop into *another* while loop, interestingly with the same test 
    // condition as the one we're already in. Effectively, that means that setting q != 0
    // will drop out of *both* loops, which is really quite convenient.
     while (q == 0)
      {
       gp_ButtonInit(); // We've got to initialise the buttons again, though.

      // Now, on to the selector code. We've got 2 directions here, Right and Left, for
      // moving the cursor. This one is right - the left one comes straight afterwards and
      // is, apart from a -- and a couple of different bounds, identical.
       if (gp_ButtonResult()&BRIGHT)
        {
        // First we set the current position to black - doing it now saves a variable being
        // needed later.
         gp_SetFont8(x_pos, 180, 1, directorybrush, 0x0000, framebuffer);
        // Then we test if the cursor is too far right... if it is, we stop it. Likewise,
        // if directorybrushnumb is too high, we don't add anything to it. Theoretically,
        // these two lines could be amalgomated, but unfortunately, in practice, it didn't
        // work for me - maybe you'll have better luck if you choose to try.
         if (x_pos < 168) x_pos = x_pos + 8;
         if (directorybrushnumb < 7) directorybrushnumb ++;
        // We also have to set our brush character to the right position in directory1
        // based on the number we've just added. 20 is the index of the first character
        // in the current name, so adding that to dbn should give the right place. And does.
         directorybrush[0] = directory1[directorybrushnumb + 20];

        // Now, having added to x_pos and re-set the "brush", we need to paint the new
        // active position. Its identical to the first line, but for the colour - which is
        // now red (0xF000). 
         gp_SetFont8(x_pos, 180, 1, directorybrush, 0xF000, framebuffer);         

        // Then we make it humanly possible to not just select the first and last charachers
        // by slowing it all down a bit. 15/128 of a second ought to do it.
         Delay(10);
        };

      // Like I said, this is identical to the one for right almost, so just look at the
      // comments in it.
       if (gp_ButtonResult()&BLEFT)
        {
         gp_SetFont8(x_pos, 180, 1, directorybrush, 0x0000, framebuffer);         
         if (x_pos > 112) x_pos = x_pos - 8;
         if (directorybrushnumb > 0) directorybrushnumb --;
         directorybrush[0] = directory1[directorybrushnumb + 20];

         gp_SetFont8(x_pos, 180, 1, directorybrush, 0xF000, framebuffer);         

         Delay(10);
        };

      // Unlike in movement and erase code, up and down do *not* move the cursor. They 
      // *change* it.
       if (gp_ButtonResult()&BUP)
        {
        // First we set the current position to white - erasing it, effectively.
         gp_SetFont8(x_pos, 180, 1, directorybrush, 0xFFFF, framebuffer);
        // Then, as long as current the letter has an ASCII value before that of Z (90)
        // we add one to it (++ = self + 1, remember?). This doesn't effect the brush,
        // but it does change the actual value, which is really the important bit.
         if (directory1[20 + directorybrushnumb] < 90) directory1[20 + directorybrushnumb] ++;
        // Then we set the brush to that new value. Theoretically, again, these two
        // lines could be added, but they'd then be somewhat more incomprehensible.
         directorybrush[0] = directory1[directorybrushnumb + 20];
        // Finally we paint the new letter in on top of our nice clean white square we
        // just made.
         gp_SetFont8(x_pos, 180, 1, directorybrush, 0xF000, framebuffer);

        // And delay for human reactions, again.
         Delay(10);         
        };

      // This is the same as UP, but taking one away, and with A as the bounding character.
       if (gp_ButtonResult()&BDOWN)
        {
         gp_SetFont8(x_pos, 180, 1, directorybrush, 0xFFFF, framebuffer);
         if (directory1[20 + directorybrushnumb] > 65) directory1[20 + directorybrushnumb] --;
         directorybrush[0] = directory1[directorybrushnumb + 20];
         gp_SetFont8(x_pos, 180, 1, directorybrush, 0xF000, framebuffer);

         Delay(10);         
        };
        
        // This code is to allow the setting of a theoretical background colour here.
        // Since adding in a background would involve adding in a whole new revamp to 
        // the erase function, though, I can't be bothered to do it right now.
        // However, if you want to activate colour switching in the intro section, this 
        // bit'll do it. And if you want to add fill backgrounds, that's where you're going
        // to have to define them.
/*       if (gp_ButtonResult()&BL)
        {
         colornumb ++;
         if (colornumb == 8) colornumb = 0;
         color = colorbank[colornumb];
         gp_SetFont8(156, 120, 1, "N", color, framebuffer);
         gp_SetFont8(156, 120, 1, "|", color, framebuffer);
        };

       if (gp_ButtonResult()&BR)
        {
         colornumb --;
         if (colornumb == 8) colornumb = 0;
         color = colorbank[colornumb];
         gp_SetFont8(156, 120, 1, "N", color, framebuffer);
         gp_SetFont8(156, 120, 1, "|", color, framebuffer);
        };
*/
      // We need to add load toggling here too, since the other one won't work most probably.
       if (gp_ButtonResult()&BB)
        {
         if (loadornot == 0) {loadornot = 1;} else {loadornot = 0;};
         if (loadornot == 1) gp_SetFont8(0, 0, 4, "LOAD", 0xF000, framebuffer);
         if (loadornot == 0) gp_SetFont8(0, 0, 4, "LOAD", 0xFFFF, framebuffer);
         Delay(10);
        };
      

      // Remember we needed an escape clause from both loops? This is it! q gets set to 1,
      // and we drop right out of the intro code with everything set up.
       if (gp_ButtonResult()&BSTART) q=1;

      };

    };
  };
 }
//////////////////////////////END OF INTRO CODE///////////////////////////////////////////

/****************************************************************************************
*                              Furthest set of functions to run                         *
****************************************************************************************/

// These next few lines run everything we've just typed out and looked at. The intro is run
// first, showing the title, my name, and help, and then once that's finished, we go 
// straight into the actual program. Isn't life fun?

while (1)
{
 Intro(); // Runs the intro
 for (i=0; i<320*240; i++) framebuffer[i]=0xFFFF; // Clear the framebuffer once again to 
                                                 // get rid of intro relics.
 ActualProggy(); // Runs the - you guessed it - actual program.
 for (i=0; i<320*240; i++) framebuffer[i]=0xFFFF; 
};


} // End of the Main() function. This is the equivalent of a </HTML> tag at the end of a
  // web page, pretty much. It marks the absolute end to the program, except, possibly,
  // for comments like this.
                                 