#include "main.h"

int main(int argc, char *argv[])
{
 gp2x_init(1000, 16, 22050,16,0,60, 1);//setup GP2X : ms,16b colour,16b,22050Hz,mono,60Hz,Transparentfont
 gp2x_video_logo_enable(1);//Show logo!

dos();//intro - it would be more fitting to have a Linux style prompt but I'm not as clued up as I am with DOS...
loading();// "loading" screen - something akin to C64
scenescroll();//poke screen - supposed to be parallax scrolling demo but can't seem to get my head around it to make it work properly...
collisions();//collisions test
wankinggame();//a port of a spacebar mini game I did on a game I made.
//imageshow();//quick slideshow
credits();//does what it says on the tin
gp2x_deinit();
return 0;
}

gp2x_rect * loadbmp(const char* bmp)// can't seem to get this working. for whatever reason it can't find the files.
{
gp2x_rect * texture;
glbmp_t bitmap;

	if(!glbmp_LoadBitmap(bmp, GLBMP_TOP_DOWN, &bitmap))
	{
		gp2x_printf(NULL,0,0,"Error loading bitmap file.\n");
		printf("Error loading bitmap file.\n");
		gp2x_deinit();
	}
	texture->x = 0;
	texture->y = 0;
	texture->w = bitmap.width;
	texture->h = bitmap.height;
	texture->solid = 1;
	texture->data = bitmap.rgb_data;
	glbmp_FreeBitmap(&bitmap);
	return texture;
}


void imageshow()
{
	advancedemo = false;
	//chdir("./"); 
	gp2x_rect * background = loadbmp("\\mnt\\sd\\compo.bmp");
	while (advancedemo == false)
	{
		unsigned int lastframe = gp2x_timer_read();
		while (gp2x_timer_read() - lastframe < 5000)//show image for 5s
		{
			gp2x_blitter_rect(background);
			gp2x_video_waitvsync();
			gp2x_video_RGB_flip(0);
		}
	}
}
void credits()
{
	advancedemo = false;
	
		char* creddata[40];
		creddata[0] = "               Hello GP2X PPLz!";
		creddata[1] = "     Thanks for watching this little demo!";
		creddata[2] = "Please note: this is my 1st go at coding the GP2X!";
		creddata[3] = "Thanks to gp2x.co.uk & emuholic.com for this compo.";
		creddata[4] = "     Hope this is sort of good enough! =)";
		creddata[5] = "Now have some GrEeTz: MMXG, Saiyanthou, Fuzy, Ryan";
		creddata[6] = "Noxious Ninja, Karurosu, HCS, EvilDiscoGuy,)\\/(orri";
		creddata[7] = "    RoobBoob, Shikana, Empie, Shao, Turbocharge.";
		creddata[8] = "         This was originally a scroller...";
		creddata[9] = "      It didn't work how I was expecting...";
		creddata[10] = "   It was soo good that people watching it...";
		creddata[11] = "      Well, their heads just exploded...";
		creddata[12] = "       So this is the backup method ;)";
		creddata[13] = " Credits: Nearly all of this demo: PokeParadox.";
		creddata[14] = " Pointing out stupid mistake with collision code:";
		creddata[15] = "                 Turbocharge";
		creddata[16] = "  Pointing other stupid mistakes and misc advice:";
		creddata[17] = "                 )\\/(orri";
		creddata[18] = "     PokeParadox - pokeparadox@gmail.com";
		creddata[19] = "      http://www.projectinfinity.org.uk";
		creddata[20] = "           Press select to quit.";
		creddata[21] = "    Or just sit here...(Text repeats.) -FIN";
		creddata[22] = "       No really, that's it... go away!";
		creddata[23] = "        Go and do something productive:";
		creddata[24] = "            Like read a good book,";
		creddata[25] = "             Hell... read A book.";
		creddata[26] = "      It can have pictures in if you like!";
		creddata[27] = "              Nice BIG pictures.";
		creddata[28] = "                 )>))))'>.o0O";
		creddata[29] = "                   <('.'<)";
		creddata[30] = "            GO AWAY!!!! V_((><))_V";
		creddata[31] = "             You still here then?";
		creddata[32] = "     You really have nothing better to do huh?";
		creddata[33] = "          ?hguoht sdrawkcab daer uoy naC";
		creddata[34] = " ";
		creddata[35] = " ";
		creddata[36] = " ";
		creddata[37] = " You certainly have patience, I'll give you that.";
		creddata[38] = "     Alas, mine has run out... LEAVE! -Poke";
		int maxindex = 38;
		advancedemo = false;
		clearbuffer();
		gp2x_video_RGB_flip(0);
		int index=0;
	while(1)
	{
		unsigned int lastframe = gp2x_timer_read();
		if (index == maxindex)
			{
				index = 0;
			}
		while (gp2x_timer_read() - lastframe < 3000)//show cred for 3s
		{
			control();
			if(advancedemo == true)
			{
				return;
			}
			clearbuffer();
			gp2x_printf(NULL,10,120,creddata[index]);
			gp2x_video_waitvsync();
			gp2x_video_RGB_flip(0);
		}
			index++;
			
	}
}

void collisions()
{
	clearbuffer();
	gp2x_printf(NULL,0,0,"It's Audiance participation time!\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);
	gp2x_printf(NULL,-1,-1,"Use the stick and move the blue box.\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);
	clearbuffer();

	int boxesx[13];
	int boxesy[13];
	boxesx[12] = 155;//users box
	boxesy[12] = 115;
	int velx[13];
	int vely[13];
	int oldx[13];
	int oldy[13];
	int boxlength = 10;
	advancedemo = false;
	//setup CPU boxes
	boxesx[0] = 264; boxesy[0] = 28;velx[0] = 1; vely[0] = 1;
	boxesx[1] = 93; boxesy[1] = 155;velx[1] = -1; vely[1] = -1;
	boxesx[2] = 143;boxesy[2] = 92;velx[2] = -1; vely[2] = 1;
	boxesx[3] = 53;boxesy[3] = 173;velx[3] = 1; vely[3] = -1;
	boxesx[4] = 226;boxesy[4] = 98;velx[4] = 2; vely[4] = 1;
	boxesx[5] = 98;boxesy[5] = 47;velx[5] = 1; vely[5] = 2;
	boxesx[6] = 158;boxesy[6] = 228;velx[6] = -2; vely[6] = 1;
	boxesx[7] = 56;boxesy[7] = 88;velx[7] = 1; vely[7] = -2;
	boxesx[8] = 27;boxesy[8] = 45;velx[8] = 2; vely[8] = 2;
	boxesx[9] = 64;boxesy[9] = 182;velx[9] = -2; vely[9] = -2;
	boxesx[10] = 183;boxesy[10] = 196;velx[10] = -1; vely[10] = 1;
	boxesx[11] = 193;boxesy[11] = 3;velx[11] = -1; vely[11] = -1;
	velx[12] = 1; vely[12] = 1;//not going to be used as this one is joystick controlled
	//
	int blur = false;
	while(1)
	{
		//get control
			if((gp2x_joystick_read() & GP2X_UP))
			{
				if(boxesy[12] > 0)
				{
					oldx[12] = boxesx[12];
					oldy[12] = boxesy[12];
					boxesy[12] -= 1;
				}
				
			}
			if((gp2x_joystick_read() & GP2X_DOWN))
			{
				if(boxesy[12] + boxlength < 240)
				{
				oldx[12] = boxesx[12];
				oldy[12] = boxesy[12];
				boxesy[12] += 1;
				}
			}
			if((gp2x_joystick_read() & GP2X_LEFT))
			{
				if(boxesx[12] > 0)
				{
				oldx[12] = boxesx[12];
				oldy[12] = boxesy[12];
				boxesx[12] -= 1;
				}
			}
			if((gp2x_joystick_read() & GP2X_RIGHT))
			{
				if(boxesx[12] + boxlength < 320)
				{
				oldx[12] = boxesx[12];
				oldy[12] = boxesy[12];
				boxesx[12] += 1;
				}
			}
			if((gp2x_joystick_read() & GP2X_Y))
			{
				blur = !blur;// toggle clearing of display buffer
			}
			//end control
		if (blur == false)
		{
			clearbuffer();
		}
		for (int i = 0; i < 13; i++)//for all the boxes
		{
			oldx[i] = boxesx[i];
			oldy[i] = boxesy[i];
		}
		for (int i = 0; i < 13; i++)//for all the boxes
		{
			
			
			//update boxes according to velocity but not user box
			if (i != 12)
			{
				boxesx[i] += velx[i];
				boxesy[i] += vely[i];
			}
			//keep boxes on screen
			if(boxesx[i] <= 0 || (boxesx[i] + boxlength) >= 320)
			{
				boxesx[i] = oldx[i];
				velx[i] = -velx[i];
			}

			if(boxesy[i] <= 0 || (boxesy[i] + boxlength) >= 240)
			{
				boxesy[i] = oldy[i];
				vely[i] = -vely[i];
			}

			//check for collisions against all the other boxes
			for (int x = 0; x < 13; x++)
			{
				if (x != i)//don't check for a collision against self.
				{
					if (boxesy[i] < boxesy[x]+boxlength){
					if (boxesy[i]+boxlength > boxesy[x]){
						if (boxesx[i]+boxlength > boxesx[x]){
							if (boxesx[i] < boxesx[x]+boxlength){
								boxesx[i]=oldx[i];
								boxesy[i]=oldy[i];
								velx[i]=-velx[i];
								vely[i]=-vely[i];
								boxesx[x]=oldx[x];
								boxesy[x]=oldy[x];
								velx[x]=-velx[x];
								vely[x]=-vely[x];
							}
						}
					}
				}
				}
			}
			if(i != 12)
			{
				drawrectangle(boxesx[i],boxesy[i],boxlength,boxlength,255,0,0);
			}
			else
			{
				drawrectangle( boxesx[12], boxesy[12], boxlength, boxlength, 0,0,255);
			}
		}
		control();
		if(advancedemo == true)
		{
			return;
		}
		gp2x_printf(NULL,0,0,"Use the stick and move the blue box.\n");
		gp2x_printf(NULL,-1,-1,"Tap A to advance to next part of demo.\n");
		gp2x_printf(NULL,-1,-1,"Tap Y for blurring.\n");
		gp2x_video_waitvsync();
		gp2x_video_RGB_flip(0);
	}
}

void dos()
{
	gp2x_printf(NULL,0,0,"C:\\\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(1500);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\c\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\cd\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\cd\\\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\cd\\d\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\cd\\de\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\cd\\dem\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\cd\\demo\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(500);

	clearbuffer();
	gp2x_printf(NULL,-1,-1,"C:\\demo\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(1000);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo>d\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo>di\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo>dir\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(500);

	clearbuffer();
	gp2x_printf(NULL,-1,-1," Volume in drive C is GP2X\n");
	gp2x_printf(NULL,-1,-1," Volume serial number is XYZX YZXY\n");
	//gp2x_printf(NULL,-1,0,"\n");
	gp2x_printf(NULL,-1,-1," Directory of C:\\demo\n");
	//gp2x_printf(NULL,-1,0,"\n");
	gp2x_printf(NULL,-1,-1,"05/02/2006 13:22 <DIR>  .\n");
	gp2x_printf(NULL,-1,-1,"05/02/2006 13:22 <DIR>  ..\n");
	gp2x_printf(NULL,-1,-1,"05/02/2006 13:22      2 demo.gpe\n");
	gp2x_printf(NULL,-1,-1,"05/02/2006 13:22      0 readme.txt\n");
	gp2x_printf(NULL,-1,-1,"05/02/2006 13:22      0 entryinfo.txt\n");
	gp2x_printf(NULL,-1,-1,"05/02/2006 13:22      0 GP2X CODING\n");
	gp2x_printf(NULL,-1,-1,"05/02/2006 13:22      0 COMPETITION 2006\n");
	gp2x_printf(NULL,-1,-1,"05/02/2006 13:22      0 GP2X.CO.UK\n");
	gp2x_printf(NULL,-1,-1,"05/02/2006 13:22      0 EMUHOLIC.COM\n");
	gp2x_printf(NULL,-1,-1,"C:\\demo>\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(6000);
	
	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo\\\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);
	
	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo\\d\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo\\de\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo\\dem\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo\\demo\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo\\demo.\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo\\demo.g\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo\\demo.gp\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(300);

	clearbuffer();
	gp2x_printf(NULL,-1,0,"C:\\demo\\demo.gpe\n");
	gp2x_video_RGB_flip(0);
	gp2x_timer_delay(600);
	clearbuffer();
}

void scenescroll()
{
	int plane[240];//each plane stores a starting pixel for function to render..erm... planes.
	int planescrollspeed[240];//each element stores a speed to scroll planes.
	int planetype[240];//to store which type of pattern to display
	cpattern sky(3);
	cpattern grass(3);
	cpattern water(4);
	advancedemo = false;
//setup plane arrays.
	int speed = 0;
	for(int i = 0; i < 240; i++)
	{
		plane[i] = 0;
		planescrollspeed[i] = speed;
		speed += i/7;
		if (i < 60)
		{
			planetype[i] = SKY;
		}
		if(i < 120 && i >= 60 )
		{
			planetype[i] = GRASS;
		}
		if(i >= 120)
		{
			planetype[i] = WATER;
		}
	}
	
	//setup patterns
sky.setseg(0,21,234, 234,3);
sky.setseg(1,255,255, 255,2);
sky.setseg(2,22,255, 255,3);

grass.setseg(0,10,90, 10,1);
grass.setseg(1,200,230, 200,2);
grass.setseg(2,20,220, 20,1);

water.setseg(0, 30, 30, 60, 1);
water.setseg(1, 30, 30, 100, 2);
water.setseg(2, 30, 30, 200, 2);
water.setseg(3, 220, 230, 250, 1);

//run through each plane
int scroll = 0;
bool wave = false;
unsigned int frame = gp2x_timer_read();
while(1)
{
	wave = false;	
	for (int y = 0; y < 240; y++)
	{
		//from the starting point
		int currseg = 0;
		int len=0;
		bool lenset = false;
		for(int x = 0; x < 320; x++)
		{	
			if (planetype[y] == SKY)//if it is the sky pattern
			{
				if(len == 0)//if len is 0 it means end of pattern
				{
					if (lenset == true)//if true it means we have already set the len
					{
						currseg++;
						if (currseg == sky.nosegs)//if currseg is equal to nosegs then we need to wrap back to begining of pattern
						{
							currseg = 0;
						}
					}
					len = sky.seglength[currseg];//if length is 0 get next length
					lenset = true;
				}
				if (len != 0)
				{	
					int pixelpos = x+(y*320)+planescrollspeed[y]+scroll;
					if(pixelpos >= 19199)
					{
						pixelpos = 19199;
					}
					gp2x_video_RGB[0].screen16[pixelpos] = sky.colour[currseg];//update screen
					len--;
				}
			}
			if (planetype[y] == GRASS)
			{
				if(len == 0)
				{
					if (lenset == true)
					{
						currseg++;
						if (currseg == grass.nosegs)
						{
							currseg = 0;
						}
					}
					len = grass.seglength[currseg];//if length is 0 get next length
					lenset = true;
				}
				if (len != 0)
				{
					int pixelpos = x+(y*320)+planescrollspeed[y]+scroll+scroll;
					if(pixelpos >= 38399)
					{
						pixelpos = 38399;
					}
					gp2x_video_RGB[0].screen16[pixelpos] = grass.colour[currseg];//update screen
					len--;
				}
			}
			if (planetype[y] == WATER)
			{
				if(len == 0)
				{
					if (lenset == true)
					{
						currseg++;
						if (currseg == water.nosegs)
						{
							currseg = 0;
						}
					}
					len = water.seglength[currseg];//if length is 0 get next length
					lenset = true;
				}
				if (len != 0)
				{
					int pixelpos = x+(y*320)+planescrollspeed[y]*scroll;
					if(pixelpos >= 76799)
					{
						pixelpos = 76799;
					}
					gp2x_video_RGB[0].screen16[pixelpos] = water.colour[currseg];//update screen
					len--;
				}
			}
		}//endfor
	}//endfor
	unsigned int currframe = gp2x_timer_read();

	if(((currframe - frame) >= 1500) && ((currframe - frame) <= 3000))//make him wave intermitantly
	{
		wave=true;
		frame = gp2x_timer_read();
	}			
	scroll++;
	if(scroll >= 320)
	{
		scroll = 0;
	}
	control();//get controls
	if((gp2x_timer_read() - frame) >= 6000)//supposed to move to next part o demo after 6s
	{
		advancedemo = true;
	}
	if(advancedemo == true)
	{
		return;
	}
	pokepic();
	rightarm(wave);
	gp2x_printf(NULL,0,0,"Tap A to advance to next part of demo.\n");
	gp2x_video_waitvsync();
	gp2x_video_RGB_flip(0);
}//endwhile
}

void loading()//"loading" screen supposed to be akin to C64 loading screens
{
	advancedemo = false;
	int red = 50;
	int green = 40;
	int blue = 100;
	int xpos = 0;
	int ypos = 0;
	int xlen = 320;
	int ylen = 12;
	unsigned int frame = gp2x_timer_read();
	while(1)
	{
		clearbuffer();
		ypos = 0;
		for (int i = 0; i < 20; i ++)
		{
			ypos += ylen;
			//printf("ylen: %d\n",ylen);
			//printf("ypos: %d\n",ypos);
			red = (i + i + ypos);
			//printf("red: %d\n",red);
			//green = (ypos + i);
			//printf("green: %d\n",green);
			blue = (blue + i + i + i);
			//printf("blue: %d\n",blue);
			while(red >= 255)
			{
				red -= 255; 
			}
			while(green >= 255)
			{
				green -= 255; 
			}
			while(blue >= 255)
			{
				blue -= 255; 
			}
			while((ypos + ylen) >= 240)
			{
				ypos--;
			}
			drawrectangle(xpos,ypos,xlen,ylen,red,green,blue);
		}
		control();
		
		gp2x_video_waitvsync();
		gp2x_video_RGB_flip(0);
		if((gp2x_timer_read() - frame) >= 6000)
		{
			advancedemo = true;
		}
		if(advancedemo == true)
			{
				return;
			}
		}
}

void pokepic()
{
	//face
	drawrectangle(140,80,40,40,255,199,157);
		//left eye
		drawrectangle(144,95,5,10,255,255,255);
		drawrectangle(145,96,3,8,35,230,228);
		drawrectangle(146,98,1,4,0,0,0);
		//right eye
		drawrectangle(171,95,5,10,255,255,255);
		drawrectangle(172,96,3,8,35,230,228);
		drawrectangle(173,98,1,4,0,0,0);
		//nose
		drawrectangle(159,100,2,2,0,0,0);
		drawrectangle(157,102,2,1,0,0,0);
		drawrectangle(161,102,2,1,0,0,0);
		//mouth
		drawrectangle(156,110,8,2,255,255,255);
		drawrectangle(157,112,6,3,186,21,21);
	//hair
	drawrectangle(145,56,30,30,61,32,7);
	drawrectangle(138,35,5,45,102,54,12);//left spike
	drawrectangle(157,35,6,48,102,54,12);//centre spike
	drawrectangle(177,35,5,45,102,54,12);//right spike
	drawrectangle(143,60,34,20,102,54,12);
	drawrectangle(137,75,5,30,102,54,12);//left sideburn
	drawrectangle(178,75,5,30,102,54,12);//right spike
	drawrectangle(140,80,10,10,102,54,12);
	drawrectangle(170,80,10,10,102,54,12);

	//main body
	drawrectangle(130,120,60,70,255,255,255);
	//P Logo
	drawrectangle(150,140,5,35,255,0,0);// main stem
	drawrectangle(150,140,20,5,255,0,0);//top
	drawrectangle(165,140,5,15,255,0,0);//down the curve of the p
	drawrectangle(150,155,20,5,255,0,0);//bottom of curve of p
	//leftarm
	drawrectangle(125,125,15,15,255,255,255);
	drawrectangle(120,130,15,15,255,255,255);
	drawrectangle(115,135,15,15,255,255,255);
	drawrectangle(110,140,14,14,255,199,157);
	//LOGO
		//white part
		drawrectangle(100,160,20,10,255,255,255);drawrectangle(200,160,20,10,255,255,255);
		drawrectangle(115,170,90,10,255,255,255);
		drawrectangle(130,180,60,10,255,255,255);
		drawrectangle(150,190,20,5,255,255,255);
		//blue part
		drawrectangle(110,160,10,5,0,0,255);drawrectangle(200,160,10,5,0,0,255);
		drawrectangle(120,165,15,5,0,0,255);drawrectangle(185,165,15,5,0,0,255);
		drawrectangle(130,170,15,5,0,0,255);drawrectangle(175,170,15,5,0,0,255);
		drawrectangle(140,175,40,5,0,0,255);

}

void rightarm(bool wave)
{

	if(wave == true)
	{
		drawrectangle(185,115,15,15,255,255,255);
		drawrectangle(190,110,15,15,255,255,255);
		drawrectangle(195,105,15,15,255,255,255);
		drawrectangle(200,100,14,14,255,199,157);
	}
	else
	{
		drawrectangle(185,115,15,15,255,255,255);
		drawrectangle(187,110,15,15,255,255,255);
		drawrectangle(185,100,15,15,255,255,255);
		drawrectangle(183,95,14,14,255,199,157);
		//make eye "wink"
		//drawrectangle(144,95,5,10,255,199,157);
	}
}

void drawrectangle(int xpos,int ypos,int xlen,int ylen,int red,int green,int blue)
{
for (int x = xpos; x < xpos + xlen; x++)
	{
		for(int y = ypos; y < ypos + ylen; y++)
		{
			gp2x_video_RGB[0].screen16[x+(y*320)] = gp2x_video_RGB_color16(red,green,blue);
		}
	}
}

void wankinggame()
{
clearbuffer();
gp2x_printf(NULL,140,120,"HIT B as fast as you can!\n");
gp2x_video_waitvsync();
gp2x_video_RGB_flip(0);
int bcount = 0;
int countdown = 60; //60 s
int timedelay = 1000;
bool keypressed = false;
unsigned int timer = gp2x_timer_read();
unsigned int clock = 0;
gp2x_printf(NULL,150,120,"READY!?\n");
gp2x_video_waitvsync();
gp2x_video_RGB_flip(0);
gp2x_timer_delay(2000);

while(countdown > 0)
{
	if((gp2x_joystick_read() & GP2X_B))
	{
		if (keypressed == false)
		{
			bcount++;
			keypressed=true;
		}
        else
		{
			keypressed=false;
			while((gp2x_joystick_read() & GP2X_B)){}
		}
	}
	clearbuffer();
	gp2x_printf(NULL,150,120,"Timer: %d \n",countdown);
	gp2x_printf(NULL,150,-1,"B Count: %d \n",bcount);
	timer = gp2x_timer_read();
	if (timer - timedelay > clock)
	{
		clock = gp2x_timer_read();
		countdown--;
	}
	
	gp2x_video_waitvsync();
	gp2x_video_RGB_flip(0);
	
}
gp2x_printf(NULL,-1,-1,"You scored: %d",bcount);
gp2x_video_waitvsync();
gp2x_video_RGB_flip(0);
gp2x_timer_delay(2000);
}
void clearbuffer()
{
	for (int x = 0; x < 320; x++)
	{
		for(int y = 0; y < 240; y++)
		{
			gp2x_video_RGB[0].screen16[x+(y*320)] = gp2x_video_RGB_color16(0,0,0); //set all pixels to black
		}
	}

}
void control()
{
if((gp2x_joystick_read() & GP2X_SELECT))//select quits ap
	{
	gp2x_deinit();
	}
	//Advance demo
	if((gp2x_joystick_read() & GP2X_A))
	{
		advancedemo = true;
	}
	//do a pause function
}

void gp2x_sound_frame(void *blah, void *buff, int samples)//function to supply sound to minilib
{
}

