//----------------------------------------------------------------------------
//  Fish Ball By Linus Sphinx and Ting Hsu (c)Copyright 2007 all rights reserved
//----------------------------------------------------------------------------
//
//    Fish Ball Drawing Routines
//
//    Fish Ball is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 3 of the License, or
//    (at your option) any later version.
//
//    Fish Ball is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Fish Ball; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//--------------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <pthread.h>
#include <SDL.h>
#include <SDL_mixer.h>
#include "fish.h"
#include "racket.h"
#include "util.h"
#include "text.h"
#include "topten.h"
#include "ocean.h"
#include "draw.h"

// paint the shark hot zone bright red
// #define REDZONE 1

extern PLAYER guy;
// initialize background center of viewport
static short currentx = HALFSCREENWIDTH; // vertical 
static short currenty = HALFSCREENHEIGHT; // horizontal
extern OCEAN Ocean;
extern CURRENT *Current;
extern short Currentnum; // size of Current array
extern FISH *Fish;
extern short Fishnum; // size of Fish array
extern FISH *Predator;
extern short Predatornum;
extern short Activenum;
extern ISLAND *Island;
extern short Islandnum;
extern SPRITE *Sprite;
extern short Spritenum;
extern short Inertia;
extern SDL_Surface *lpAlphabet;
extern SDL_Surface *lpFish;

//-----------------------------------------------
// void drawleft(void) - draw left side background
//-----------------------------------------------
void drawleft( SDL_Surface *Surface, SDL_Surface *Tile )
{
	int ret = 0;
	RECT src = { TILEWIDE - currentx, TILEHIGH - currenty, currentx, currenty };
	RECT dst = { 0, 0, currentx, currenty };

	ret = SDL_BlitSurface( Tile, &src, Surface, &dst );
/*	fprintf( stderr, "top - src x:%d y:%d w:%d h:%d - dst x:%d y:%d w:%d h:%d ret: %d\n", 
					src.x, src.y, src.w, src.h, 
					dst.x, dst.y, dst.w, dst.h, ret ); */

	src.y = 0;
	src.h = SCREENHEIGHT - currenty;

	dst.y = currenty;
	dst.x = 0;
	dst.w = currentx;
	dst.h = SCREENHEIGHT - currenty;

/*	fprintf( stderr, "bottom - src x:%d y:%d w:%d h:%d - dst x:%d y:%d w:%d h:%d ret: %d\n", 
					src.x, src.y, src.w, src.h, 
					dst.x, dst.y, dst.w, dst.h, ret ); */
	SDL_BlitSurface( Tile, &src, Surface, &dst );
	return;
}

//-----------------------------------------------
// void drawright(void) - draw right side background
//-----------------------------------------------
void drawright( SDL_Surface *Surface, SDL_Surface *Tile )
{
	int ret = 0;
	RECT src = { 0, TILEHIGH - currenty, TILEWIDE - currentx, currenty };
	RECT dst = { currentx, 0, SCREENWIDTH - currentx, currenty };

	ret = SDL_BlitSurface( Tile, &src, Surface, &dst );
/*	fprintf( stderr, "top - src x:%d y:%d w:%d h:%d - dst x:%d y:%d w:%d h:%d ret: %d\n", 
					src.x, src.y, src.w, src.h, 
					dst.x, dst.y, dst.w, dst.h, ret ); */

	src.y = 0;
	src.h = SCREENHEIGHT - currenty;

	dst.y = currenty;
	dst.x = currentx;
	dst.w = SCREENWIDTH - currentx;
	dst.h = SCREENHEIGHT;

/*	fprintf( stderr, "bottom - src x:%d y:%d w:%d h:%d - dst x:%d y:%d w:%d h:%d ret: %d\n", 
					src.x, src.y, src.w, src.h, 
					dst.x, dst.y, dst.w, dst.h, ret );  */
	SDL_BlitSurface( Tile, &src, Surface, &dst );
	return;
}

//-----------------------------------------------
// void drawbg(void) - draw the background
//-----------------------------------------------
void drawbg( SDL_Surface *Surface, SDL_Surface *Tile )
{
	short speed = Ocean.speed; // current moving
	short rection = 5; // direction according to keypad - 5 = stagnate

	rection = Current[ Fish[ 0 ].current ].rection;
	// move it
	if ( rection == 1 || rection == 2 || rection == 3 ) // up
		currenty -= speed;
	if ( rection == 3 || rection == 6 || rection == 9 ) // right
		currentx += speed;
	if ( rection == 1 || rection == 4 || rection == 7 ) // left
		currentx -= speed;
	if ( rection == 7 || rection == 8 || rection == 9 ) // down
		currenty += speed;

    if ( currentx > SCREENWIDTH )
		currentx = 0;
    if ( currentx < 0 )
    	currentx = SCREENWIDTH;
    if ( currenty > SCREENHEIGHT )
		currenty = 0;
    if ( currenty < 0 )
    	currenty = SCREENHEIGHT;

	drawleft( Surface, Tile );
	drawright( Surface, Tile );
	return;
}

//-----------------------------------------------
// void drawocean(void) - draw the ocean stuff
//-----------------------------------------------
void drawocean( SDL_Surface *Surface, SDL_Surface *Tile )
{
	short i, ret = 0, flop = 0, roll = 0;
	RECT sport, vport, dport; // sprites virtual area, our viewport, sprite dest area
#ifdef REDZONE
	RECT hz; // shark hot zone painted red
#endif

	// players viewport to our virtual ocean in virtual coordinates
	vport.x =  Fish[ 0 ].x - HALFSCREENWIDTH; // left
	vport.y =  Fish[ 0 ].y - HALFSCREENHEIGHT; // top
	vport.w =  Fish[ 0 ].x + HALFSCREENWIDTH; // this is not width
	vport.h =  Fish[ 0 ].y + HALFSCREENHEIGHT; // this is not height

	for( i=0; i < Islandnum; i++ )
	{
		sport.x = Island[ i ].x - ( Sprite[ Island[ i ].sprite ].frame[ 0 ].w / 2 ); // sprites virtual space
		sport.y = Island[ i ].y - ( Sprite[ Island[ i ].sprite ].frame[ 0 ].h / 2 );
		sport.w = Island[ i ].x + ( Sprite[ Island[ i ].sprite ].frame[ 0 ].w / 2 ); // not width
		sport.h = Island[ i ].y + ( Sprite[ Island[ i ].sprite ].frame[ 0 ].h / 2 ); // not height
		if ( intersectrect( &sport, &vport )) // the sprites virtual area is in our view
		{
			dport.x = ( sport.x - vport.x );
			dport.y = ( sport.y - vport.y );
			/* fprintf( stderr, "dport before x:%d y:%d w:%d h:%d ret: %d\n", 
					dport.x, dport.y, dport.w, dport.h, ret ); */
 			ret = SDL_BlitSurface( Tile, &Sprite[ Island[ i ].sprite ].frame[ Island[ i ].curframe ], Surface, &dport );
			/* fprintf( stderr, "island - vport x:%d y:%d w:%d h:%d\nsport x:%d y:%d w:%d h:%d\nframe-%d x:%d y:%d w:%d h:%d\ndport x:%d y:%d w:%d h:%d\n\n", 
					vport.x, vport.y, vport.w, vport.h, 
					sport.x, sport.y, sport.w, sport.h,
					Island[ i ].curframe,
					Sprite[ Island[ i ].sprite ].frame[ Island[ i ].curframe ].x,
					Sprite[ Island[ i ].sprite ].frame[ Island[ i ].curframe ].y,
					Sprite[ Island[ i ].sprite ].frame[ Island[ i ].curframe ].w,
					Sprite[ Island[ i ].sprite ].frame[ Island[ i ].curframe ].h,
					dport.x, dport.y, dport.w, dport.h ); */
 			Island[ i ].dist++;
 			if ( Island[ i ].dist == Sprite[ Island[ i ].sprite ].odom )
			{
 				Island[ i ].curframe++;
				Island[ i ].dist = 0; // reset times shown
			}
 		}
	}

	for( i = 1; i < Fishnum; i++ ) // yellow fish only - skip blue and red player fish 0
	{
		if ( Fish[ i ].finity < 0 )
			continue;
		// affinity
		if ( Fish[ i ].finity > 0 )
		{
			Fish[ i ].finity++;
			if ( Fish[ i ].finity > FINTERVAL ) // point them at fish 0
			{
				if ( Fish[ i ].x > Fish[ 0 ].x &&  Fish[ i ].y > Fish[ 0 ].y )
					Fish[ i ].rection = 7;
				if ( Fish[ i ].x < Fish[ 0 ].x &&  Fish[ i ].y < Fish[ 0 ].y )
					Fish[ i ].rection = 3;
				if ( Fish[ i ].x < Fish[ 0 ].x &&  Fish[ i ].y > Fish[ 0 ].y )
					Fish[ i ].rection = 9;
				if ( Fish[ i ].x > Fish[ 0 ].x &&  Fish[ i ].y < Fish[ 0 ].y )
					Fish[ i ].rection = 1;
				Fish[ i ].finity = 1; // reset
			}
		}
		else
			Fish[ i ].rection = bounce( Fish[ i ].rection );
		sport.x = Fish[ i ].x - ( Sprite[ Fish[ i ].sprite ].frame[ 0 ].w / 2 ); // sprites virtual space
		sport.y = Fish[ i ].y - ( Sprite[ Fish[ i ].sprite ].frame[ 0 ].h / 2 );
		sport.w = Fish[ i ].x + ( Sprite[ Fish[ i ].sprite ].frame[ 0 ].w / 2 ); // not width
		sport.h = Fish[ i ].y + ( Sprite[ Fish[ i ].sprite ].frame[ 0 ].h / 2 ); // not height

		if ( intersectrect( &sport, &vport )) // the sprites virtual area is in our view
		{
			dport.x = ( sport.x - vport.x ); 
			dport.y = ( sport.y - vport.y );
			dport.w = Sprite[ Fish[ i ].sprite ].frame[ 0 ].w;
			dport.h = Sprite[ Fish[ i ].sprite ].frame[ 0 ].h;
			switch( Fish[ i ].rection ) 
			{
				case 7:
					flop++;
				case 9:
					if ( Fish[ i ].finity )
						Fish[ i ].sprite = 18;
					else
						Fish[ i ].sprite = 8;
					break;
				case 8:
					if ( Fish[ i ].finity )
						Fish[ i ].sprite = 15;
					else
						Fish[ i ].sprite = 5;
					break;
				case 4:
					flop++;
				case 6:
					if ( Fish[ i ].finity )
						Fish[ i ].sprite = 17;
					else
						Fish[ i ].sprite = 7;
					break;
				case 1:
					flop++;
				case 3:
					if ( Fish[ i ].finity )
						Fish[ i ].sprite = 19;
					else
						Fish[ i ].sprite = 9;
					break;
				case 2:
					if ( Fish[ i ].finity )
						Fish[ i ].sprite = 16;
					else
						Fish[ i ].sprite = 6;
					break;
				default:
					break;
			}
			if ( flop )
				ret = SDL_BlitFlop(Tile, &Sprite[ Fish[ i ].sprite ].frame[ Fish[ i ].curframe ], Surface, &dport );
			else
 				ret = SDL_BlitSurface( Tile, &Sprite[ Fish[ i ].sprite ].frame[ Fish[ i ].curframe ], Surface, &dport );

 			Fish[ i ].dist++;
 			if ( Fish[ i ].dist == Sprite[ Fish[ i ].sprite ].odom )
			{
 				Fish[ i ].curframe++;
 				if ( Fish[ i ].curframe >= Sprite[ Fish[ i ].sprite ].framenum )
					Fish[ i ].curframe = 0; 
				Fish[ i ].dist = 0; 
			}
		}
	}

	if ( Fish[ 0 ].finity > -1 )
	{
		dport.x = HALFSCREENWIDTH - 4; // half a fish
		dport.y = HALFSCREENHEIGHT - 4;
		dport.w = Sprite[ Fish[ 0 ].sprite ].frame[ 0 ].w;
		dport.h = Sprite[ Fish[ 0 ].sprite ].frame[ 0 ].h;

		flop = 0;
		switch( Fish[ 0 ].rection ) // the lone fish
		{
			case 7:
				flop++;
			case 9:
				Fish[ 0 ].sprite = 13;
				break;
			case 8:
				Fish[ 0 ].sprite = 10;
				break;
			case 4:
				flop++;
			case 6:
				Fish[ 0 ].sprite = 12;
				break;
			case 1:
				flop++;
			case 3:
				Fish[ 0 ].sprite = 14;
				break;
			case 2:
				Fish[ 0 ].sprite = 11;
				break;
			default:
				break;
		}
		if ( flop )
			ret = SDL_BlitFlop(Tile, &Sprite[ Fish[ 0 ].sprite ].frame[ Fish[ 0 ].curframe ], Surface, &dport );
		else
 			ret = SDL_BlitSurface( Tile, &Sprite[ Fish[ 0 ].sprite ].frame[ Fish[ 0 ].curframe ], Surface, &dport );
	
 		Fish[ 0 ].dist++;
 		if ( Fish[ 0 ].dist == Sprite[ Fish[ 0 ].sprite ].odom )
		{
 			Fish[ 0 ].curframe++;
 			if ( Fish[ 0 ].curframe >= Sprite[ Fish[ 0 ].sprite ].framenum )
				Fish[ 0 ].curframe = 0; 
			Fish[ 0 ].dist = 0; 
		}
	}
	/*
	else
	{
		sport.x = 0; // stain
		sport.y = 145;
		sport.w = 96;
		sport.h = 75;
		dport.x = HALFSCREENWIDTH - (sport.w / 2);
		dport.y = HALFSCREENHEIGHT - (sport.h / 2);
		dport.w = sport.w;
		dport.h = sport.h;
 		ret = SDL_BlitSurface( Tile, &sport, Surface, &dport );
	}
	*/

	for( i=0; i < Activenum; i++ )
	{
		sport.x = Predator[ i ].x - ( Sprite[ Predator[ i ].sprite ].frame[ 0 ].w / 2 ); // sprites virtual space
		sport.y = Predator[ i ].y - ( Sprite[ Predator[ i ].sprite ].frame[ 0 ].h / 2 );
		sport.w = Predator[ i ].x + ( Sprite[ Predator[ i ].sprite ].frame[ 0 ].w / 2 ); // not width
		sport.h = Predator[ i ].y + ( Sprite[ Predator[ i ].sprite ].frame[ 0 ].h / 2 ); // not height

		if ( i > Predatornum - 4 ) 
		{
			seekfish( &Predator[ i ] ); // kill you now
		}
		else if ( ++Predator[ i ].finity > SINTERVAL ) // time for direction
		{
			roll = dragon( 96.0 ); // need variety
			if ( roll < 32 )
			{
				if ( seekball( &Predator[ i ] )) // true if already in zone
					Predator[ i ].rection = bounce( Predator[ i ].rection ); 
			} 
			else if ( roll < 60 )
			{
				seekfish( &Predator[ i ] ); 
			}
			else
			{
				Predator[ i ].rection = bounce( Predator[ i ].rection );
			}
			Predator[ i ].finity = 0; // reset
		}

		if ( intersectrect( &sport, &vport )) // the sharks virtual area is in our view
		{
			dport.x = ( sport.x - vport.x ); // virtual to physical
			dport.y = ( sport.y - vport.y );
			dport.w = Sprite[ Predator[ 0 ].sprite ].frame[ 0 ].w;
			dport.h = Sprite[ Predator[ 0 ].sprite ].frame[ 0 ].h;
			flop = 0;
			switch( Predator[ i ].rection ) 
			{
				case 1:
					flop++;
				case 3:
					Predator[ i ].sprite = 3;
					break;
				case 2:
					Predator[ i ].sprite = 4;
					break;
				case 4:
					flop++;
				case 6:
					Predator[ i ].sprite = 0;
					break;
				case 7:
					flop++;
				case 9:
					Predator[ i ].sprite = 1;
					break;
				case 8:
				default:
					Predator[ i ].sprite = 2;
					break;
			}

			if ( flop )
				ret = SDL_BlitFlop(Tile, &Sprite[ Predator[ i ].sprite ].frame[ Predator[ i ].curframe ], Surface, &dport );
			else
 				ret = SDL_BlitSurface( Tile, &Sprite[ Predator[ i ].sprite ].frame[ Predator[ i ].curframe ], Surface, &dport );
#ifdef REDZONE
			if ( flop ) // paint the hot zone bright red on top
				hz.x = dport.x + (Sprite[ Predator[ i ].sprite ].frame[ Predator[ i ].curframe ].w - ( Sprite[ Predator[ i ].sprite ].hot.x + Sprite[ Predator[ i ].sprite ].hot.w )) - 3;
			else
				hz.x = dport.x + Sprite[ Predator[ i ].sprite ].hot.x - 3;
			hz.y = dport.y + Sprite[ Predator[ i ].sprite ].hot.y - 3;
			hz.w = Sprite[ Predator[ i ].sprite ].hot.w + 6;
			hz.h = Sprite[ Predator[ i ].sprite ].hot.h + 6;
			SDL_FillRect( Surface, &hz, SDL_MapRGB( Surface->format, 0xFF, 0x00, 0x00 ));
#endif
 			Predator[ i ].dist++;
 			if ( Predator[ i ].dist == Sprite[ Predator[ i ].sprite ].odom )
			{
 				Predator[ i ].curframe++;
 				if ( Predator[ i ].curframe >= Sprite[ Predator[ i ].sprite ].framenum )
					Predator[ i ].curframe = 0; 
				Predator[ i ].dist = 0; 
			}
			Predator[ i ].speed = dragon( 4.0 ) + 4;
 		}
	}
	deadfish( Surface );
}

//-----------------------------------------------
// void deadfish( void ) - score and give them the bad news
//-----------------------------------------------
void deadfish( SDL_Surface *Surface )
{
	RECT dport, sport;
	char scorestr[32] = "";
	short ret = 0;

	dport.x = 2;
	dport.y = 2;
	dport.w = 9;
	dport.h = 9;
	sport.x = 321; // headstone
	sport.y = 32;
	sport.w = 8;
	sport.h = 8;
 	ret = SDL_BlitSurface( lpAlphabet, &sport, Surface, &dport );
	dport.x = 288;
	dport.y = 2;
	dport.w = 9;
	dport.h = 9;
	sport.x = 331; // heart
	sport.y = 32;
	sport.w = 8;
	sport.h = 8;
 	ret = SDL_BlitSurface( lpAlphabet, &sport, Surface, &dport );
	sprintf( scorestr, "%d", guy.deadfish );
	textxy( Surface, 12, 1, scorestr, -1, 4 );
	sprintf( scorestr, "%d", guy.goodfish );
	textxy( Surface, 296, 1, scorestr, -1, 4 );
	sprintf( scorestr, "%08d", guy.score );
	textxy( Surface, 127, 1, scorestr, -1, 4 );
	if ( Fish[ 0 ].finity < 0 )
	{
		racketplay( WHALE, 0 );
		dport.x = 73;
		dport.y = 89;
		dport.w = 162;
		dport.h = 22;
		SDL_FillRect( Surface, &dport, SDL_MapRGB( Surface->format, 0x00, 0x00, 0x00 ) );
		dport.x = 74;
		dport.y = 90;
		dport.w = 160;
		dport.h = 20;
		SDL_FillRect( Surface, &dport, SDL_MapRGB( Surface->format, 0x80, 0xB5, 0xEC ) );
		if ( guy.deadfish > guy.goodfish )
			textxy( Surface, 87, 95, "KILL EXCEEDS SAVE", -1, 3 );
		else 
			textxy( Surface, 87, 95, "YOUR FISH IS DEAD", -1, 3 );

		dport.x = 189;
		dport.y = 178;
		dport.w = 102;
		dport.h = 22;
		SDL_FillRect( Surface, &dport, SDL_MapRGB( Surface->format, 0x00, 0x00, 0x00 ) );
		dport.x = 190;
		dport.y = 179;
		dport.w = 100;
		dport.h = 20;
		SDL_FillRect( Surface, &dport, SDL_MapRGB( Surface->format, 0x80, 0xB5, 0xEC ) );
		textxy( Surface, 200, 184, "A TO RESPAWN", -1, 4 );

		dport.x = 29;
		dport.y = 178;
		dport.w = 102;
		dport.h = 22;
		SDL_FillRect( Surface, &dport, SDL_MapRGB( Surface->format, 0x00, 0x00, 0x00 ) );
		dport.x = 30;
		dport.y = 179;
		dport.w = 100;
		dport.h = 20;
		SDL_FillRect( Surface, &dport, SDL_MapRGB( Surface->format, 0x80, 0xB5, 0xEC ) );
		sprintf( scorestr, "SCORE %d", guy.topscore - ( guy.deadfish ? guy.deadfish / 4 : 1 ));
		textxy( Surface, 50, 184, scorestr, -1, 4 );
		hitanybutton(); // only paints
		racketoff( FISHSONG );
	}
	if ( guy.deadfish > guy.goodfish ) // game over
		Fish[ 0 ].finity = -1;
}

//-----------------------------------------------
// void census( void ) - take a current by current population poll to direct the predators
//-----------------------------------------------
void census( void )
{
	int found = 0, i, j, o = 0;

	if ( guy.score % Ocean.when )
		o++;

	if ( o )
	{
		for( j=0; j < Currentnum; j++ ) // clear
		{
			Current[ j ].pop = 0;
		}
	}

	for( i=0; i < Fishnum; i++ )
	{
		if ( Fish[ i ].finity < 0 )
			continue;
		for( j=0; ! found && j < Currentnum; j++ )
		{
			if ( xyinrect( Fish[i].x, Fish[i].y, &Current[ j ].area ))
			{
				if ( o )
					Current[ j ].pop++;
				Fish[ i ].current = j;
				found++;
			}
		}
		found = 0;
	}

	for( i=0; i < Activenum; i++ )
	{
		for( j=0; ! found && j < Currentnum; j++ )
		{
			if ( xyinrect( Predator[i].x, Predator[i].y, &Current[ j ].area ))
			{
				if ( o )
					Predator[ i ].current = j;
				found++;
			}
		}
		found = 0;
	}
}

//-----------------------------------------------
// void applycurrent(void) - push fish according to the ocean currents
//-----------------------------------------------
void applycurrent( void )
{
	int i;

	if ( Inertia )
		Inertia -= 2;

	for( i=0; i < Fishnum; i++ )
	{
		if ( Fish[ i ].finity < 0 ) // dead fish
			continue;
		switch( Current[ Fish[ i ].current ].rection )
		{
			case 1: // down left
				Fish[ i ].x -= Current[ Fish[ i ].current ].force;
				Fish[ i ].y += Current[ Fish[ i ].current ].force;
				break;
			case 2: // down
				Fish[ i ].y += Current[ Fish[ i ].current ].force;
				break;
			case 3: // down right
				Fish[ i ].x += Current[ Fish[ i ].current ].force;
				Fish[ i ].y += Current[ Fish[ i ].current ].force;
				break;
			case 4: // left
				Fish[ i ].x -= Current[ Fish[ i ].current ].force;
				break;
			case 6: // right
				Fish[ i ].x += Current[ Fish[ i ].current ].force;
				break;
			case 7: // up left
				Fish[ i ].x -= Current[ Fish[ i ].current ].force;
				Fish[ i ].y -= Current[ Fish[ i ].current ].force;
				break;
			case 8: // up
				Fish[ i ].y -= Current[ Fish[ i ].current ].force;
				break;
			case 9: // up right
				Fish[ i ].x += Current[ Fish[ i ].current ].force;
				Fish[ i ].y -= Current[ Fish[ i ].current ].force;
			default:
				break;
		}

		if ( i != 0 ) // ! Fish[ i ].finity )
		{
			switch( Fish[ i ].rection )
			{
				case 1: // down left
					Fish[i ].x -= Fish[ i ].speed;
					Fish[ i ].y += Fish[ i ].speed;
					break;
				case 2: // down
					Fish[ i ].y += Fish[ i ].speed;
					break;
				case 3: // down right
					Fish[ i ].x += Fish[ i ].speed;
					Fish[ i ].y += Fish[ i ].speed;
					break;
				case 4: // left
					Fish[ i ].x -= Fish[ i ].speed;
					break;
				case 6: // right
					Fish[ i ].x += Fish[ i ].speed;
					break;
				case 7: // up left
					Fish[ i ].x -= Fish[ i ].speed;
					Fish[ i ].y -= Fish[ i ].speed;
					break;
				case 8: // up
					Fish[ i ].y -= Fish[ i ].speed;
					break;
				case 9: // up right
					Fish[ i ].x += Fish[ i ].speed;
					Fish[ i ].y -= Fish[ i ].speed;
					break;
				case 5: // all stop
				default:
					Fish[ i ].rection = 6;
					break;
			}
		}
		else
		{
			switch( Fish[ i ].rection )
			{
				case 1: // down left
					Fish[ i ].x -= Fish[ i ].speed + Inertia;
					Fish[ i ].y += Fish[ i ].speed + Inertia;
					break;
				case 2: // down
					Fish[ i ].y += Fish[ i ].speed + Inertia;
					break;
				case 3: // down right
					Fish[ i ].x += Fish[ i ].speed + Inertia;
					Fish[ i ].y += Fish[ i ].speed + Inertia;
					break;
				case 4: // left
					Fish[ i ].x -= Fish[ i ].speed + Inertia;
					break;
				case 6: // right
					Fish[ i ].x += Fish[ i ].speed + Inertia;
					break;
				case 7: // up left
					Fish[ i ].x -= Fish[ i ].speed + Inertia;
					Fish[ i ].y -= Fish[ i ].speed + Inertia;
					break;
				case 8: // up
					Fish[ i ].y -= Fish[ i ].speed + Inertia;
					break;
				case 9: // up right
					Fish[ i ].x += Fish[ i ].speed + Inertia;
					Fish[ i ].y -= Fish[ i ].speed + Inertia;
					break;
				case 5: // all stop
				default:
					Fish[ i ].rection = 6;
					break;
			}
		}

		if ( Fish[ i ].x < 0  )
		{ 
			Fish[ i ].rection = bounce( Fish[ i ].rection );
			Fish[ i ].x = 24;
		}

		if (  Fish[ i ].y < 9 ) 
		{ 
			Fish[ i ].rection = bounce( Fish[ i ].rection );
			Fish[ i ].y = 24;
		}

		if ( Fish[ i ].x > Ocean.w )
		{
			Fish[ i ].rection = bounce( Fish[ i ].rection );
			Fish[ i ].x = Ocean.w - 24;
		}
		if ( Fish[ i ].y > Ocean.h )
		{
			Fish[ i ].rection = bounce( Fish[ i ].rection );
			Fish[ i ].y = Ocean.h - 24;
		}
	}
	for( i=0; i < Activenum; i++ )
	{

		switch( Predator[ i ].rection )
		{
			case 1: // down left
				Predator[ i ].x -= Predator[ i ].speed;
				Predator[ i ].y += Predator[ i ].speed;
				break;
			case 2: // down
				Predator[ i ].y += Predator[ i ].speed;
				break;
			case 3: // down right
				Predator[ i ].x += Predator[ i ].speed;
				Predator[ i ].y += Predator[ i ].speed;
				break;
			case 4: // left
				Predator[ i ].x -= Predator[ i ].speed;
				break;
			case 6: // right
				Predator[ i ].x += Predator[ i ].speed;
				break;
			case 7: // up left
				Predator[ i ].x -= Predator[ i ].speed;
				Predator[ i ].y -= Predator[ i ].speed;
				break;
			case 8: // up
				Predator[ i ].y -= Predator[ i ].speed;
				break;
			case 9: // up right
				Predator[ i ].x += Predator[ i ].speed;
				Predator[ i ].y -= Predator[ i ].speed;
			default:
				Predator[ i ].rection = bounce( Predator[ i ].rection );
				break;
		}
		if ( Predator[ i ].x < 0  )
		{ 
			Predator[ i ].rection = bounce( Predator[ i ].rection );
			Predator[ i ].x = 24;
		}

		if (  Predator[ i ].y < 0 ) 
		{ 
			Predator[ i ].rection = bounce( Predator[ i ].rection );
			Predator[ i ].y = 24;
		}

		if ( Predator[ i ].x > Ocean.w )
		{
			Predator[ i ].rection = bounce( Predator[ i ].rection );
			Predator[ i ].x = Ocean.w - 24;
		}
		if ( Predator[ i ].y > Ocean.h )
		{
			Predator[ i ].rection = bounce( Predator[ i ].rection );
			Predator[ i ].y = Ocean.h - 24;
		}
	}
}

//-----------------------------------------------
// void bigshow( SDL_Surface * ) - display the entire sea in miniature
//-----------------------------------------------
void bigshow( SDL_Surface *Screen )
{
	int i;
	RECT r = { 0, 0, 2, 2 };

	paintscreen( Screen, SDL_MapRGB( Screen->format, 0x2C, 0x44, 0x86 ));
	for( i=0; i < Activenum; i++ )
	{
		r.x = Predator[ i ].x / 4;
		r.y = Predator[ i ].y / 4;
		r.w = 4;
		r.h = 4;
		SDL_FillRect( Screen, &r, SDL_MapRGB( Screen->format, 0x00, 0x00, 0x00 ) );
	}
	for( i=1; i < Fishnum; i++ ) // blue fish only - skip red player fish 0
	{
		if ( Fish[ i ].finity < 0 )
			continue; 
		r.x = Fish[ i ].x / 4;
		r.y = Fish[ i ].y / 4;
		r.w = 2;
		r.h = 2;
		if ( Fish[ i ].finity > 0 )
			SDL_FillRect( Screen, &r, SDL_MapRGB( Screen->format, 0x48, 0xFF, 0x00 ) );
		else
			SDL_FillRect( Screen, &r, SDL_MapRGB( Screen->format, 0x62, 0xB0, 0xFF ) );
	}
	for( i=0; i < Islandnum; i++ )
	{
		r.x = Island[ i ].x / 4;
		r.y = Island[ i ].y / 4;
		r.w = Sprite[ Island[ i ].sprite ].frame[0].w / 4;
		r.h = Sprite[ Island[ i ].sprite ].frame[0].h / 4;
		SDL_FillRect( Screen, &r, SDL_MapRGB( Screen->format, 0xC0, 0xC0, 0xC0 ) );
	}

	r.x = Fish[ 0 ].x / 4;
	r.y = Fish[ 0 ].y / 4;
	r.w = 3;
	r.h = 3;
	SDL_FillRect( Screen, &r, SDL_MapRGB( Screen->format, 0xFF, 0xC0, 0xC0 ) );

	deadfish( Screen );
}

//-----------------------------------------------
// short bounce( short way ) -  returns the correct direction according to keypad
//-----------------------------------------------
short bounce( short way )
{
	short there = way;
	while ( there == way || there < 1 || there == 5 || there > 9 )
		there = dragon( 9.0 );
	switch( way )
	{
		case 0:
		case 2:
		case 4:
		case 6:
		case 8:
			there++;
		default:
			break;
	}
	return( there );
}

//-----------------------------------------------
// void fishdump( void ) - dump array to text for debugging
//-----------------------------------------------
void fishdump( void )
{
	int i;
/*
	fprintf( stderr, "\n-- Fish --\n" );
	for( i=0; i < Fishnum; i++ ) 
	{
		fprintf( stderr, "F-%d x:%d y:%d s:%d r:%d a:%d f:%d\n",
				i, Fish[ i ].x, Fish[ i ].y, Fish[ i ].speed, Fish[ i ].rection, Fish[ i ].action, Fish[ i ].finity );
	}
*/
	fprintf( stderr, "Fish %d x:%d y:%d s:%d r:%d a:%d f:%d\n",
				0, Fish[ 0 ].x, Fish[ 0 ].y, Fish[ 0 ].speed, Fish[ 0 ].rection, Fish[ 0 ].action, Fish[ 0 ].finity );
	fprintf( stderr, "\n-- Predator  Activenum = %d --\n", Activenum );
	for( i=0; i < Predatornum; i++ )
	{
		fprintf( stderr, "P-%d x:%d y:%d s:%d r:%d a:%d\n",
				i, Predator[ i ].x, Predator[ i ].y, Predator[ i ].speed, Predator[ i ].rection, Predator[ i ].action );
	}
	fprintf( stderr, "\n-- Current --\n" );
	for( i=0; i < Currentnum; i++ )
	{
		fprintf( stderr, "C-%d: p:%d r:%d s:%d f:%d\n", 
				i, Current[ i ].pop, Current[ i ].rection, Current[ i ].speed, Current[ i ].force );
	}
}

//-----------------------------------------------
// void collide( void ) - beat your fish
//-----------------------------------------------
void collide()
{
	int i, j;
	short range = 48;
	RECT src, prd;

	src.x = Fish[ 0 ].x - range; // alpha fish's sphere of influence
	src.y = Fish[ 0 ].y - range;
	src.w = Fish[ 0 ].x + range;
	src.h = Fish[ 0 ].y + range;


	for( i=0; i < Fishnum; i++ )
	{
		if ( Fish[ i ].finity < 0 )
			continue; 

		if ( i && ! Fish[ i ].finity && xyinrect( Fish[i].x, Fish[i].y, &src )) // turn yellow
		{
			Fish[ i ].finity = 1; // sign me up
			guy.goodfish++;
			guy.topscore++;
			racketplay( KISS, 0 );
		}

		for( j=0; j < Islandnum; j++ ) // fish vs island
		{
			prd.x = (Island[ j ].x - ( Sprite[ Island[ j ].sprite ].frame[ 0 ].w / 2 )) + Sprite[ Island[ j ].sprite ].hot.x;
			prd.y = (Island[ j ].y - ( Sprite[ Island[ j ].sprite ].frame[ 0 ].h / 2 )) + Sprite[ Island[ j ].sprite ].hot.y;
			prd.w = prd.x + Sprite[ Island[ j ].sprite ].hot.w;
			prd.h = prd.y + Sprite[ Island[ j ].sprite ].hot.h;
			if ( xyinrect( Fish[i].x, Fish[i].y, &prd ))
				Fish[ i ].rection = bounce( Fish[ i ].rection );

		}

		for( j=0; j < Activenum; j++ ) // fish vs predator
		{
			if ( i ) // ! alpha fish - improve odds for your followers
			{
				if ( Predator[ j ].rection == 1 || Predator[ j ].rection == 4 || Predator[ j ].rection == 7 ) // flopped
					prd.x = (Predator[ j ].x - ( Sprite[ Predator[ j ].sprite ].frame[ 0 ].w / 2 )) + (Sprite[ Predator[ j ].sprite ].frame[ Predator[ j ].curframe ].w - ( Sprite[ Predator[ j ].sprite ].hot.x + Sprite[ Predator[ j ].sprite ].hot.w ));
				else
					prd.x = (Predator[ j ].x - ( Sprite[ Predator[ j ].sprite ].frame[ 0 ].w / 2 )) + Sprite[ Predator[ j ].sprite ].hot.x;
				prd.y = (Predator[ j ].y - ( Sprite[ Predator[ j ].sprite ].frame[ 0 ].h / 2 )) + Sprite[ Predator[ j ].sprite ].hot.y;
				prd.w = prd.x + Sprite[ Predator[ j ].sprite ].hot.w;
				prd.h = prd.y + Sprite[ Predator[ j ].sprite ].hot.h;
			}
			else // 6 bigger
			{
				if ( Predator[ j ].rection == 1 || Predator[ j ].rection == 4 || Predator[ j ].rection == 7 ) // flopped
					prd.x = (Predator[ j ].x - ( Sprite[ Predator[ j ].sprite ].frame[ 0 ].w / 2 )) + (Sprite[ Predator[ j ].sprite ].frame[ Predator[ j ].curframe ].w - ( Sprite[ Predator[ j ].sprite ].hot.x + Sprite[ Predator[ j ].sprite ].hot.w )) - 3;
				else
					prd.x = (Predator[ j ].x - ( Sprite[ Predator[ j ].sprite ].frame[ 0 ].w / 2 )) + Sprite[ Predator[ j ].sprite ].hot.x - 3;
				prd.y = (Predator[ j ].y - ( Sprite[ Predator[ j ].sprite ].frame[ 0 ].h / 2 )) + Sprite[ Predator[ j ].sprite ].hot.y - 3;
				prd.w = prd.x + Sprite[ Predator[ j ].sprite ].hot.w + 6;
				prd.h = prd.y + Sprite[ Predator[ j ].sprite ].hot.h + 6;
			}

			if ( prd.x < 0 || prd.y < 0 || prd.w > Ocean.w || prd.h > Ocean.h ) // wouldn't hit anyway
				continue;

			if ( xyinrect( Fish[i].x, Fish[i].y, &prd ))
			{
				if ( guy.goodfish && Fish[ i ].finity > 0 ) // lost yellow one
					guy.goodfish--;
				if ( ! i || Fish[ i ].finity > 0 ) // only yellow fish eaten
				{
					guy.deadfish++;
					Fish[ i ].finity = -1; // eat me
					racketplay( BITE, 0 ); // chomp
					if ( i == 0 ) 
					{ 
#ifdef CONFIRMKILL 
						Predator[ j ].x = Fish[ 0 ].x;
						Predator[ j ].y = Fish[ 0 ].y;
#endif
#ifndef GP2X
						fprintf( stderr, "eaten at x:%d y:%d by predator #%d rection: %d sprite: %d kill zone x:%d y:%d w:%d h:%d\n", 
								Fish[ 0 ].x, Fish[ 0 ].y, j, Predator[ j ].rection, Predator[ j ].sprite, prd.x, prd.y, prd.w, prd.h );
#endif
					}
				}
			}
		}
	}

	for( j=0; j < Activenum; j++ ) // predator vs. island
	{
		prd.x = (Predator[ j ].x - ( Sprite[ Predator[ j ].sprite ].frame[ 0 ].w / 2 )) + Sprite[ Predator[ j ].sprite ].hot.x;
		prd.y = (Predator[ j ].y - ( Sprite[ Predator[ j ].sprite ].frame[ 0 ].h / 2 )) + Sprite[ Predator[ j ].sprite ].hot.y;
		prd.w = prd.x + Sprite[ Predator[ j ].sprite ].hot.w;
		prd.h = prd.y + Sprite[ Predator[ j ].sprite ].hot.h;

		for( i=0; i < Islandnum; i++ )
		{
			if ( intersectrect( &Sprite[ Island[ i ].sprite ].hot, &prd ))
				Predator[ j ].rection = bounce( Predator[ j ].rection );
		}
	}
}

//-----------------------------------------------
// void fishrespaw( void ) - do over 
//-----------------------------------------------
void fishrespawn( void )
{
	int i;

	guy.score = 0;
	guy.goodfish = 0;
	guy.deadfish = 0;
	guy.topscore = 0;
	Activenum = 0;
	for( i=0; i < Fishnum; i++ ) 
	{
		if ( i == 0 )
			Fish[ i ].speed = 6;
		else
			Fish[ i ].speed = dragon( 4.0 ) + 3; 
		Fish[ i ].x = dragon( Ocean.w ); 
		Fish[ i ].y = dragon( Ocean.h ); 
		Fish[ i ].curframe = 0;
		Fish[ i ].dist = 0;
		Fish[ i ].rection = dragon( 9.0 ); 
		Fish[ i ].finity = 0;
	}

	for( i=0; i < Predatornum; i++ ) // i see a blue fish and i want it painted black...
	{
		if ( i == 0 )
			Predator[ i ].speed = 6;
		else
			Predator[ i ].speed = dragon( 4.0 ) + 4; 
		Predator[ i ].x = dragon( Ocean.w ); 
		Predator[ i ].y = dragon( Ocean.h ); 
		Predator[ i ].curframe = 0;
		Predator[ i ].dist = 0;
		Predator[ i ].rection = dragon( 9.0 ); 
		Predator[ i ].finity = 0;
	}
	Fish[ 0 ].finity = 1;
	racketon( FISHSONG );
}

//-----------------------------------------------
// short seekball( FISH * ) - go towards high population area
// returns:
// 		true if already there
//-----------------------------------------------
short seekball( FISH *shark )
{
	short srow, scol, drow, dcol, i, d = 0, c = 0; 

	srow = shark->current / 4;
	scol = shark->current % 4;


	for( i=0; i < Currentnum; i++ ) // find current of highest fish density 
	{
		if ( Current[ i ].pop > d )
		{
			d = Current[ i ].pop;
			c = i;
		}
	}
	if ( shark->current != c ) 
	{

		drow = c / 4;
		dcol = c % 4;
	
		if ( scol > dcol && srow > drow )
			shark->rection = 7;
		if ( scol < dcol && srow < drow )
			shark->rection = 3;
		if ( scol < dcol && srow > drow )
			shark->rection = 9;
		if ( scol > dcol && srow < drow )
			shark->rection = 1;
		if ( scol == dcol && srow < drow )
			shark->rection = 8;
		if ( scol == dcol && srow > drow )
			shark->rection = 2;
		if ( scol < dcol && srow == drow )
			shark->rection = 4;
		if ( scol > dcol && srow == drow )
			shark->rection = 6;
	}
	return( shark->current == c );
}

//-----------------------------------------------
// void seekfish( FISH * ) - say g'night gracie
//-----------------------------------------------
void seekfish( FISH *shark )
{
	short frow, fcol, srow, scol;
	FISH *zfish = &Fish[ 0 ];

	frow = zfish->current / 4;
	fcol = zfish->current % 4;

	srow = shark->current / 4;
	scol = shark->current % 4;
	
	if ( zfish->current == shark->current ) 
	{
		if ( shark->x > zfish->x &&  shark->y > zfish->y )
			shark->rection = 7;
		else if ( shark->x < zfish->x &&  shark->y < zfish->y )
			shark->rection = 3;
		else if ( shark->x < zfish->x &&  shark->y > zfish->y )
			shark->rection = 9;
		else if ( shark->x > zfish->x &&  shark->y < zfish->y )
			shark->rection = 1;
	}
	else
	{
		if ( scol > fcol && srow > frow )
			shark->rection = 7;
		if ( scol < fcol && srow < frow )
			shark->rection = 3;
		if ( scol < fcol && srow > frow )
			shark->rection = 9;
		if ( scol > fcol && srow < frow )
			shark->rection = 1;
	}
}
//-----------------------------------------------
//eof
//-----------------------------------------------
