//----------------------------------------------------------------------------
//  Fishball By Linus Sphinx and Ting Hsu (c)Copyright 2007 all rights reserved
//----------------------------------------------------------------------------
//
//    This file is the main entry part of Fishball
//
//    Fishball is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 3 of the License, or
//    (at your option) any later version.
//
//    Fishball is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Fishball; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//--------------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <pthread.h>
#include <SDL.h>
#include <SDL_mixer.h>
#include "fish.h"
#include "util.h"
#include "racket.h"
#include "text.h"
#include "topten.h"
#include "ocean.h"
#include "draw.h"

SDL_Surface *Screen;
SDL_Surface *lpFish;
SDL_Surface *lpTile;
SDL_Joystick *joystick;
RECT rect = { 0, 0, SCREENWIDTH, SCREENHEIGHT };
OPTIONS Option;
PLAYER guy;
//--------
OCEAN Ocean;
CURRENT *Current;
short Currentnum;
SPRITE *Sprite;
short Spritenum;
FISH *Fish;
short Fishnum;
FISH *Predator;
short Predatornum;
ISLAND *Island;
short Islandnum;
short Activenum = 0; // number of predators actually in play
//--------
extern Mix_Chunk **Noise; // global array of sounds
short saved = 0; // top ten not written
short Smallview = 0; // step back
short Inertia = 0; // burst of speed
#define BOOST 16 // how much speed to burst
short Paused = 0; // all stop 
#ifdef GP2X
short rdown = 0, ldown = 0;
#endif
extern unsigned long Now; // util.c

//---------------
// shutdown now
//---------------
void quit()
{
	racketstop();
	oceancleanup();
	SDL_Quit();
	chdir("/usr/gp2x");
	execl("/usr/gp2x/gp2xmenu", "/usr/gp2x/gp2xmenu", NULL);
	exit(0);
}

//-----------------------------------------------
// void hitanykey(void) - wait for a key press
// ----------------------------------------------
short hitanykey()
{
	int anykey = 0;
	SDL_Event event;

	while(!anykey)
	{
		while( SDL_PollEvent( &event ))
		{
			switch( event.type )
			{
#ifdef GP2X
				case SDL_JOYBUTTONDOWN:
					switch(event.jbutton.button)
					{
						case GP2X_BUTTON_A: 
							if ( Fish[ 0 ].finity < 0 )
								fishrespawn(); // do over
						case GP2X_BUTTON_B: 
						case GP2X_BUTTON_X: 
                   		case GP2X_BUTTON_SELECT:
                   		case GP2X_BUTTON_START:
						case GP2X_BUTTON_CLICK:
							anykey++;
							break;

						case GP2X_BUTTON_R:
							rdown = 1;
							if ( ldown && rdown )
								return( 1 );
							continue;

						case GP2X_BUTTON_L:
							ldown = 1;
							if ( ldown && rdown )
								return( 1 );
							continue;

						case GP2X_BUTTON_Y:
							Smallview = !Smallview; // step back
							continue;
						case GP2X_BUTTON_VOLUP:
							racketvolume( 2 );
							racketplay( BITE, 0 );
							continue;
						case GP2X_BUTTON_VOLDOWN:
							racketvolume( -2 );
							racketplay( BITE, 0 );
						default:
							continue;
					}

				case SDL_JOYBUTTONUP:
					switch(event.jbutton.button)
					{
						case GP2X_BUTTON_A: 
						case GP2X_BUTTON_X: 
						case GP2X_BUTTON_B: 
						case GP2X_BUTTON_Y: 
							continue;
						case GP2X_BUTTON_L:
							ldown=0;
							continue;
						case GP2X_BUTTON_R:
							rdown=0;
						default:
							continue;
					}
#else
				case SDL_KEYDOWN:
					switch( event.key.keysym.sym )
					{
						case SDLK_F6:
							racketvolume( -2 );
							racketplay( BITE, 0 ); 
							continue;

						case SDLK_F7:
							racketvolume( 2 );
							racketplay( BITE, 0 );
							continue;
						
						case SDLK_F9:
							fishdump();
							continue;
						case SDLK_y:
							Smallview = !Smallview; // step back
							continue;
						case SDLK_f:
							SDL_WM_ToggleFullScreen( Screen );
							continue;
						case SDLK_g:
							SDL_BlitSurface( lpFish, NULL, Screen, NULL );
							SDL_Flip( Screen );
							continue;

						case SDLK_a:
							if ( Fish[ 0 ].finity < 0 )
								fishrespawn(); // do over
						case SDLK_n:
						case SDLK_q:
						case SDLK_ESCAPE:

						default :
							anykey++;
							break;
					}
					return( 0 );
#endif
				case SDL_QUIT: /* SDL_QUIT event (window close) */
					return( 1 );
				default:
					break;
			}
		}
	}
	SDL_Delay( 500 );  // pause and clear
	while ( SDL_PollEvent( &event ) )
		;;
	return( 0 );
}

//----------------------------------------
// help display
//----------------------------------------
void help()
{
	rect.x = 0;
	rect.w = SCREENWIDTH;
	rect.y = 0;
	rect.h = SCREENHEIGHT;
	SDL_SetClipRect( Screen, &rect );
	loadbmp( Screen, "bmp/help.bmp" );
	if ( hitanykey() )
		quit();
	loadbmp( Screen, "bmp/controls.bmp" );
	if ( hitanykey() )
		quit();
	toptenshow( Screen );
	if ( hitanykey() )
		quit();
}


//------------------------------------------------------------------
// short doevents(void) - process events and return 1 on quit keys 
//------------------------------------------------------------------
short doevents()
{
	SDL_Event event;

	while( SDL_PollEvent( &event ))
	{
		switch( event.type )
		{
			case SDL_QUIT: /* SDL_QUIT event (window close) */
				return( 1 );
#ifdef GP2X
        	case SDL_JOYBUTTONDOWN:
				switch(event.jbutton.button)
				{

					case GP2X_BUTTON_X: 
						break;
					case GP2X_BUTTON_B: 
						if ( Inertia < 4 )
							Inertia = BOOST;
						continue;
					case GP2X_BUTTON_CLICK:
						break;

					case GP2X_BUTTON_A: 
						if ( Paused )
						{
							racketon( FISHSONG );
							Paused = !Paused;
						}
						if ( Fish[ 0 ].finity < 0 )
							fishrespawn(); // do over
						break;

					case GP2X_BUTTON_Y: 
						Smallview = !Smallview; // step back
						continue;

					case GP2X_BUTTON_UP:
						Fish[ 0 ].rection = 8;
						break;

					case GP2X_BUTTON_UPLEFT:
						Fish[ 0 ].rection = 7;
						break;

					case GP2X_BUTTON_UPRIGHT:
						Fish[ 0 ].rection = 9;
						break;

					case GP2X_BUTTON_R:
						rdown = 1;
						if ( ldown && rdown )
							return( 1 );
						if ( Paused )
							racketon( FISHSONG );
						else
							racketoff( FISHSONG ); // ocean ambience paused too
						Paused = !Paused;
						continue;

					case GP2X_BUTTON_L:
						ldown = 1;
						if ( ldown && rdown )
							return( 1 );
						racketplay( LOCEAN, 0 ); // surf once
						help();
						break;

					case GP2X_BUTTON_LEFT:
						Fish[ 0 ].rection = 4;
						break;

					case GP2X_BUTTON_RIGHT:
						Fish[ 0 ].rection = 6;
						break;

					case GP2X_BUTTON_DOWN:
						Fish[ 0 ].rection = 2;
						break;

					case GP2X_BUTTON_DOWNLEFT:
						Fish[ 0 ].rection = 1;
						break;

					case GP2X_BUTTON_DOWNRIGHT:
						Fish[ 0 ].rection = 3;
						break;

                    case GP2X_BUTTON_SELECT:
						break;

					case GP2X_BUTTON_START:
						break;
					case GP2X_BUTTON_VOLUP:
						racketvolume( 2 );
						racketplay( BITE, 0 );
						continue;
					case GP2X_BUTTON_VOLDOWN:
						racketvolume( -2 );
						racketplay( BITE, 0 );
						continue;
				}
				break;

			case SDL_JOYBUTTONUP:
				switch(event.jbutton.button)
				{
					case GP2X_BUTTON_A: 
					case GP2X_BUTTON_X: 
					case GP2X_BUTTON_B: 
					case GP2X_BUTTON_Y: 
						break;
					case GP2X_BUTTON_L:
						ldown=0;
						break;
					case GP2X_BUTTON_R:
						rdown=0;
						break;
				}
				break;
#else
			case SDL_KEYDOWN:
				switch( event.key.keysym.sym )
				{
					case SDLK_ESCAPE:
					case SDLK_q: 
                        return( 1 ); // bail out of main loop
					case SDLK_f:
						SDL_WM_ToggleFullScreen( Screen );
						continue;
					case SDLK_r:
						if ( Paused )
							racketon( FISHSONG );
						else
							racketoff( FISHSONG );
						Paused = !Paused;
						continue;
					case SDLK_l:
						help();
						racketplay( LOCEAN, 0 ); 
						continue;
					case SDLK_b:
						if ( Inertia < 4 )
							Inertia = BOOST;
						continue;
					case SDLK_y:
						Smallview = !Smallview; // step back
						continue;
					case SDLK_a:
						if ( Fish[ 0 ].finity < 0 )
							fishrespawn(); // do over
						continue;
					case SDLK_LSHIFT:
						break;
					case SDLK_LCTRL:  
						break;
					case SDLK_UP:
						Fish[ 0 ].rection = 8;
						break;
					case SDLK_DOWN:
						Fish[ 0 ].rection = 2;
						break;
					case SDLK_LEFT:
						Fish[ 0 ].rection = 4;
						break;
					case SDLK_RIGHT:
						Fish[ 0 ].rection = 6;
						break;
					case SDLK_SPACE:
						break;
					case SDLK_F6:
						racketvolume( -2 );
						racketplay( BITE, 0 );
						continue;
					case SDLK_F7:
						racketvolume( 2 );
						racketplay( BITE, 0 );
						continue;
					case SDLK_F8:
						break;
					case SDLK_F9:
						fishdump();
					default :
						break;
			}
#endif
		}

	}
    return( 0 );
}

//----------------------------------------
// void draw(void) - paint a screen load
//----------------------------------------
void draw()
{
	rect.x = 0;
	rect.w = SCREENWIDTH;
	rect.y = 0;
	rect.h = SCREENHEIGHT;
	SDL_SetClipRect( Screen, &rect );
	drawbg( Screen, lpTile );
	drawocean( Screen, lpFish );
}

//----------------------------------------
// void banner( void ) - draw a box for a message
//----------------------------------------
void banner( void )
{
	RECT dport; // message box

	dport.x = 73;
	dport.y = 89;
	dport.w = 162;
	dport.h = 22;
	SDL_FillRect( Screen, &dport, SDL_MapRGB( Screen->format, 0xFF, 0xFF, 0xFF ) );

	dport.x = 74;
	dport.y = 90;
	dport.w = 160;
	dport.h = 20;
	SDL_FillRect( Screen, &dport, SDL_MapRGB( Screen->format, 0x80, 0xB5, 0xEC ) );
	
}

//----------------------------------------
// void hitanybutton( void ) - diplay the hitanybutton icon
//----------------------------------------
void hitanybutton( void ) 
{
	RECT dport, sport; // message box

	sport.x = 0; // hitanybutton
	sport.y = 224;
	sport.w = 25;
	sport.h = 16;

	dport.x = 293;
	dport.y = 223;
	dport.w = 25;
	dport.h = 16;

	SDL_BlitSurface( lpFish, &sport, Screen, &dport );
}

//-----------------------------------------------------------
// void copyleft(void) - logo
//-----------------------------------------------------------
void copyright(void)
{
	fputs("\nFISH BALL\n", stderr );
	fputs("by Linus Sphinx and Ting Hsu\n(c)Copyright 2007 all rights reserved\n", stderr );
	fputs("http://fullsack.com\n\n", stderr );
}

//-----------------------------------------------------------
// void fishhandler(int sig) - handle those annoying signals
//-----------------------------------------------------------
void fishhandler(int sig)
{
	fprintf( stderr, "caught signal %d\n", sig );
	fputs("yarr, going down with the ship\n", stderr );
	quit();
}

//---------------
// main program
//--------------- 
int main( int argc, char **argv )
{
	SDL_Event event;

	copyright();
	signal( SIGTERM, fishhandler );
	signal( SIGINT, fishhandler );

	Option.Sound = 1;
	racketstart();

	srand(time(NULL));
	if ( SDL_Init( SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_JOYSTICK )== -1 )
	{ 
		fprintf( stderr, "Init err: %s.\n", SDL_GetError());
		exit(1);
	}
	Screen = SDL_SetVideoMode( SCREENWIDTH, SCREENHEIGHT, COLORDEPTH, SDL_SWSURFACE ); //| SDL_FULLSCREEN ); 
	if ( Screen != NULL )
	{
#ifdef GP2X
		joystick = SDL_JoystickOpen(0); 
		if (!joystick) 
		{
			fprintf(stderr, "Err joystick: %s\n", SDL_GetError());
		}
#else
		SDL_WM_SetCaption("Fishball By Linus Sphinx and Ting Hsu", "Fishball");
#endif
 		SDL_SetClipRect(Screen, &rect);
		SDL_ShowCursor( SDL_DISABLE );
		textinit();
		toptenload();
		oceanload();
		spriteload();
		fishload();
		sharkload();
		rockload();
		guy.goodfish = 0;
		guy.deadfish = 0;
		guy.topscore = 0;
		loadbmp( Screen, "bmp/brand.bmp" );
		racketplay( WHOOSH, 0 ); // whoosh 
		if ( hitanykey() )
			quit();
		loadbmp( Screen, "bmp/fishball.bmp" );
		lpFish = SDL_LoadBMP( "bmp/fish.bmp" );
		lpTile = SDL_LoadBMP( "bmp/agua2.bmp" );
		SDL_SetColorKey( lpFish, SDL_SRCCOLORKEY, SDL_MapRGB( lpFish->format, 255, 85, 213 ));

		racketplay( WHALE, 1 ); // whale song twice 
		if ( hitanykey() )
			quit();
		racketplay( WHALE, 0 ); // whale song again
		racketon( LOCEAN ); // surf ambience
		help();
		census(); // start the party preload
		applycurrent();
		bigshow( Screen ); 
		banner();
		hitanybutton();
		textxy( Screen, 104, 95, "SAVE THE FISH", -1, 3 );
		SDL_Flip( Screen );
		if ( hitanykey() )
			quit();
		racketoff( LOCEAN ); // surf ambience 
		racketon( FISHSONG ); // ocean ambience 

		do
		{
			do
			{
				if ( !Paused )
				{
					census();
					applycurrent();
					guy.score++; // time clock
					if ( guy.score % 25 == 0 && Activenum < Predatornum )
						Activenum++; // adds a shark
					collide();
					if ( ! Smallview  )
						draw();
					else
						bigshow( Screen ); // zoom out
				}
				else
				{
					banner();
					textxy( Screen, 128, 95, "PAUSED", -1, 3 );
				}
				SDL_Flip( Screen );
				if ( doevents() )
				{
					Fish[ 0 ].finity = -1;
					break;
				}
				SDL_Delay(timeleft( RATE )); // 1/18 = 55 1/12 = 83
			}
			while( Fish[ 0 ].finity != -1 );

			draw(); // last peek
			SDL_Flip( Screen );
			toptenstoptheclock();
			SDL_Delay( 1000 );  // pause and clear
			while ( SDL_PollEvent( &event ) )
				;;
			if ( hitanykey() ) // last chance to reset here
				quit();
		}
		while ( Fish[ 0 ].finity != -1 );

		racketoff( FISHSONG ); // ocean ambience off
		racketon( LOCEAN ); // surf ambience on

		if ( ! topteneligible( Screen ) ) // add score
		{
			loadbmp( Screen, "bmp/fishfood.bmp" ); // not in top ten
			if ( hitanykey() )
				quit();
		}
		else
		{
			while ( SDL_PollEvent( &event ) ) // clear buffer after top tentry
				;;
		}
		rect.x = 0;
		rect.y = 0;
		rect.w = SCREENWIDTH;
		rect.h = SCREENHEIGHT;
		SDL_SetClipRect(Screen, &rect);
		toptenshow( Screen );
		textdestroy();
		if ( hitanykey() )
			quit();
		racketplay( WHALE, 0 ); // one last whale song 
		loadbmp( Screen, "bmp/orca.bmp" );
		if ( hitanykey() )
			quit();
		paintscreen( Screen, 0 );
		SDL_Flip( Screen );
	}
	quit();
	return(0); // never arrives
}
// eof
