//----------------------------------------------------------------------------
//  Fish Ball By Linus Sphinx & Ting Hsu (c)Copyright 2005 all rights reserved
//----------------------------------------------------------------------------
//
//    Fish Ball is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 3 of the License, or
//    (at your option) any later version.
//
//    Fish Ball is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Fish Ball II; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//--------------------------------------------------------------------------------
// elf file loading and parsing of the data that makes up the virtual ocean
//--------------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <SDL.h>
#include <SDL_mixer.h>
// ---
#include "fish.h"
#include "util.h"
#include "ocean.h"
#include "draw.h"

// -- from fish.c
extern OCEAN Ocean;
extern CURRENT *Current;
extern short Currentnum; // size of Current array
extern SPRITE *Sprite;
extern short Spritenum; // size of Sprite array
extern FISH *Fish;
extern short Fishnum; // size of Fish array
extern FISH *Predator;
extern short Predatornum; // size of Fish array
extern ISLAND *Island;
extern short Islandnum;

//------------------------------------
// void oceanload( void )
//	  1. open and read bmp/ocean.elf
//	  2. size the virtual ocean
//	  3. size Current array to fit
//	  4. fill Current[]'s with data
//------------------------------------

void oceanload( void )
{
	char path[256] = "bmp/ocean.elf";
	char comstr[256] = "";
	char *txt = NULL;
	char *place;
	char *nextarg;
	int ofile;
	off_t sizeofile, actual;
	int i = 0, cmd; // i = index in Current[]
	
	ofile = open( path,  O_RDONLY );
	if ( ofile > 1 )
	{
		sizeofile = lseek( ofile, 0L, SEEK_END );
		lseek( ofile, 0L, SEEK_SET );
		txt = (char *)calloc( sizeofile + 1, sizeof(char));
		if ( txt != NULL )
		{
			txt[ sizeofile ] = '\0';
			place = txt;
			actual = read( ofile, txt, sizeofile );
			if ( actual == sizeofile )
			{
				while( nextCommand( place, comstr )) 
				{
					place += strlen( comstr );
					while ( *place && *place != '\n' ) // strip empty lines
						place++;
					nextarg = (char *)strtok( comstr, ":" );
					cmd = (int)comstr[0];
					switch( cmd )
					{
						case 35: // # total current count
							nextarg = (char *)strtok( NULL, "," );
							Currentnum = atoi( nextarg ); // now we can initialize array
#ifndef GP2X
fprintf( stderr, "Current %d knots\n", Currentnum );
#endif
							Current = (CURRENT*)calloc( Currentnum + 1, sizeof(CURRENT) );
							if ( Current == NULL )
							{
								fprintf( stderr, "fatal error allocating ocean\n" );
								exit( 1 );
							}	
							nextarg = (char *)strtok( NULL, "," );
							Ocean.w = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Ocean.h= atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Ocean.when= atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Ocean.speed = atoi( nextarg ); 
#ifndef GP2X
							fprintf( stderr, "Ocean %d leagues wide %d fathoms deep at %d bells\n", Ocean.w, Ocean.h, Ocean.when );
							fprintf( stderr, "%d foot swells\n", Ocean.speed );
#endif
							break;
	
						case 99: // c wave
							nextarg = (char *)strtok( NULL, "," );
							Current[ i ].area.x = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Current[ i ].area.y = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Current[ i ].area.w = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Current[ i ].area.h = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Current[ i ].rection = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Current[ i ].speed = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Current[ i ].force = atoi( nextarg );
						/*	fprintf( stderr, "Current[%d] - x:%d y:%d w:%d h:%d rection:%d\n", 
									i, Current[i].area.x, Current[i].area.y,
									Current[i].area.w, Current[i].area.h, Current[i].rection ); */
							++i;

						default:
							break;
					}
				}
			}
			free( txt );
		}
		close( ofile );	
	}
	else
	{
		fprintf( stderr, "fatal error reading bmp/ocean.elf\n" );
		exit( -1 );
	}
}

//------------------------------------
// void spriteload( void )
//	  1. open and read bmp/sprite.elf
//	  2. size the sprite array
//	  3. size each sprites animation array to fit
//	  4. fill both with data
//------------------------------------

void spriteload( void )
{
	char path[256] = "bmp/sprite.elf";
	char comstr[256] = "";
	char *txt = NULL;
	char *place;
	char *nextarg;
	int sfile;
	off_t sizeofile, actual;
	short i = 0, cmd, curframe = 0; // i = index in Sprite[]
	
	sfile = open( path,  O_RDONLY );
	if ( sfile > 1 )
	{
		sizeofile = lseek( sfile, 0L, SEEK_END );
		lseek( sfile, 0L, SEEK_SET );
		txt = (char *)calloc( sizeofile + 1, sizeof(char));
		if ( txt != NULL )
		{
			txt[ sizeofile ] = '\0';
			place = txt;
			actual = read( sfile, txt, sizeofile );
			if ( actual == sizeofile )
			{
				while( nextCommand( place, comstr )) 
				{
					place += strlen( comstr );
					while ( *place && *place != '\n' ) // strip empty lines
						place++;
					nextarg = (char *)strtok( comstr, ":" );
					cmd = (int)comstr[0];
					switch( cmd )
					{
						case 35: // # total sprite count
							nextarg = (char *)strtok( NULL, "," );
							Spritenum= atoi( nextarg ); // now we can initialize array
#ifndef GP2X
							fprintf( stderr, "%d sardines to the can\n", Spritenum );
#endif				
							Sprite = (SPRITE*)calloc( Spritenum + 1, sizeof(SPRITE) );
							if ( Sprite == NULL )
							{
								fprintf( stderr, "fatal error allocating sprite\n" );
								exit( 1 );
							}	
							break;

						case 115: // s sprite
							nextarg = (char *)strtok( NULL, "," );
							Sprite[ i ].hot.x = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Sprite[ i ].hot.y = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Sprite[ i ].hot.w = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Sprite[ i ].hot.h = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Sprite[ i ].opaque = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Sprite[ i ].framenum = atoi( nextarg );
							if ( Sprite[ i ].frame != NULL )
								free( Sprite[ i ].frame );
							Sprite[ i ].frame = (RECT *)calloc( Sprite[ i ].framenum + 1, sizeof( RECT ));
							nextarg = (char *)strtok( NULL, "," );
							Sprite[ i ].odom = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							if ( nextarg != NULL )
								Sprite[ i ].noise = atoi( nextarg );
					/*		fprintf( stderr, "Sprite[%d] - hx:%d hy:%d hw:%d hh:%d o:%d f:%d d:%d\n", 
									i, Sprite[i].hot.x, Sprite[i].hot.y, Sprite[i].hot. w,Sprite[i].hot.h,
									Sprite[i].opaque, Sprite[i].framenum, Sprite[i].odom ); */
							i++;
							curframe = 0; // expect framenum quad commands below
							break;
	
						case 113: // q quadrangle
							nextarg = strtok( NULL, "," );
							Sprite[ i - 1 ].frame[ curframe ].x = atoi( nextarg );
							nextarg = strtok( NULL, "," );
							Sprite[ i - 1 ].frame[ curframe ].y = atoi( nextarg );
							nextarg = strtok( NULL, "," );
							Sprite[ i - 1 ].frame[ curframe ].w = atoi( nextarg );
							nextarg = strtok( NULL, "," );
							Sprite[ i - 1 ].frame[ curframe ].h = atoi( nextarg );
					/*		fprintf( stderr, "Sprite[%d].frame[%d] - x:%d y:%d w:%d h:%d\n", 
									i-1, curframe, Sprite[i-1].frame[curframe].x, Sprite[i-1].frame[curframe].y, 
									Sprite[i-1].frame[curframe].w, Sprite[i-1].frame[curframe].h ); */
							curframe++;

						default:
							break;
					}
				}
			}
			free( txt );
		}
		close( sfile );	
	}
	else
	{
		fprintf( stderr, "fatal error reading bmp/sprite.elf\n" );
		exit( -1 );
	}
}

//------------------------------------
// void fishload( void )
//	  1. open and read bmp/fish.elf
//	  2. size Fish array to fit
//	  3. fill Fish[]'s with data
//------------------------------------

void fishload( void )
{
	char path[256] = "bmp/fish.elf";
	char comstr[256] = "";
	char *txt = NULL;
	char *place;
	char *nextarg;
	int ffile;
	off_t sizeofile, actual;
	int i = 0, cmd; // i = index in Fish[]
	
	ffile = open( path,  O_RDONLY );
	if ( ffile > 1 )
	{
		sizeofile = lseek( ffile, 0L, SEEK_END );
		lseek( ffile, 0L, SEEK_SET );
		txt = (char *)calloc( sizeofile + 1, sizeof(char));
		if ( txt != NULL )
		{
			txt[ sizeofile ] = '\0';
			place = txt;
			actual = read( ffile, txt, sizeofile );
			if ( actual == sizeofile )
			{
				while( nextCommand( place, comstr )) 
				{
					place += strlen( comstr );
					while ( *place && *place != '\n' ) // strip empty lines
						place++;
					nextarg = (char *)strtok( comstr, ":" );
					cmd = (int)comstr[0];
					switch( cmd )
					{
						case 35: // # total current count
							nextarg = (char *)strtok( NULL, "," );
							Fishnum = atoi( nextarg ); // now size fish array
#ifndef GP2X
							fprintf( stderr, "%d herring schooled\n", Fishnum );
#endif
							Fish = (FISH*)calloc( Fishnum + 1, sizeof(FISH) );
							if ( Fish == NULL )
							{
								fprintf( stderr, "fatal error allocating fish\n" );
								exit( 1 );
							}	
							break;
	
						case 102: // f fish
							nextarg = (char *)strtok( NULL, "," );
							Fish[ i ].z = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Fish[ i ].action = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Fish[ i ].ttl = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							if ( i == 0 )
								Fish[ i ].speed = 6;
							else
								Fish[ i ].speed = dragon( 4.0 ) + 3; // atoi( nextarg );
							Fish[ i ].x = dragon( Ocean.w ); // rand() % Ocean.w;
							Fish[ i ].y = dragon( Ocean.h ); // rand() % Ocean.h;
							Fish[ i ].curframe = 0;
							Fish[ i ].dist = 0;
							Fish[ i ].rection = dragon( 9.0 ); // 1 + rand() % 9;
							Fish[ i ].finity = 0;

							/* fprintf( stderr, "Fish[%d] - z:%d a:%d t:%d s:%d x:%d y:%d c:%d d:%d r:%d\n", 
									i, Fish[i].z, Fish[i].action, Fish[i].ttl, Fish[i].speed,
									Fish[i].x, Fish[i].y, Fish[i].curframe, Fish[i].dist,
									Fish[i].rection ); */
									
							++i;

						default:
							break;
					}
				}
			}
			free( txt );
		}
		close( ffile );	
		i=0;
		/* fprintf( stderr, "Fish[%d] - z:%d a:%d t:%d s:%d x:%d y:%d c:%d d:%d r:%d\n", 
							i, Fish[i].z, Fish[i].action, Fish[i].ttl, Fish[i].speed,
							Fish[i].x, Fish[i].y, Fish[i].curframe, Fish[i].dist,
							Fish[i].rection ); */
	}
	else
	{
		fprintf( stderr, "fatal error reading bmp/fish.elf\n" );
		exit( -1 );
	}
	Fish[ 0 ].finity = 1;
}

//------------------------------------
// void sharkload( void )
//	  1. open and read bmp/predator.elf
//	  2. size Predator array to fit
//	  3. fill Preadator[]'s with data
//------------------------------------

void sharkload( void )
{
	char path[256] = "bmp/predator.elf";
	char comstr[256] = "";
	char *txt = NULL;
	char *place;
	char *nextarg;
	int pfile;
	off_t sizeofile, actual;
	int i = 0, cmd; // i = index in Fish[]
	
	pfile = open( path,  O_RDONLY );
	if ( pfile > 1 )
	{
		sizeofile = lseek( pfile, 0L, SEEK_END );
		lseek( pfile, 0L, SEEK_SET );
		txt = (char *)calloc( sizeofile + 1, sizeof(char));
		if ( txt != NULL )
		{
			txt[ sizeofile ] = '\0';
			place = txt;
			actual = read( pfile, txt, sizeofile );
			if ( actual == sizeofile )
			{
				while( nextCommand( place, comstr )) 
				{
					place += strlen( comstr );
					while ( *place && *place != '\n' ) // strip empty lines
						place++;
					nextarg = (char *)strtok( comstr, ":" );
					cmd = (int)comstr[0];
					switch( cmd )
					{
						case 35: // # total current count
							nextarg = (char *)strtok( NULL, "," );
							Predatornum = atoi( nextarg ); // now size predator array
#ifndef GP2X
							fprintf( stderr, "Thar blow %d whale\n", Predatornum );
#endif
							Predator = (FISH*)calloc( Predatornum + 1, sizeof(FISH) );
							if ( Predator == NULL )
							{
								fprintf( stderr, "fatal error allocating predator\n" );
								exit( 1 );
							}	
							break;
	
						case 112: // p predator
							nextarg = (char *)strtok( NULL, "," );
							Predator[ i ].z = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Predator[ i ].action = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Predator[ i ].ttl = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Predator[ i ].speed = atoi( nextarg );
							Predator[ i ].speed = dragon( 3.0 ) + 5; // atoi( nextarg );
							Predator[ i ].x = dragon( Ocean.w ); // rand() % Ocean.w;
							Predator[ i ].y = dragon( Ocean.h ); // rand() % Ocean.h;
							Predator[ i ].curframe = 0;
							Predator[ i ].dist = 0;
							Predator[ i ].rection = dragon( 9.0 ); // 1 + rand() % 9;
							if ( Predator[ i ].rection == 5 ) 
								Predator[ i ].rection = 6;
							Predator[ i ].finity = dragon(SINTERVAL);

						/*	fprintf( stderr, "Predator[%d] - z:%d a:%d t:%d s:%d x:%d y:%d c:%d d:%d r:%d\n", 
									i, Predator[i].z, Predator[i].action, Predator[i].ttl, Predator[i].speed,
									Predator[i].x, Predator[i].y, Predator[i].curframe, Predator[i].dist,
									Predator[i].rection ); */
									
							++i;

						default:
							break;
					}
				}
			}
			free( txt );
		}
		close( pfile );	
	}
	else
	{
		fprintf( stderr, "fatal error reading bmp/predator.elf\n" );
		exit( -1 );
	}
}

//------------------------------------
// void rockload( void )
//	  1. open and read bmp/islands.elf
//	  2. size Island array to fit
//	  3. fill Island[]'s with data
//------------------------------------

void rockload( void )
{
	char path[256] = "bmp/islands.elf";
	char comstr[256] = "";
	char *txt = NULL;
	char *place;
	char *nextarg;
	int ifile;
	off_t sizeofile, actual;
	int i = 0, cmd; // i = index in Fish[]
	
	ifile = open( path,  O_RDONLY );
	if ( ifile > 1 )
	{
		sizeofile = lseek( ifile, 0L, SEEK_END );
		lseek( ifile, 0L, SEEK_SET );
		txt = (char *)calloc( sizeofile + 1, sizeof(char));
		if ( txt != NULL )
		{
			txt[ sizeofile ] = '\0';
			place = txt;
			actual = read( ifile, txt, sizeofile );
			if ( actual == sizeofile )
			{
				while( nextCommand( place, comstr )) 
				{
					place += strlen( comstr );
					while ( *place && *place != '\n' ) // strip empty lines
						place++;
					nextarg = (char *)strtok( comstr, ":" );
					cmd = (int)comstr[0];
					switch( cmd )
					{
						case 35: // # total count
							nextarg = (char *)strtok( NULL, "," );
							Islandnum = atoi( nextarg ); // now size island array
#ifndef GP2X
							fprintf( stderr, "%d lands ho\n\n", Islandnum );
#endif
							Island = (ISLAND*)calloc( Islandnum + 1, sizeof(ISLAND) );
							if ( Island == NULL )
							{
								fprintf( stderr, "fatal error allocating islands\n" );
								exit( 1 );
							}	
							break;
	
						case 105: // i island 
							nextarg = (char *)strtok( NULL, "," );
							Island[ i ].x = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Island[ i ].y = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Island[ i ].z = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Island[ i ].sprite = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Island[ i ].action = atoi( nextarg );
							nextarg = (char *)strtok( NULL, "," );
							Island[ i ].ttl = atoi( nextarg );
							Island[ i ].curframe = 0;
							Island[ i ].dist = 0;

							/* fprintf( stderr, "Island[%d] - x:%d y:%d x:%d s:%d a:%d\n", 
									i, Island[i].x, Island[i].y, Island[i].z, Island[i].sprite, Island[i].action ); */
									
							++i;

						default:
							break;
					}
				}
			}
			free( txt );
		}
		close( ifile );	
	}
	else
	{
		fprintf( stderr, "fatal error reading bmp/islands.elf\n" );
		exit( -1 );
	}
}

//------------------------------------
// void oceancleanup( void ) - cleans up the ocean at exit
//------------------------------------
void oceancleanup( void )
{
	int i;
	if ( Current != NULL )
		free( Current );

	for ( i = 0; i < Spritenum; i++ )
	{
		if ( Sprite[ i ].frame != NULL )
			free( Sprite[ i ].frame );
	}
	if ( Sprite != NULL )
		free( Sprite );
	if ( Fish != NULL )
		free( Fish );
	if ( Predator != NULL )
		free( Predator );

}

//eof
