//----------------------------------------------------------------------------
//  Fish Ball By Linus Sphinx and Ting Hsu (c)Copyright 2007 all rights reserved
//----------------------------------------------------------------------------
//
//    Definitions of the objects that make up our seafood soup
// 
//    Fish Ball is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 3 of the License, or
//    (at your option) any later version.
//
//    Fish Ball is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Fish Ball; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//--------------------------------------------------------------------------------

// fish are entities connected to an animation sequence by index into the sprite array 
typedef struct 
{
	short x; // virtual ocean coordinates
	short y;
	short z; // layer
	short sprite; // who am i
	short action; // index into array of function pointers defining behavior
	short rection; // according to numpad compass - 5 stationary
	short curframe; // the current frame - what this sprite is doing now
	short dist; // tracks when this = sprite->odom curframe++
	short ttl; // time to live before death or metamorphosis 0 = never
	short speed; // strength of fish - distance to move on it's turn
	short current; // quadrant you are in now
	short finity; // been touching your fish
} FISH;

// sprite is an animation sequence defined by an array of frame coordinates 
// and parameters on how to display them used by fish, islands etc.
typedef struct 
{
	short odom; //  times shown before incrementing curframe
	short opaque; // transparency
	short framenum; // number of frames
	short noise; // index to racket object array of sounds
	RECT hot; // coordinates in bitmap used in collision detection
	RECT *frame; // framenum sized array of frame rectangles of surface -left top right bottom
} SPRITE;

// islands are immovable objects connected to an animation sequence by index into the sprite array 
typedef struct 
{
	short x; // virtual ocean coordinates
	short y;
	short z; // layer
	short sprite; // sprite index
	short action; // collision behavior
	short curframe; // the current frame - what this sprite is doing now
	short dist; // tracks when this = sprite->odom curframe++
	short ttl; // time to live before death or metamorphosis 0 = never
} ISLAND;

typedef struct // virtual currents push you around the virtul ocean
{
	RECT area; // area in the virtual ocean coordinates
	short rection; // direction according to keypad
	short speed; // background movement
	short force; // lean on the fish
	short pop; // fish concentration
} CURRENT;

// her majesty the sea
typedef struct 
{
	short w; // virtual ocean size
	short h;
	short when; // how often to take census
	short speed; // how fast background scrolls
} OCEAN;

// prototypes
void oceanload( void );
void spriteload( void );
void fishload( void );
void sharkload( void );
void rockload( void );
void oceancleanup( void );

//eof
