//----------------------------------------------------------------------------
//  Reusable Mono Font By Linus Sphinx (c)Copyright 2007 all rights reserved
//----------------------------------------------------------------------------
//
//    Reusable Mono Fonts is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 3 of the License, or
//    (at your option) any later version.
//
//    Reusable Mono Fonts is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Reusable Mono Fonts; if not, write to:
//    The Free Software Foundation Inc.
//    51 Franklin St, Fifth Floor
//    Boston, MA  02110-1301
//    USA
//--------------------------------------------------------------------------------
// text display
//--------------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <SDL.h>
#include "fish.h"
#include "util.h"
#include "text.h"

/*
typedef struct {
short alpha; // true if full alphabet with numbers, false if just digits
short alphanum; // how manu letters in this alphabet
short charwide; // how wide each
short charhigh; // how high each
short alphax;   // x location of first character
short alphay;   // y location of first character
} ALF;
*/
ALF alf[ ALPHABETNUM ] = { { 1, 35, 8, 8, 0, 0 }, { 1, 35, 8, 8, 0, 10 }, { 0, 10, 5, 6, 0, 132 }, { 0, 35, 8, 10, 0, 20 }, { 0, 35, 7, 11, 0, 31 } };

SDL_Surface *lpAlphabet;
extern SDL_Surface *Screen;
extern OPTIONS Option;

//-----------------------------------------------------------------
// constructor
//-----------------------------------------------------------------
void textinit( void )

{
	lpAlphabet = SDL_LoadBMP( "bmp/alpha.bmp" );
	SDL_SetColorKey( lpAlphabet, SDL_SRCCOLORKEY, SDL_MapRGB( lpAlphabet->format, 255, 85, 213 ) );
}

//-----------------------------------------------------------------
// destructor
//-----------------------------------------------------------------
void textdestroy( void )
{
	if ( lpAlphabet != NULL )
		SDL_FreeSurface( lpAlphabet );
}

//-----------------------------------------------------------------
// restoreSurfaces
//-----------------------------------------------------------------
void textrestoreSurfaces( void )
{
	lpAlphabet = SDL_LoadBMP( "bmp/alpha.bmp" );
}

//----------------------------------------------------------------
// void textrect( short letter, short font, &RECT rect )
// put the letter'th frame of alf[ font ] in rect
//----------------------------------------------------------------
void textrect( short letter, short font, RECT *rect )
{
	rect->x = alf[ font ].alphax + ( letter * alf[ font ].charwide );
	rect->y = alf[ font ].alphay;
	rect->w = alf[ font ].charwide;
	rect->h = alf[ font ].charhigh;
}
//-----------------------------------------------------------------
// void textxy( int x, int y, char * string, int h ) 
// paints a string at x and y using alphabet f, frame h'th char in 
// a highlight frame if > -1
//-----------------------------------------------------------------
void textxy( SDL_Surface *surface, int x, int y, char *str, int h, int f )
{
	int j, len;
	short letter;
	RECT drect = { 0, 0, 0 , 0 };
	RECT trect = { 0, 0, 0 , 0 };
	RECT hlite = { 316, 0, 328 , 14 };

	len = strlen( str );
	for ( j = 0; j < len; j++ )
	{
		if ( str[ j ] > 47 && str[ j ] < 58 )
			letter = str[ j ] - 22;
		else if ( str[ j ] > 64 && str[ j ] < 91 ) 
			letter = str[ j ] - 65; // upper case
/*
		else if ( str[ j ] == 58 ) // colon
			letter = 36;
*/
		else if ( str[ j ] == ' ' ) 
			letter = 36;
		else
			continue; // skip it
		drect.x = x + ( j * alf[ f ].charwide );
		drect.y = y;
		if ( h == j )
		{
			drect.x -= 2;
			drect.y -= 3;
			if ( SDL_BlitSurface( lpAlphabet, &hlite, surface, &drect ))
				textrestoreSurfaces();
			drect.x += 2;
			drect.y += 3;
		}
		textrect( letter, f, &trect );
		if (SDL_BlitSurface( lpAlphabet, &trect, surface, &drect ))
			textrestoreSurfaces();
	}
}

//-----------------------------------------------------------------
// eof
//-----------------------------------------------------------------

