//----------------------------------------------------------------------------
//  The Reusable Top Ten Score List By Linus Sphinx (c)Copyright 2005 all rights reserved
//----------------------------------------------------------------------------
//
//    This file is part of Linus Sphinx's Reusable Top Ten Score List 
//
//    Reusable Top Ten Score List  is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 3 of the License, or
//    (at your option) any later version.
//
//    Reusable Top Ten Score List  is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Reusable Top Ten Score List ; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//--------------------------------------------------------------------------------
// top ten score list functions 
//--------------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include <SDL.h>
#include <SDL_mixer.h>
#include "fish.h"
#include "racket.h"
#include "util.h"
#include "text.h"
#include "topten.h"

TOPTEN Topten[ TENSIZE ];
TOPTEN Highscore = { " ", 0, 0, 0 };

short CurrentChar = 0;
extern PLAYER guy;
#ifdef GP2X
extern short rdown;
extern short ldown;
#endif

//--------------------------------------------------------------------------------
// load a top ten score file - format is TENSIZE array of TOPTEN in binary
//--------------------------------------------------------------------------------
void toptenload( void )
{
	int tfile, i; 
	off_t actual;
		 
	tfile = open( "topten", O_CREAT|O_RDWR, S_IRGRP |  S_IWGRP | S_IRUSR | S_IWUSR );
	if ( tfile > 1  )
	{
		actual = read( tfile, &Topten, sizeof(Topten));
		if ( actual < sizeof( Topten )) // bad or new file
		{
//			fprintf( stderr, "new top ten\n");
			for ( i = 0; i < TENSIZE; i++ )
			{
				strcpy( Topten[ i ].name, "" );
				Topten[ i ].dead = 0;
				Topten[ i ].good = 0;
			}
			strcpy( Topten[ 0 ].name, "NOLAN" ); 
			Topten[ 0 ].dead= 13;
			Topten[ 0 ].good = 74;
			Topten[ 0 ].ticks = 1134;
		}
		close( tfile);
	}
}

//--------------------------------------------------------------------------------
// top ten eligibility test
//--------------------------------------------------------------------------------
short topteneligible( SDL_Surface *Screen )
{
	short saved = 0;
	RECT rect;
	SDL_Surface *lpScope;
	short retval = 0;

	lpScope = SDL_LoadBMP( TOPSCOREFRAME );
	rect.x = 0;
	rect.y = 0;
	rect.w = SCREENWIDTH;
	rect.h = SCREENHEIGHT;
	SDL_SetClipRect(Screen, &rect);
	if ( guy.topscore > TOPSCOREMIN && Topten[ TENSIZE - 1 ].good < guy.topscore ) // sign in please
	{
		retval++;
		while( ! saved )
		{
			if ( SDL_BlitSurface( lpScope, &rect, Screen, &rect ))
				lpScope = SDL_LoadBMP( TOPSCOREFRAME );
			rect.x = 8;
			rect.y = 146;
			rect.w = 184;
			rect.h = 20;
			SDL_FillRect( Screen, &rect, SDL_MapRGB( lpScope->format, 0, 126, 255 ));
			rect.x = 10;
			rect.y = 148;
			rect.w = 180;
			rect.h = 16;
			SDL_FillRect( Screen, &rect, 0 );
			saved = toptentry( Screen );
			if ( saved < 0 )
				quit();
		}
	}
	if ( lpScope != NULL )
		SDL_FreeSurface( lpScope );
	return( retval );
}

//--------------------------------------------------------------------------------
// top ten qsort callback
//--------------------------------------------------------------------------------
int toptencmp( const TOPTEN *t1, const TOPTEN *t2 )
{
	short ret = 0;

	if ( t1->good > t2->good ) 
		ret = -1;
	if ( t1->good < t2->good ) 
		ret = 1;
	return ret;
}

//--------------------------------------------------------------------------------
// write a top ten score file in sorted order 
//--------------------------------------------------------------------------------
void toptensave( void )
{
	int tfile; 
	strcpy( Topten[ TENSIZE - 1 ].name, Highscore.name );
	Topten[ TENSIZE - 1 ].good = guy.topscore;
	Topten[ TENSIZE - 1 ].dead = Highscore.dead;
	Topten[ TENSIZE - 1 ].ticks = Highscore.ticks;
	qsort( Topten, TENSIZE, sizeof(TOPTEN), (void *)toptencmp );
	tfile = open( "topten",  O_CREAT|O_RDWR, S_IRGRP |  S_IWGRP | S_IRUSR | S_IWUSR );
	write( tfile, &Topten, sizeof(Topten));
	close( tfile );
}

//--------------------------------------------------------------------------------
// show the  top ten score list
//--------------------------------------------------------------------------------
void toptenshow( SDL_Surface *Screen ) 
{
	int i;
	char scorestr[ TOPSCOREMAXLEN ] = "";
	RECT screct = {0,0,SCREENWIDTH,SCREENHEIGHT};

	SDL_SetClipRect( Screen, &screct );
	loadbmp( Screen, "bmp/frame.bmp" );

	for ( i = 0; i < TENSIZE; i++ )
	{
		if ( Topten[ i ].good == 0 )
			continue;
		sprintf( scorestr, "%-9s %3d %3d %4d", Topten[ i ].name, Topten[ i ].dead, Topten[ i ].good, Topten[ i ].ticks );
		textxy( Screen, FRAMELEFT, (i * ( LEADING +  12 )) + 47, scorestr, -1, 1 );
	}
	SDL_Flip( Screen );
}

//--------------------------------------------------------------------------------
// collect a name and add/replace a top ten entry
//--------------------------------------------------------------------------------
int toptentry( SDL_Surface *Screen )
{
	int saved = 0;
	char topscore[ TOPSCOREMAXLEN ];
	SDL_Event event;


	sprintf( topscore, "%-9s", Highscore.name );
	textxy( Screen, 12, 152, topscore, CurrentChar, 1 );
	sprintf( topscore, "%3d %3d %4d", Highscore.dead, Highscore.good, Highscore.ticks );
	textxy( Screen, 91, 152, topscore, -1, 1 );

	textxy( Screen, 44, 190, "JOYSTICK EDITS", -1, 3 );
	textxy( Screen, 34, 206, "A TO SAVE AND EXIT", -1, 3 );
	SDL_Flip( Screen );
	SDL_PollEvent( &event );
	switch( event.type )
	{
#ifdef GP2X
		case SDL_JOYBUTTONDOWN:
			switch(event.jbutton.button)
			{
				case GP2X_BUTTON_UP:
					if ( Highscore.name[ CurrentChar ] < 'A' || Highscore.name[ CurrentChar ] > 'Z' )
						Highscore.name[ CurrentChar ] = 'A';
					else if ( Highscore.name[ CurrentChar ] < 'Z' )
						Highscore.name[ CurrentChar ]++;
					else if ( Highscore.name[ CurrentChar ] == 'Z' )
						Highscore.name[ CurrentChar ] = ' ';
					break;
				case GP2X_BUTTON_DOWN:
					if ( Highscore.name[ CurrentChar ] < 'A' || Highscore.name[ CurrentChar ] > 'Z' )
						Highscore.name[ CurrentChar ] = 'Z';
					else if ( Highscore.name[ CurrentChar ] > 'A' )
						Highscore.name[ CurrentChar ]--;
					else if ( Highscore.name[ CurrentChar ] == 'A' )
						Highscore.name[ CurrentChar ] = ' ';
					break;
				case GP2X_BUTTON_RIGHT:
					if ( CurrentChar < NAMELEN - 1)
					{
						CurrentChar++;
						Highscore.name[ CurrentChar ] = ' ';
					}
					break;
				case GP2X_BUTTON_LEFT:
					if ( CurrentChar > 0 )
					{
						CurrentChar--;
						Highscore.name[ CurrentChar ] = ' ';
					}
					break;
				case GP2X_BUTTON_A:
					toptensave();
					saved = 1;
					break;
				case GP2X_BUTTON_R:
					rdown = 1;
					if ( ldown && rdown )
						saved = -1;
					break;
				case GP2X_BUTTON_L:
					ldown = 1;
					if ( ldown && rdown )
						saved = -1; 
					break;
				case GP2X_BUTTON_VOLUP:
					racketvolume( 2 );
					racketplay( BITE, 0 );
					break;
				case GP2X_BUTTON_VOLDOWN:
					racketvolume( -2 );
					racketplay( BITE, 0 );
					break;
				case GP2X_BUTTON_X:
				case GP2X_BUTTON_B:
				case GP2X_BUTTON_Y:
				case GP2X_BUTTON_SELECT:
				case GP2X_BUTTON_START:
				case GP2X_BUTTON_CLICK:
					break;
				default:
					break;
			}
			break;

		case SDL_JOYBUTTONUP:
			switch(event.jbutton.button)
			{
				case GP2X_BUTTON_A:
				case GP2X_BUTTON_X:
				case GP2X_BUTTON_B:
				case GP2X_BUTTON_Y:
					break;
				case GP2X_BUTTON_L:
					ldown=0;
					break;
				case GP2X_BUTTON_R:
					rdown=0;
				default:
					break;
			}
			break;
#else
		case SDL_KEYDOWN:
			switch( event.key.keysym.sym )
			{
				case SDLK_a:
					toptensave();
					saved++;
					break;
				case SDLK_F6:
					racketvolume( -2 );
					racketplay( BITE, 0 );
					break;
				case SDLK_F7:
					racketvolume( 2 );
					racketplay( BITE, 0 );
					break;
				case SDLK_r:
					break;
				case SDLK_UP:
					if ( Highscore.name[ CurrentChar ] < 'A' || Highscore.name[ CurrentChar ] > 'Z' )
						Highscore.name[ CurrentChar ] = 'A';
					else if ( Highscore.name[ CurrentChar ] < 'Z' )
						Highscore.name[ CurrentChar ]++;
					else if ( Highscore.name[ CurrentChar ] == 'Z' )
						Highscore.name[ CurrentChar ] = ' ';
					break;
				case SDLK_DOWN:
					if ( Highscore.name[ CurrentChar ] < 'A' || Highscore.name[ CurrentChar ] > 'Z' )
						Highscore.name[ CurrentChar ] = 'Z';
					else if ( Highscore.name[ CurrentChar ] > 'A' )
						Highscore.name[ CurrentChar ]--;
					else if ( Highscore.name[ CurrentChar ] == 'A' )
						Highscore.name[ CurrentChar ] = ' ';
					break;
				case SDLK_LEFT:
					if ( CurrentChar > 0 )
					{
						CurrentChar--;
						Highscore.name[ CurrentChar ] = ' ';
					}
					break;
				case SDLK_RIGHT:
					if ( CurrentChar < NAMELEN - 2)
					{
						CurrentChar++;
						Highscore.name[ CurrentChar ] = ' ';
					}
				default:
					break;
			}
#endif
		default:
			break;
	}
	return( saved );
}

//--------------------------------------------------------------------------------
// how fast was he going
//--------------------------------------------------------------------------------
void toptenstoptheclock( void )
{
	Highscore.good = guy.topscore;
	Highscore.dead = guy.deadfish;
	guy.topscore = Highscore.good - ( Highscore.dead ? Highscore.dead / 4 : 1 );
	Highscore.ticks = guy.score;
}

//--------------------------------------------------------------------------------
// eof
//--------------------------------------------------------------------------------
