//----------------------------------------------------------------------------
//  The Reusable Top Ten Score List By Linus Sphinx (c)Copyright 2005 all rights reserved
//----------------------------------------------------------------------------
//
//    This file is part of Linus Sphinx's Reusable Top Ten Score List 
//
//    Reusable Top Ten Score List  is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 3 of the License, or
//    (at your option) any later version.
//
//    Reusable Top Ten Score List  is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Reusable Top Ten Score List ; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//--------------------------------------------------------------------------------
//
//--------------------------------------------------------------------------------
// top ten score file support
//--------------------------------------------------------------------------------

#define NAMELEN 9 // number of characters to collect + 1
#define TENSIZE 10 // number of player scores to keep
#define TENSTRLEN 27 // max length to fit in frame  0123456789 00:00:00 000
#define FRAMELEFT 54 // left side of frame
#define TOPSCOREMAXLEN 26 // maximum characters that fit in the frame view
#define TOPSCOREMIN 100
#define TOPSCOREFRAME "bmp/topten2.bmp"

typedef struct
{
	char name[ NAMELEN + 1];
	short good;
	short dead;
	short ticks;
} TOPTEN;

// prototypes
void toptenload(void);
void toptensave(void);
void toptenshow( SDL_Surface * );
int toptentry( SDL_Surface *);
void toptenstoptheclock();
short topteneligible( SDL_Surface * );
//--------------------------------------------------------------------------------
// eof
//--------------------------------------------------------------------------------

