//----------------------------------------------------------------------------
//  Reusable Game Utilitiy Routines By Linus Sphinx (c)Copyright 2007 all rights reserved
//----------------------------------------------------------------------------
//
//    Reusable Game Utility Routines is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 3 of the License, or
//    (at your option) any later version.
//
//    Reusable Game Utility Routines is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with This; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//--------------------------------------------------------------------------------
// miscellaneous utility functions 
//--------------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <SDL.h>
#include <SDL_mixer.h>
#include "fish.h"
#include "util.h"
#include "text.h"
#include "racket.h"

extern OPTIONS Option;
unsigned long Now;

//----------------------------------------------------------------
// int nextCommand( char *instr, char *outstr, char *place )
//      find and retrieve a command string from instr starting at place
//      strip cr/lf/comments, add a terminating comma and a null
// input:
//      char *instr - compound string full of comments
//      char *outstr - null terminated command string a-z:#,#,#,\0
// returns:
//      0 - success
//      !0 - failure
//----------------------------------------------------------------
int nextCommand( char *place, char *outstr )
{
   char *x = place;
   char *y = outstr;
   int found = 0; // increment if command found
        
    while( *x++ && !found ) // find start of a command
    {
        if ( *x == ':' )
        {
            --x;
            if ( strchr( "01234567icsqfp#", (int)*x ) != NULL ) // got one
            {
                found++;
                while( *x && strchr( " \t\r\n\\", (int)*x ) == NULL )  // fill output
                    *y++ = *x++;
                *y++ = '\0';
            }
            else
                while( *x != '\n' )  // skip it
                    x++;
        }
    }
    return found;
}//eo nextCommand

//---------------------------------------------------------------------------
// void loadbmp( SDL_Surface* s, char* f)
// 		given s Screen and f filename loads a bitmap and installs its palette
//----------------------------------------------------------------------------
void loadbmp( SDL_Surface *surface, char *fname )
{
	SDL_Surface *image = NULL;

	image = SDL_LoadBMP( fname );

	if (image == NULL)
	{
		fprintf(stderr, "Error loading %s: %s\n", fname, SDL_GetError());
		exit( 0 );
	}

	if (image->format->palette && surface->format->palette)
	{
		SDL_SetColors(surface, image->format->palette->colors, 0, image->format->palette->ncolors);
	}

	if ( SDL_BlitSurface(image, NULL, surface, NULL) < 0 )
		fprintf(stderr, "BlitSurface error: %s\n", SDL_GetError());

	// SDL_UpdateRect(surface, 0, 0, image->w, image->h);
	SDL_UpdateRect(surface, 0, 0, 0, 0);
	SDL_FreeSurface(image);
}// eo loadbmp

//-----------------------------------------------------------------
// void paintscreen( SDL_Surface surface, short color )
// 		flood screen with a given color
//-----------------------------------------------------------------
void paintscreen( SDL_Surface *Screen, short color )
{
	SDL_FillRect( Screen, NULL, color );
	SDL_UpdateRect( Screen, 0, 0, 0, 0 );
	return;
}// eo paintscreen

//----------------------------------------------------------------
// timeleft to take in the scenery
//----------------------------------------------------------------

unsigned int timeleft(unsigned int x)
{
		static unsigned int next_time = 0;

		Now = SDL_GetTicks();
		if ( next_time <= Now ) {
			next_time = Now + x;
		return(0);
	}
	return(next_time-Now);
}

//----------------------------------------------------------------
// short SDL_BlitFlop(SDL_Surface *, RECT *, SDL_Surface *, RECT * )
// 		mirrors right to left blit one vertical stripe at a time
//----------------------------------------------------------------

short SDL_BlitFlop(SDL_Surface *Source, RECT *trect, SDL_Surface *Dest, RECT *drect )
{
	RECT sslice, dslice;
	short i, ret = 0;

	sslice.y = trect->y;
	sslice.h = trect->h;
	sslice.w = 1;
	dslice.y = drect->y;
	dslice.h = trect->h;
	dslice.w = 1;

	i = trect->w - 1;

	while( i >= 0 && !ret )
	{
		sslice.x = trect->x + i;
		dslice.x = drect->x + trect->w - i;
		// printf("0 sx:%d-dx:%d\n", sslice.x, dslice.x );
		ret = SDL_BlitSurface( Source, &sslice, Dest, &dslice );
		--i;
	}
	return ret;
}

//----------------------------------------------------------------
// void clip( RECT *d, RECT *t ) 
// 		prune t for placement at d if d.x or d.y and adjust if negative else do nothing
// 		return true if clipped results are nonsense
//----------------------------------------------------------------
short clip( RECT *d, RECT *t )
{
	int dify = 0; // , difx = 0;  
	if ( d->y < 0 )
	{
		dify = abs( d->y );
		// printf( "b - dify:%d ty:%d th:%d\n", dify, t->y, t->h );
		t->y += dify;
		if ( dify < t->h )
			t->h -= dify;
		else 
			dify = -1;
		d->y = 0;
		// printf( "a - dif:%d ty:%d th:%d\n", dify, t->y, t->h );
	}

	return (dify < 0)?-1:0;
}

//-----------------------------------------------------------------
// short xyinrect( POINT *pt RECT *rect )
//      return true if pt is within rect
//-----------------------------------------------------------------
short xyinrect( short x, short y, RECT *rect )
{
	if ( x > rect->x && x < rect->w && y > rect->y && y < rect->h )
	{
		//fprintf( stderr, "x:%d y:%d rx:%d ry:%d rw:%d rh%d\n", x, y, rect->x, rect->y, rect->w, rect->h);
		return( 1 );
	}
	return( 0 );
} //eo xyinrect

//-----------------------------------------------------------------
// short intersectrect( RECT *me, RECT *ze )
//      return true if rect is within rect
//-----------------------------------------------------------------
short intersectrect( RECT *me, RECT *ze )
{
	short ret = 0;
	if (( me->w >= ze->x && me->w <= ze->w )&&( me->h >= ze->y && me->h <= ze->h ))
		ret++;
	else if (( me->x >= ze->x && me->x <= ze->w )&&( me->h >= ze->y && me->h <= ze->h ))
		ret++;
	else if (( me->y >= ze->y && me->y <= ze->h )&&( me->w >= ze->x && me->w <= ze->w ))
		ret++;
	else if (( me->x >= ze->x && me->x <= ze->w )&&( me->y >= ze->y && me->y <= ze->h ))
		ret++;
	return( ret );
}
//----------------------------------------------------------------
// int dragon( float ) - random number dragon, pass range max returns random number
//----------------------------------------------------------------
int dragon( float x )
{
	return( 1 + (int) ( x * (rand() / (RAND_MAX + 1.0))));
}

//----------------------------------------------------------------
// eof
//----------------------------------------------------------------
