/*
* Cam2X - Simple Test Program with SDL
*
* by Lithosphere
*/
#include <stdio.h>
#include <SDL.h>
#include <string.h>

#include <cam2x.h>

void UpdateScreen(Cam2X_Device* cam2x);

SDL_Surface* screen;
Cam2X_Device* cam2x;

#define WINDOW_WIDTH	320
#define WINDOW_HEIGHT	240
#define	WINDOW_DEPTH	32

int main(int argc, char **argv)
{
	SDL_Init(SDL_INIT_JOYSTICK | SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_TIMER);			// Initialize SDL
	
	screen = SDL_SetVideoMode( WINDOW_WIDTH, WINDOW_HEIGHT, WINDOW_DEPTH, SDL_SWSURFACE);	// Set up screen for gp2x
	if(!screen)
		return printf("SDL_SetVideoMode screen not initialised.\n");						// debug output example for serial cable

	SDL_ShowCursor(SDL_DISABLE);	// Disable mouse cursor on gp2x

	SDL_JoystickOpen(0);			// Initialize the joystick

	/* Open camera device */
	cam2x = Cam2X_OpenCamera();
	
	if(cam2x) {
		int i = 0;
		/* Fetch 30 frames */
		for(i=0;i<30;i++){
			printf("Fetching image %d\n",i);
			UpdateScreen(cam2x);
		}
		
		/* Close camera device */
		Cam2X_CloseCamera(cam2x);
	}
	
	SDL_FreeSurface(screen);																// Release the memory allocated to screen
	SDL_Quit();

	return 0;
	
}

void UpdateScreen(Cam2X_Device* cam2x){
	unsigned int *ptr = (unsigned int*)screen->pixels;
	unsigned char *src = cam2x->buffer;
	unsigned int scanline = screen->pitch/(WINDOW_DEPTH/8);
	
	Cam2X_GetNewFrame(cam2x);	/* grab new frame */
	Cam2X_AdjustBrightness(cam2x);	/* recalculate brightness for next capture */

	/* Copy to SDL surface */
	if(WINDOW_DEPTH == 32){
		for(int y=0;y<240;y++){
		  for(int x=0;x<320;x++){  
			  ptr[y*scanline+320-x] = src[0] * 0x10000 + src[1] * 0x100 + src[2];
			  src += 3;
		  }
		}
		
	}else if(WINDOW_DEPTH == 24){
		memcpy(ptr, src, WINDOW_WIDTH * WINDOW_HEIGHT * WINDOW_DEPTH / 8);
	}
	
	SDL_Flip(screen);
}
