#!/usr/bin/env python

#Import Modules
import random
import os, pygame
import sys
import pygame.event
import pygame.joystick
import pygame.display
import pygame.draw
import pygame.time
import decimal

import bmpfont
from bmpfont import *

from decimal import *
getcontext().prec = 2
from pygame.locals import *

import pickle

#functions to create our resources
def load_image(name, colorkey=None, filespriteX1=0, filespriteY1=0, filespriteX2=0, filespriteY2=0):

    if name == "sprites1.bmp":
        image = spritesheet
    elif name == "stars.bmp":
        image = backgroundsheet
    else:
        fullname = os.path.join('data', name)
        try:
            image = pygame.image.load(fullname)
        except pygame.error, message:
            print 'Cannot load image:', fullname
            raise SystemExit, message

    if filespriteX1==0 and filespriteY1==0 and filespriteX2==0 and filespriteY2==0:
        image = image.convert()
    else:
        image = image.subsurface(pygame.Rect(filespriteX1, filespriteY1, filespriteX2-filespriteX1, filespriteY2-filespriteY1))
        image = image.convert()

    if colorkey is not None:
        if colorkey is -1:
            colorkey = image.get_at((0,0))
        image.set_colorkey(colorkey, RLEACCEL)


    return image, image.get_rect()

def load_sound(name):
    class NoneSound:
        def play(self): pass

#    if not pygame.mixer or not pygame.mixer.get_init() or True:
    return NoneSound()

    fullname = os.path.join('data', name)
    try:
        sound = pygame.mixer.Sound(fullname)
    except pygame.error, message:
        print 'Cannot load sound:', fullname
        raise SystemExit, message
    return sound


class animatedSprite(pygame.sprite.Sprite):
    def __init__(self, animatedspritelist):
        pygame.sprite.Sprite.__init__(self)
	self.image, self.rect = animatedspritelist[0]
        self.image_list = animatedspritelist
        self.animationcounter = 0 + random.randint(1,99)
        self.currentframe = 0
        self.animationspeed = 100

    def update(self):
        self.animationcounter += dt

        if self.animationcounter >= self.animationspeed/gamespeed:
            self.animationcounter = 0
            if self.currentframe == len(self.image_list) - 1:
                self.image = self.image_list[0][0]
                self.currentframe = 0
            else:
                self.image = self.image_list[self.currentframe + 1][0]
                self.currentframe += 1

# GP2X joystick button mappings
BUTTON_UP            = (0)
BUTTON_DOWN          = (4)
BUTTON_LEFT          = (2)
BUTTON_RIGHT         = (6)
BUTTON_UPLEFT        = (1)
BUTTON_UPRIGHT       = (7)
BUTTON_DOWNLEFT      = (3)
BUTTON_DOWNRIGHT     = (5)
BUTTON_CLICK         = (18)
BUTTON_A             = (12)
BUTTON_B             = (13)
BUTTON_X             = (14)
BUTTON_Y             = (15)
BUTTON_L             = (10)
BUTTON_R             = (11)
BUTTON_START         = (8)
BUTTON_SELECT        = (9)
BUTTON_VOLUP         = (16)
BUTTON_VOLDOWN       = (17)

class Ship(animatedSprite):
    """This class is for the players ship"""
    def __init__(self, pos = (160, 120), movable = True):
        animatedSprite.__init__(self, [load_image('sprites1.bmp', -1, 5, 179, 20, 199), load_image('sprites1.bmp', -1, 5, 154, 20, 174)]) #call Sprite intializer
        pygame.sprite.Sprite.__init__(self)
        self.rect.center = pos
        self.x_velocity = 0
        self.y_velocity = 0
        self.animationspeed = 50
        self.missiles = 10
        self.firetype = 0
        if not movable:
            self.update = self.animate
        else:
            self.update = self.update_normal
        self.firecounter = 0
        self.firerate = 50
        
    def update_normal(self):
        if pygame.joystick.get_count() >= 1: # if we have inited a joystick

            global running
            
            if not stick.get_button(BUTTON_RIGHT) and not self.x_velocity <= 0: self.x_velocity -= 0.2
            if not stick.get_button(BUTTON_LEFT) and not self.x_velocity >= 0: self.x_velocity += 0.2
            if not stick.get_button(BUTTON_UP) and not self.y_velocity >= 0: self.y_velocity += 0.2
            if not stick.get_button(BUTTON_DOWN) and not self.y_velocity <= 0: self.y_velocity -= 0.2

            if not stick.get_button(BUTTON_UPRIGHT):# and not self.x_velocity <= 0:
                self.x_velocity -= 0.1
                self.y_velocity += 0.1
            if not stick.get_button(BUTTON_UPLEFT):# and not self.x_velocity >= 0: 
                self.x_velocity += 0.1
                self.y_velocity += 0.1
            if not stick.get_button(BUTTON_DOWNRIGHT):# and not self.y_velocity >= 0:
                self.x_velocity -= 0.1
                self.y_velocity -= 0.1
            if not stick.get_button(BUTTON_DOWNLEFT):# and not self.y_velocity <= 0: 
                self.x_velocity += 0.1
                self.y_velocity -= 0.1
            
            if stick.get_button(BUTTON_RIGHT) and not self.x_velocity >= 2: self.x_velocity += 0.5
            if stick.get_button(BUTTON_LEFT) and not self.x_velocity <= -2: self.x_velocity -= 0.5
            if stick.get_button(BUTTON_UP) and not self.y_velocity <= -2: self.y_velocity -= 0.5
            if stick.get_button(BUTTON_DOWN) and not self.y_velocity >= 2: self.y_velocity += 0.5

            if stick.get_button(BUTTON_UPRIGHT):# and not self.x_velocity >= 2: 
                self.x_velocity += 0.3
                self.y_velocity -= 0.3
            if stick.get_button(BUTTON_UPLEFT):# and not self.x_velocity <= -2: 
                self.x_velocity -= 0.3
                self.y_velocity -= 0.3
            if stick.get_button(BUTTON_DOWNRIGHT):# and not self.y_velocity <= -2:
                self.x_velocity += 0.3
                self.y_velocity += 0.3
            if stick.get_button(BUTTON_DOWNLEFT):# and not self.y_velocity >= 2: 
                self.x_velocity -= 0.3
                self.y_velocity += 0.3

            for event in pygame.event.get():
                if event.type == JOYBUTTONDOWN:
                    if event.button == BUTTON_B:
                        self.fire()
                    elif event.button == BUTTON_Y:
                        if self.missiles > 0:
                            self.fire(-1)
                            self.missiles -= 1
                    elif event.button == BUTTON_START:
                        running = 0

        else:
            keys = pygame.key.get_pressed()
            
            if not keys[K_RIGHT] and not self.x_velocity <= 0: self.x_velocity -= 0.2
            if not keys[K_LEFT] and not self.x_velocity >= 0: self.x_velocity += 0.2
            if not keys[K_UP] and not self.y_velocity >= 0: self.y_velocity += 0.2
            if not keys[K_DOWN] and not self.y_velocity <= 0: self.y_velocity -= 0.2
            
            if keys[K_RIGHT] and not self.x_velocity >= 2: self.x_velocity += 0.5
            if keys[K_LEFT] and not self.x_velocity <= -2: self.x_velocity -= 0.5
            if keys[K_UP] and not self.y_velocity <= -2: self.y_velocity -= 0.5
            if keys[K_DOWN] and not self.y_velocity >= 2: self.y_velocity += 0.5
            
            for event in pygame.event.get():
                if event.type == KEYDOWN:
                    if event.key == K_SPACE:
                        self.fire()
                    if event.key == K_m:
                        self.fire(-1)


        pygame.event.pump()
        
        self.animate()



    def animate(self):
        animatedSprite.update(self)

        self.rect.move_ip((self.x_velocity*0.2*gamespeed*dt, self.y_velocity*0.2*gamespeed*dt))

        if self.rect.left < 0:
            self.rect.left = 0
        elif self.rect.right > 320:
            self.rect.right = 320

        if self.rect.top <= 0:
            self.rect.top = 0
        elif self.rect.bottom >= 240:
            self.rect.bottom = 240

    def fire(self, firetype = None):
        self.firecounter -= dt
        if self.firecounter <= 0:
            if firetype == None: firetype = self.firetype
            if firetype == 0:
                bomb_sprites.add(bomb(self.rect.midtop))
                shot2.play()
            elif firetype == -1:
                bomb_sprites.add(homingmissile(self.rect.midtop))
                shot2.play()
            elif firetype == 2 or firetype == 1:
                bomb_sprites.add(bomb(self.rect.midright))
                bomb_sprites.add(bomb(self.rect.midleft))
                shot2.play()
            elif firetype == 3:
                bomb_sprites.add(bomb(self.rect.midright))
                bomb_sprites.add(bomb(self.rect.midtop))
                bomb_sprites.add(bomb(self.rect.midleft))
                shot2.play()
            elif firetype == 4:
                bomb_sprites.add(bomb(self.rect.midright, 0.5))
                bomb_sprites.add(bomb(self.rect.midtop))
                bomb_sprites.add(bomb(self.rect.midleft, -0.5))
                shot2.play()
            else:
                bomb_sprites.add(bomb(self.rect.midright, 1))
                bomb_sprites.add(bomb(self.rect.midright, 0.5))
                bomb_sprites.add(bomb(self.rect.midright, 0))
                bomb_sprites.add(bomb(self.rect.midtop))
                bomb_sprites.add(bomb(self.rect.midleft, 0))
                bomb_sprites.add(bomb(self.rect.midleft, -1))
                bomb_sprites.add(bomb(self.rect.midleft, -0.5))
            self.firecounter = self.firerate
            
class Pickup(animatedSprite):
    def __init__(self, coords):
        animatedSprite.__init__(self, (load_image('sprites1.bmp', -1, 34, 254, 45, 263),load_image('sprites1.bmp', -1, 34, 279, 45, 288)))
        self.rect.center = coords
        self.x_velocity = 0
        self.y_velocity = 0.1
        self.x_direction = 0
        self.y_direction = -1

        self.animationspeed = 200

    def update(self):
        animatedSprite.update(self)

        self.rect.move_ip(self.x_velocity*dt*gamespeed, self.y_velocity*dt*gamespeed)
        
        
class homingmissile(animatedSprite):
    def __init__(self,coords, homing = True):
        animatedSprite.__init__(self,(load_image('sprites1.bmp', -1, 7, 355, 19, 364),load_image('sprites1.bmp', -1, 7, 381, 19, 390),load_image('sprites1.bmp', -1, 7, 404, 19, 413),load_image('sprites1.bmp', -1, 7, 431, 19, 440),))
        self.rect.center = coords
        self.x_velocity = 7
        self.y_velocity = 7
        self.x_direction = 0
        self.y_direction = -1

        self.animationspeed = 20

        self.timer = 0

        self.x_distance = 0.0
        self.y_distance = 0.0
        self.totaldistance = 0

        self.target = None

        self.home = homing

        if self.home:
        
            if not (len(enemyship_sprites) <= 1):
                self.target = enemyship_sprites.sprites()[random.randint(0,len(enemyship_sprites)-1)] # pick a random target
            if not self.target == None:
                for enemy in enemyship_sprites: # try to improve on it
                    if ((enemy.rect.centerx - self.rect.centerx)**2 + (enemy.rect.centery - self.rect.centerx)**2) < ((self.target.rect.centerx - self.rect.centerx)**2 + (self.target.rect.centery - self.rect.centery)**2):
                        self.target = enemy

            else:
                bomb_sprites.remove(self)
                explosion_sprites.add(Explosion(self.rect.centerx, self.rect.centery))

    def update(self):
        animatedSprite.update(self)
        if self.home:
            if (self.rect.centerx <= -50 or self.rect.centerx >= 370) or (self.rect.centery <= -50 or self.rect.centery >= 290):
                bomb_sprites.remove(self)

            if (self.target not in enemyship_sprites) and not (len(enemyship_sprites) <= 1):
                self.target = enemyship_sprites.sprites()[random.randint(0,len(enemyship_sprites)-1)]
            elif len(enemyship_sprites) <= 1:
                bomb_sprites.remove(self)
                explosion_sprites.add(Explosion(self.rect.centerx, self.rect.centery))
            if self.target != None:
                self.x_distance = self.target.rect.centerx - self.rect.centerx
                self.y_distance = self.target.rect.centery - self.rect.centery

                self.totaldistance = (self.x_distance**2 + self.y_distance**2)**1/2

                if self.totaldistance != 0:

                    self.rect.move_ip(((self.x_distance*self.x_velocity*dt)/self.totaldistance, (self.y_distance*self.y_velocity*dt)/self.totaldistance))
                    
class Enemy(animatedSprite):
    """This class is for the enemy ships"""
    def __init__(self, startx = 20, starty = 20, spritelist = -1, pattern = 2, direction = 0):
        if spritelist == -1:
            spritelist = load_image('sprites1.bmp', -1, 5, 55, 20, 70) , load_image('sprites1.bmp', -1, 5, 80, 20, 95)
        animatedSprite.__init__(self, spritelist) #call Sprite intializer
        pygame.sprite.Sprite.__init__(self)

        self.rect.centerx = startx
        self.rect.centery = starty

        self.x_velocity = 0.1
        self.y_velocity = 0.1
        self.firecounter = 0 + random.randint(1,999)
        self.animationcounter = 0 + random.randint(1,99)
        self.currentframe = 0
        self.x_direction = 1
        self.y_direction = 1
        if pattern == 1:
            self.move = self.move_invade
        elif pattern == 2:
            self.move = self.move_down
        elif pattern == 3:
            self.rect.centerx = direction * 300 + 10
            self.set_x_direction(0.5 - direction)
            self.set_y_direction(0.5)
            self.move = self.move_zig
        elif pattern == 4:
            self.set_x_direction(1 - 2*direction)
            self.set_y_direction(8)
            self.move = self.move_sweep

    def update(self):
        self.rect.move_ip((round(self.x_velocity*self.x_direction*gamespeed*dt), round(self.y_velocity*self.y_direction*gamespeed*dt)))

        self.animationcounter += dt

        if self.animationcounter >= 100/gamespeed:
            self.animationcounter =0
            if self.currentframe == 0:
                self.image = self.image_list[1][0]
                self.currentframe = 1
            else:
                self.image = self.image_list[0][0]
                self.currentframe = 0

        self.firecounter += dt
        if self.firecounter >= 1000/gamespeed:
            ebomb_sprites.add(Ebomb(self.rect.midtop))
            shot1.play()
            self.firecounter = 0

    def do_move(self, xvel, yvel):
        self.x_velocity = xvel*gamespeed*dt*0.1
        self.y_velocity = yvel*gamespeed*dt*0.1

    def set_x_direction(self, direction):
        self.x_direction = direction

    def set_y_direction(self, direction):
        self.y_direction = direction

    def move_down(self):

        if self.rect.centery > 250 or self.rect.centerx > 330:
            enemyship_sprites.remove(self)
        self.set_x_direction(0)
        self.set_y_direction(1)

        self.do_move(0.1,0.1)

    def move_invade(self):

        if self.rect.centery > 250 or self.rect.centerx > 330:
            enemyship_sprites.remove(self)

        elif self.rect.centerx <= 30:
            if self.rect.centery > 20 and self.rect.centery <= 40:
                self.set_x_direction(0)
                self.set_y_direction(1)
            if self.rect.centery > 70 and self.rect.centery <= 90:
                self.set_x_direction(1)
                self.set_y_direction(0)
            if self.rect.centery > 130 and self.rect.centery <= 150:
                self.set_x_direction(0)

                self.set_y_direction(1)

        elif self.rect.centerx > 30 and self.rect.centerx < 290:
            if self.rect.centery <= 20:
                self.set_x_direction(0)
                self.set_y_direction(1)
            elif self.rect.centery > 20 and self.rect.centery <= 40:
                self.set_x_direction(-1)
                self.set_y_direction(0)

        elif self.rect.centerx >= 290:
            if self.rect.centery > 70 and self.rect.centery <= 90:
                self.set_x_direction(0)
                self.set_y_direction(1)
            if self.rect.centery > 130 and self.rect.centery <= 150:
                self.set_x_direction(-1)
                self.set_y_direction(0)

        self.do_move(0.1,0.1)

    def move_zig(self):
        if self.rect.centery > 250 or self.rect.centerx > 330:
            enemyship_sprites.remove(self)
        self.do_move(0.1,0.1)

    def move_sweep(self):
        if self.rect.centery > 300 or self.rect.centerx > 400 or self.rect.centery < -100 or self.rect.centerx < -100:
            enemyship_sprites.remove(self)
        self.do_move(0.05, 0.05)
        self.set_y_direction(self.y_direction - 0.008*dt)

class bomb(pygame.sprite.Sprite):
    """This class is for the players weapons"""
    def __init__(self, startpos, x_direction = 0):
        pygame.sprite.Sprite.__init__(self) #call Sprite intializer
        self.image, self.rect = load_image('sprites1.bmp', -1, 11, 255, 14, 262)
        self.rect.center = startpos
        self.vx = x_direction
 
    def update(self):
        if self.rect.bottom <= 0:
            self.kill()
        else:
            self.rect.move_ip((self.vx*0.4*gamespeed*dt, -0.4*gamespeed*dt))

class Ebomb(animatedSprite):
    def __init__(self, startpos):
        animatedSprite.__init__(self,(load_image('sprites1.bmp', -1, 7, 302, 18, 322), load_image('sprites1.bmp', -1, 7, 327, 18, 346)))


        self.rect.midtop = startpos
        self.velocity = 1
        self.animationcounter = 0 +random.randint(1,49)
        self.direction = random.randint (-1,1)

    def update(self):
        if self.rect.bottom >= 480:
            self.kill()
        else:
            self.velocity += dt*0.1
            self.rect.move_ip((self.direction, 0.2*gamespeed*self.velocity))

        self.animationcounter += dt
        if self.animationcounter >= 50/gamespeed:
            self.animationcounter =0
            if self.currentframe == 0:
                self.image = self.image_list[1][0]
                self.currentframe = 1
            else:
                self.image = self.image_list[0][0]
                self.currentframe = 0


class Background(pygame.sprite.Sprite):
    def __init__(self, colorkey, x1, y1, x2, y2, newspeed, xstartpos = 0, ystartpos = 0):
        pygame.sprite.Sprite.__init__(self)
        self.image, self.rect = load_image('stars.bmp', colorkey, x1, y1, x2, y2)
        self.rect.topleft = (xstartpos, ystartpos)
        self.speed = newspeed
        self.posx1 = x1
        self.posy1 = y1
        self.posx2 = x2
        self.posy2 = y2
        self.colourkey = colorkey


    def update(self):
        self.rect.move_ip((0, self.speed*dt*gamespeed))
        if self.rect.top >= 240:
            self.rect.move_ip((0, -480))

class Explosion(animatedSprite):
    def __init__(self, xpos = 150, ypos = 150):
        animatedSprite.__init__(self,[ load_image('sprites1.bmp',-1, 25, 0, 50, 25), load_image('sprites1.bmp',-1, 25, 25, 50, 50), load_image('sprites1.bmp',-1, 25, 50, 50, 75), load_image('sprites1.bmp',-1, 25, 75, 50, 100)])
        pygame.sprite.Sprite.__init__(self)
        self.rect.center = (xpos, ypos)
        self.animationspeed = 50

    def update(self):
        self.animationcounter += dt
        self.rect.move_ip((0, 0.2*gamespeed*dt))
        if self.animationcounter >= self.animationspeed/gamespeed:
            self.animationcounter = 0
            if self.currentframe == len(self.image_list) - 1:
                explosion_sprites.remove(self)
            else:
                self.image = self.image_list[self.currentframe + 1][0]
                self.currentframe += 1

class extended_group(pygame.sprite.AbstractGroup):
    rect = pygame.Rect(0,0,0,0)
    x_velocity = 0
    y_velocity = 0
    def __init__(self):
        pygame.sprite.AbstractGroup.__init__(self)
        self.rect = pygame.Rect(0,0,0,0)
        self.x_velocity = 0.1
        self.y_velocity = 0.1

    def add(self, sprite):

        if self.__len__() != 0: # are there any sprites in the group?
            #does this sprite fall outside of the current rect?
            if sprite.rect.left < self.rect.left:
                self.rect = pygame.Rect(sprite.rect.left, self.rect.top, self.rect.width, self.rect.height)
            if sprite.rect.right > self.rect.right:
                self.rect = pygame.Rect(self.rect.left, self.rect.top, sprite.rect.width, self.rect.height)
            if sprite.rect.top < self.rect.top:
                self.rect = pygame.Rect(self.rect.left, sprite.rect.top, self.rect.right, self.rect.height)
            if sprite.rect.bottom > self.rect.bottom:
                self.rect = pygame.Rect(self.rect.left, self.rect.top, self.rect.right, sprite.rect.height)
        else: # then this is the first sprite to be added
            self.rect = sprite.rect
        pygame.sprite.AbstractGroup.add(self, sprite)

    def move(self): #the default movement function
        for s in self.sprites():
            s.move()


def clear_callback(surf, rect):
    color = 0, 0, 0
    surf.fill(color, rect)


class Splash:
    pass

random.seed()
pygame.init()
screen = pygame.display.set_mode((320, 240))
pygame.display.set_caption('AlienZ!')
pygame.mouse.set_visible(False)

splash = Splash()
splash.image, splash.rect = load_image("splash.bmp")
screen.blit(splash.image, splash.rect)
pygame.display.update()
pygame.time.delay(500)


splash2 = Splash()
splash2.image, splash2.rect = load_image("splash2.bmp")
screen.blit(splash2.image, splash2.rect)
pygame.time.delay(500)
pygame.display.update()

num_joysticks = pygame.joystick.get_count()
print "checking for a joystick .. "
if num_joysticks > 0:
    stick = pygame.joystick.Joystick(0)
    stick.init() # now we will receive events for the joystick
    print " .. found!"
else:
    print "Joystick not found. Assuming keyboard input."

try:
#    marker2.image = pygame.image.load(os.path.join('data',"marker.bmp"))
#    marker2.rect = marker2.image.get_rect()
    explosion = pygame.image.load(os.path.join('data',"explosion.bmp"))
    spritesheet = pygame.image.load(os.path.join('data', "sprites1.bmp"))
    backgroundsheet = pygame.image.load(os.path.join('data', "stars.bmp"))
except pygame.error, message:
    raise SystemExit, message

backgrounds = pygame.sprite.RenderClear()
backgrounds.add(Background(-1, 0, 0, 320, 240, 0.2))
backgrounds.add(Background(-1, 320, 0, 640, 240, 0.25))
backgrounds.add(Background(-1, 0, 240, 320, 480, 0.2, 0, -240))
backgrounds.add(Background(-1, 320, 240, 640, 480, 0.25 , 0, -240))

hudsprite = pygame.sprite.Sprite()
hudsprite.image, hudsprite.rect = load_image("hud.bmp")
hudsprite.image.set_colorkey(pygame.Color("magenta"))
hud = pygame.sprite.Group(hudsprite)

backgrounds.draw(screen)

pickup_sprites = pygame.sprite.RenderClear()

health_sprites = pygame.sprite.OrderedUpdates()
health_sprites_list = []
    
#Load music
explode1 = load_sound("explode1.wav")
explode2 = load_sound("explode2.wav")
shot1 = load_sound("silent.wav")
shot2 = load_sound("fx.wav")

#Prepare the game objects
score = 0
bonus = 0
totalscore = 0

clock = pygame.time.Clock()
clock.tick()
dt = clock.get_time()

time = 0

gamespeed = 0.5

running = True
counter = 0

numberof_hits = 0

smallfont = BmpFont()

marker2 = Splash()
marker2.image, marker2.rect = load_image("marker.bmp", -1)

mode = 0
ship = Ship((160, 215), False)
playership_sprite = pygame.sprite.RenderClear(ship)

class Menu:
    def __init__(self, newitems, newname, newactions):
        self.items = newitems
        self.name = newname
        self.actions = newactions
        self.marker = 0
        self.font = BmpFont()
        self.image = pygame.Surface((320, 240))
        self.image.fill(pygame.Color("magenta"))
        self.image.set_colorkey(pygame.Color("magenta"))
        self.font.blit(self.name, self.image, (75,50), False)
        i = 0
        for item in self.items:
            if item != None:
                self.font.blit(item, self.image, (100,75+15*i), False)
            i += 1
    def draw(self, screen):
        screen.blit(self.image, self.image.get_rect())
        marker_rect = marker2.rect
        marker_rect.x = 85
        marker_rect.y = 75+15*self.marker
        screen.blit(marker2.image, marker_rect)
    def move(self, direction):
        try:
            while not (self.marker < 0) and not (self.marker > 10):
                if not (self.marker+direction >= len(self.items)) and not (self.marker+direction < 0):
                    self.marker += direction
                    if self.items[self.marker] == None:
                        continue
                    else:
                        return
                else:
                    return
        except IndexError:
            return

    def click(self):
        return self.actions[self.marker]()

def init_game():
    global numberof_hits, ship, playership_sprite, bomb_sprites, enemyship_sprites
    global ebomb_sprites, explosion_sprites, ship, pickup_sprites, health_sprites
    global running, mode, score, counter, bonus, totalscore, time, health_sprites_list

    playership_sprite.remove(ship)
    ship = Ship()
    playership_sprite.add(ship)

    bomb_sprites = pygame.sprite.RenderClear()
    enemyship_sprites = extended_group()
    
    ebomb_sprites = pygame.sprite.RenderClear()

    health_sprites_list = []

    for i in xrange(5):
        health_sprites_list.append(Ship((300, 150 + 17 * i), False))

    health_sprites = pygame.sprite.OrderedUpdates(health_sprites_list)
    
    explosion_sprites = pygame.sprite.RenderClear()

    hud.add(homingmissile((17, 225), False))

    pickup_sprites = pygame.sprite.RenderClear()

    running = True

    numberof_hits = score = mode = counter = bonus = totalscore = time = 0

    return 1

def help_callback():
    helprunning = True
    text = pygame.Surface((320, 240))
    text.fill(pygame.Color("magenta"))
    text.set_colorkey(pygame.Color("magenta"))

    smallfont.blit(         "In this game, you have to defeat  "     , text, (10,25+11*1), False)
    smallfont.blit(         "the alien hordes in an ever-      "     , text, (10,25+11*2), False)
    smallfont.blit(         "increasingly difficult            "     , text, (10,25+11*3), False)
    smallfont.blit(         "shoot-em-up.                      "     , text, (10,25+11*4), False)
    smallfont.blit(         "Press B to shoot and Y to fire a  "     , text, (10,25+11*5), False)
    smallfont.blit(         "magnetic bomb, of which you have a"     , text, (10,25+11*6), False)
    smallfont.blit(         "limited amount.                   "     , text, (10,25+11*7), False)
    smallfont.blit(         "Collect pickups to increase the   "    , text, (10,25+11*8), False)
    smallfont.blit(         "power of your weapons or the      "     , text, (10,25+11*9), False)
    smallfont.blit(         "number of bombs you have. After   "    , text, (10,25+11*10), False)
    smallfont.blit(         "you are hit five times, the game  "     , text, (10,25+11*11), False)
    smallfont.blit(         "is over.                          "     , text, (10,25+11*12), False)
    
    while helprunning:
        backgrounds.clear(screen, clear_callback)
        backgrounds.update()
        backgrounds.draw(screen)
        playership_sprite.clear(screen, clear_callback)
        playership_sprite.update()
        playership_sprite.draw(screen)

        screen.blit(text, text.get_rect())

        dt = clock.tick(30)

        pygame.display.flip()
        for event in pygame.event.get():
            if event.type == JOYBUTTONDOWN or event.type == KEYDOWN:
                helprunning = False


    helprunning = True
    text = pygame.Surface((320, 240))
    text.fill(pygame.Color("magenta"))
    text.set_colorkey(pygame.Color("magenta"))

    smallfont.blit(         "The game is clocked to 240MHz by  "     , text, (10,25+11*1), False)
    smallfont.blit(         "default as it is not very         "     , text, (10,25+11*2), False)
    smallfont.blit(         "optimised for speed. However, it  "     , text, (10,25+11*3), False)
    smallfont.blit(         "still fairly playable at 200MHz,  "     , text, (10,25+11*4), False)
    smallfont.blit(         "so you might want to try that.    "     , text, (10,25+11*5), False)
    smallfont.blit(         "A couple of tips: Tapping the     "     , text, (10,25+11*6), False)
    smallfont.blit(         "controls rather than holding them "     , text, (10,25+11*7), False)
    smallfont.blit(         "down will usually give you better "    , text, (10,25+11*8), False)
    smallfont.blit(         "control. Also, the bombs may self-"     , text, (10,25+11*9), False)
    smallfont.blit(         "destruct if they cannot find a    "    , text, (10,25+11*10), False)
    smallfont.blit(         "suitable target.                  "     , text, (10,25+11*11), False)
    
    smallfont.blit(         "Good luck!                        "     , text, (10,25+11*13), False)
    while helprunning:
        backgrounds.clear(screen, clear_callback)
        backgrounds.update()
        backgrounds.draw(screen)
        playership_sprite.clear(screen, clear_callback)
        playership_sprite.update()
        playership_sprite.draw(screen)

        screen.blit(text, text.get_rect())

        dt = clock.tick(30)

        pygame.display.flip()
        for event in pygame.event.get():
            if event.type == JOYBUTTONDOWN or event.type == KEYDOWN:
                helprunning = False
    return 0

def credits_callback():
    creditsrunning = True
    text = pygame.Surface((320, 240))
    text.fill(pygame.Color("magenta"))
    text.set_colorkey(pygame.Color("magenta"))
    smallfont.blit(         "Thanks to RSPV4GP2X, for an intro "     , text, (10,25+11*1), False)
    smallfont.blit(         " to pygame.                       "     , text, (10,25+11*2), False)
    smallfont.blit(         "Thanks to digital-nexus, for the  "     , text, (10,25+11*3), False)
    smallfont.blit(         " GIMP brushes.                    "     , text, (10,25+11*4), False)
    smallfont.blit(         "Thanks to Paul Sidorsky for info  "     , text, (10,25+11*5), False)
    smallfont.blit(         " on BMP fonts.                    "     , text, (10,25+11*6), False)
    smallfont.blit(         "Shoutout to gp2xdev on IRC.       "    , text, (10,25+11*7), False)
    smallfont.blit(         "                                  "     , text, (10,25+11*8), False)
    smallfont.blit(         "Many thanks to Flying Yogi for the"    , text, (10,25+11*9), False)
    smallfont.blit(         " sprites.                         "    , text, (10,25+11*10), False)
    smallfont.blit(         "And a special shoutout to         "    , text, (10,25+11*11), False)
    smallfont.blit(         " donskeeto, because he wanted one."     , text, (10,25+11*12), False)

    smallfont.blit(         "And lastly, a huge thankyou to    "     , text, (10,25+11*14), False)
    smallfont.blit(         " GBAX for this awesome compo.     "     , text, (10,25+11*15), False)  
    
    smallfont.blit(         "Thanks all!                       "     , text, (10,25+11*17), False)
    while creditsrunning:
        backgrounds.clear(screen, clear_callback)
        backgrounds.update()
        backgrounds.draw(screen)
        playership_sprite.clear(screen, clear_callback)
        playership_sprite.update()
        playership_sprite.draw(screen)

        screen.blit(text, text.get_rect())

        dt = clock.tick(30)

        pygame.display.flip()
        for event in pygame.event.get():
            if event.type == JOYBUTTONDOWN or event.type == KEYDOWN:
                creditsrunning = False
    return 0

def exit_callback():
    return -1

def init_menu():
    global ship
    playership_sprite.remove(ship)
    ship = Ship((160, 215), False)
    playership_sprite.add(ship)

    globals()['mainmenu'] = Menu(("New Game", None, "Help", "Credits and Thanks", None, None, "Exit"), "Alienz", (init_game, None, help_callback, credits_callback, None, None, exit_callback))

    update_menu()
    pygame.display.flip()
    pygame.time.delay(750)

def update_menu():
    global backgrounds, playership_sprite, running, mainmenu

    backgrounds.clear(screen, clear_callback)
    backgrounds.update()
    backgrounds.draw(screen)
    playership_sprite.clear(screen, clear_callback)
    playership_sprite.update()
    playership_sprite.draw(screen)

    mainmenu.draw(screen)

def addnewenemies():
    global dt, counter

    counter += dt
    if counter >= 1000*(1/gamespeed):
        pattern = random.randint(1,3) 
        if pattern == 1:
            enemyship_sprites.add(Enemy(startx = -40, starty = -40, spritelist =  (load_image('sprites1.bmp', -1, 5, 55, 21, 68) , load_image('sprites1.bmp', -1, 5, 80, 21, 93)), pattern = 3, direction = 0))
            enemyship_sprites.add(Enemy(startx = -20, starty = -20, spritelist =  (load_image('sprites1.bmp', -1, 5, 55, 21, 68) , load_image('sprites1.bmp', -1, 5, 80, 21, 93)), pattern = 3, direction = 0))
            enemyship_sprites.add(Enemy(startx = 340, starty = -20, spritelist =  (load_image('sprites1.bmp', -1, 5, 55, 21, 68) , load_image('sprites1.bmp', -1, 5, 80, 21, 93)), pattern = 3, direction = 1))
            enemyship_sprites.add(Enemy(startx = 360, starty = -40, spritelist =  (load_image('sprites1.bmp', -1, 5, 55, 21, 68) , load_image('sprites1.bmp', -1, 5, 80, 21, 93)), pattern = 3, direction = 1))
        elif pattern == 2:
            enemyship_sprites.add(Enemy(startx = 80, starty = -10, spritelist =  (load_image('sprites1.bmp', -1, 5, 55, 21, 68) , load_image('sprites1.bmp', -1, 5, 80, 21, 93)), pattern = 2, direction = 1))
            enemyship_sprites.add(Enemy(startx = 120, starty = -10, spritelist =  (load_image('sprites1.bmp', -1, 5, 205, 20, 219) , load_image('sprites1.bmp', -1, 5, 229, 20, 244)), pattern = 2, direction = 1))
            enemyship_sprites.add(Enemy(startx = 160, starty = -10, spritelist =  (load_image('sprites1.bmp', -1, 5, 55, 21, 68) , load_image('sprites1.bmp', -1, 5, 80, 21, 93)), pattern = 2, direction = 1))
            enemyship_sprites.add(Enemy(startx = 200, starty = -10, spritelist =  (load_image('sprites1.bmp', -1, 5, 205, 20, 219) , load_image('sprites1.bmp', -1, 5, 229, 20, 244)), pattern = 2, direction = 1))
            enemyship_sprites.add(Enemy(startx = 240, starty = -10, spritelist =  (load_image('sprites1.bmp', -1, 5, 55, 21, 68) , load_image('sprites1.bmp', -1, 5, 80, 21, 93)), pattern = 2, direction = 1))
        elif pattern == 3:
            enemyship_sprites.add(Enemy(startx = 270, starty = -10, spritelist =  (load_image('sprites1.bmp', -1, 5, 106, 20, 122) , load_image('sprites1.bmp', -1, 5, 130, 20, 146)), pattern = 4, direction = 1))
            enemyship_sprites.add(Enemy(startx = 50, starty = -10, spritelist =  (load_image('sprites1.bmp', -1, 5, 106, 20, 122) , load_image('sprites1.bmp', -1, 5, 130, 20, 146)), pattern = 4, direction = 0))
        counter = 0

def cleareverything():
    global screen

    #Clear Everything
    ebomb_sprites.clear(screen, clear_callback)
    enemyship_sprites.clear(screen, clear_callback)
    bomb_sprites.clear(screen, clear_callback)
    playership_sprite.clear(screen, clear_callback)
    backgrounds.clear(screen, clear_callback)
    explosion_sprites.clear(screen, clear_callback)

def renderfont():
    global smallfont, screen
    # make the score always at least 6 digits wide - then center it (to 1 px ;)
    smallfont.blit("%(#)06d" % {"#": totalscore}, screen, (133,10), False)
    smallfont.blit(str(ship.missiles), screen, (25,220), False)

def updateeverything():

    global score, totalscore, bonus
    global time, dt
    global playership_sprite
    #Update all sprites
    bomb_sprites.update()
    playership_sprite.update()
    ebomb_sprites.update()
    enemyship_sprites.update()
    enemyship_sprites.move()
    backgrounds.update()
    explosion_sprites.update()
    pickup_sprites.update()

    time += dt

    score = time/50

    totalscore = score + bonus

def checkforcollisions():
    global numberof_hits, bonus, running
    global totalscore, score, pickup_sprites
    #See if players bombs hit any enemy ships
    for hit in pygame.sprite.groupcollide(enemyship_sprites, bomb_sprites, 1, 1):
        explode1.play()
        bonus += 200
        explosion_sprites.add(Explosion(hit.rect.centerx, hit.rect.centery))
        if random.randint(1,15) == 11: 
            pickup_sprites.add(Pickup((hit.rect.centerx, hit.rect.centery)))
            
    #See if enemy bombs hit the player
    for hit in pygame.sprite.groupcollide(ebomb_sprites, playership_sprite, 1, 0).keys():
        numberof_hits += 1
        try:
            health_sprites.remove(health_sprites_list[numberof_hits-1])
        except IndexError:
            pass
        explode2.play()
        explosion_sprites.add(Explosion(hit.rect.centerx, hit.rect.centery))

    #see if any pickups were grabbed
    for grab in pygame.sprite.groupcollide(pickup_sprites, playership_sprite, 1, 0).keys():
        if random.randint(1,2) == 2:
            ship.firetype += 1
            ship.firerate += 25
        else:
            ship.missiles += 5
       
    if numberof_hits >= 5:
        running = False;

def draweverything():

    global screen
    backgrounds.draw(screen)
    ebomb_sprites.draw(screen)
    bomb_sprites.draw(screen)
    enemyship_sprites.draw(screen)
    pickup_sprites.draw(screen)
    playership_sprite.draw(screen)
    explosion_sprites.draw(screen)
    health_sprites.draw(screen)
    hud.draw(screen)
    renderfont()

    pygame.display.flip()

def main():

    global screen, time, bonus, dt, running
    global counter, numberof_hits
    global mode

    init_menu()
    
    while running == True:

        if mode == 0:
            for event in pygame.event.get():
                if event.type == KEYDOWN:
                    if event.key == K_SPACE:
                        mode = mainmenu.click()
                    if event.key == K_UP:
                        mainmenu.move(-1)
                    if event.key == K_DOWN:
                        mainmenu.move(+1)
                elif event.type == JOYBUTTONDOWN:
                    if event.button == BUTTON_B:
                        mode = mainmenu.click()
                    elif event.button == BUTTON_UP:
                        mainmenu.move(-1)
                    elif event.button == BUTTON_DOWN:
                        mainmenu.move(+1)

            update_menu()
            
            pygame.event.pump()
            pygame.display.flip()    

        elif mode == 1:
            addnewenemies()
            cleareverything()
            updateeverything()
            checkforcollisions()
            draweverything()    



        elif mode == -1:
            quit()
 

        if running == False:
            running = True
            init_menu()
            mode = 0

        dt = clock.tick(30)

#        clock.tick()
#        clock.tick(60)



    screen = pygame.display.set_mode((320, 240))

    print "Score: ", totalscore
    print "Hits taken: ",str(numberof_hits)+"/5"

#profiling
#import cProfile
#cProfile.run('main()', 'profile')

#this calls the 'main' function when this script is executed
if __name__ == '__main__': main()



