/*

SDL Test Program Thingy :) version 1.3
By Guyfawkes - http://www.emuholic.com/

This is a little program that I originally wrote to test out some of the SDL 
functions and extra Libraries such as SDL_TTF, SDL_Image, SDL_Mixer to see if 
they are working correctly with my dev setup.

No idea if it will be of any use to people but it makes a nice little first 
program to compile and test your dev setup and also to maybe learn how to
setup a program to run on the GP2X and PC.

*/
bool showarrow=1,showtracker=1,showstats=0;
#define GP2X	// i use a define because i can compile for gp2x or windows, check Shutdown function in AMazing.h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream>
#include "SDL.h"
#include "SDL_ttf.h"
#include "SDL_image.h"
#include "SDL_mixer.h"
#include "AMazing.h"
#include <errno.h>
#include "SDL_gfxPrimitives.h"
#include "SDL_d.h"

#include <math.h>
int EX,EY,EX2,EY2;
SDL_Surface *arrow[15];
char map[2048];
int x;
int y;
int playerView;
int playerX;
int playerY;
int wall10,wall11,wall12,wall20,wall21,wall22;

int can_move_to(char *map, int x, int y, int x2, int y2){
    if(x2/64 > x || x2/64 < 0 || y2/64 > y || y2/64 < 0){
        printf("out\n");
        return 0;
    }
    if(map[(y2/64)*x+x2/64] == 'X'){
        printf("whops\n");
        return 0;
    }
    return 1;
}
Mix_Music *foot = NULL; 
void TestSDLTTF()
//SDL_TTF test
{
	printf("TestSDLTTF function started.\n");									// debug output to serial cable example
	SDL_FillRect(screen, NULL, SDL_MapRGB(screen->format, 0,0,0));				// clear screen to black
	drawText(screen, "SDL_TTF Test", 0, 0, 255, 255, 255);						// draw text to surface
	drawText(screen, "SDL_TTF Test", 0, 20, 255, 0, 0);							// draw red text to surface
	drawText(screen, "SDL_TTF Test", 0, 32, 0, 255, 0);							// draw yellow text to surface
	drawText(screen, "SDL_TTF Test", 0, 44, 0, 0, 255);							// draw green text to surface
	drawText(screen, "Press any key to continue", 0, 215, 255, 0, 0);
	SDL_Flip(screen);															// flip buffer
	WaitForKey();																// wait for keypress
	printf("TestSDLTTF function ended.\n");										// debug output to serial cable example
}



int load(char *string);
void TestSDLTimer()
{
	//SDL Timer 5 second test
	int StartTimer=0;																// start timer
	int CountTimer=0;

	printf("TestSDLTimer function started.\n");										// debug output to serial cable example

	StartTimer = SDL_GetTicks();													// Get start of the timer

	
	while (CountTimer<=1)
	{
		CountTimer=(SDL_GetTicks() - StartTimer) / 1000;							// Calculate ticks from StartTimer to current Timer
	}
	
WaitForKey(); 
	printf("TestSDLTimer function ended.\n");										// debug output to serial cable example
}
/* Precalculated sine and cosine * 16384 (fixed point 18.14) */
static const short sin_table[91] =
{
            0,   285,   571,   857,  1142,  1427,  1712,  1996,  2280,  2563,
	 2845,  3126,  3406,  3685,  3963,  4240,  4516,  4790,  5062,  5334,
	 5603,  5871,  6137,  6401,  6663,  6924,  7182,  7438,  7691,  7943,
	 8191,  8438,  8682,  8923,  9161,  9397,  9630,  9860, 10086, 10310,
	10531, 10748, 10963, 11173, 11381, 11585, 11785, 11982, 12175, 12365,
	12550, 12732, 12910, 13084, 13254, 13420, 13582, 13740, 13894, 14043,
	14188, 14329, 14466, 14598, 14725, 14848, 14967, 15081, 15190, 15295,
	15395, 15491, 15582, 15668, 15749, 15825, 15897, 15964, 16025, 16082,
	16135, 16182, 16224, 16261, 16294, 16321, 16344, 16361, 16374, 16381,
	16384
};

long fisin(int val)
{
	/* Speed improvement through sukzessive lookup */
	if (val<181)
	{
		if (val<91)
		{
			/* phase 0-90 degree */
			return (long)sin_table[val];
		}
		else
		{
			/* phase 91-180 degree */
			return (long)sin_table[180-val];
		}
	}
	else
	{
		if (val<271)
		{
			/* phase 181-270 degree */
			return (-1L)*(long)sin_table[val-180];
		} 
		else
		{
			/* phase 270-359 degree */
			return (-1L)*(long)sin_table[360-val];
		}
	}
	return 0;
}

long ficos(int val)
{
	/* Speed improvement through sukzessive lookup */
	if (val<181)
	{
		if (val<91)
		{
			/* phase 0-90 degree */
			return (long)sin_table[90-val];
		}
		else
		{
			/* phase 91-180 degree */
			return (-1L)*(long)sin_table[val-90];
		}
	}
	else
	{
		if (val<271)
		{
			/* phase 181-270 degree */
			return (-1L)*(long)sin_table[270-val];
		}
		else
		{
			/* phase 270-359 degree */
			return (long)sin_table[val-270];
		}
	}
	return 0;
}

void draw_background(SDL_Surface *srf){
   // ttk_fillrect(srf,wid->x,wid->y,wid->w,wid->h/2,ttk_makecol (1,73,255));
   // ttk_fillrect(srf,wid->x,wid->h/2,wid->w,wid->h,ttk_makecol (BLACK));
 // Draw_FillRect(srf,0,0,srf->w,srf->h/2,SDL_MapRGB(srf->format,1,73,255));
  //Draw_FillRect(srf,0,srf->h/2,srf->w,srf->h/2,SDL_MapRGB(srf->format,0,0,0));
 //  boxColor(srf,0,0,srf->w,srf->h/2,SDL_MapRGB(srf->format,1,73,255));
  // boxColor(srf,0,srf->h/2,srf->w,srf->h/2,SDL_MapRGB(srf->format,0,0,0));
SDL_Rect r;
r.x=0;
r.y=0;
r.w=320;
r.h=240/2;
SDL_FillRect(srf,&r,SDL_MapRGB(srf->format,1,73,255));
r.y=240/2;
r.h=240/2;
SDL_FillRect(srf,&r,SDL_MapRGB(srf->format,0,0,0));
}

  
int find_wall_loop(char *map, int x, int y, int playerX, int playerY, int xA, int yA, int newx, int newy){
    int dist = 650000;
//     printf("test: Ax = %d, Ay = %d, playerX = %d, playerY = %d, xA = %d, yA = %d\n",newx,newy, playerX,playerY,xA,yA);
    int tempx = x*64;
    int tempy = y * 64;

    while(newx < tempx && newx >= 0 && newy < tempy && newy >= 0){
//            printf("search at %d %d (%d %d) there is %c\n",newx/64,newy/64,newx,newy,map[(newy/64)*x+newx/64]);

        if(map[(newy/64)*x+newx/64] == 'X'){
            dist = (newx-playerX)*(newx-playerX) + (newy-playerY)*(newy-playerY);

//               printf("found wall at : %d %d from %d %d dist = %d\n",newx/64,newy/64,playerX/64,playerY/64,dist);

            break;
        }
        newx += xA;
        newy += yA;
    }
    return dist;

}

int find_wall_distanceH(char *map, int x, int y, int yA,int playerX, int playerY,int region,int angle){
    int Ax, Ay, xA;
    if(region == 1 || region == 4){
        Ax = (playerX/64) * 64 + 64;
        xA = 64;
    }else{
        Ax = (playerX/64) * 64 - 1;
        xA = -64;
    }

    if(region == 1 || region == 2){
        yA = -fabs(yA);
    }else{
        yA = fabs(yA);
    }

    switch(angle){
            case 90:
                Ay = 65000;
                xA = 0;
            break;
            case 270:
                Ay = 65000;
                xA = 0;
            break;
            default:
                Ay = playerY + (fisin(angle)*(playerX-Ax)) / ficos(angle);
        }

    return find_wall_loop(map, x, y, playerX,playerY, xA, yA, Ax, Ay);

}


int find_wall_distanceV(char *map, int x, int y, int xA, int playerX, int playerY,int region, int angle){
    int Ax, Ay, yA;
    if(region == 1 || region == 2){
        yA = -64;
        Ay = (playerY/64) * 64 - 1;
    }else{
        yA = 64;
        Ay = (playerY/64) * 64 + 64;
    }

    if(region == 1 || region == 4){
        xA = fabs(xA);
    }else{
        xA = -fabs(xA);
    }

    switch(angle){
            case 0:
                Ax = 65000;
                yA = 0;
            break;
            case 180:
                yA = 0;
                Ax = 65000;
            break;
            default:
                Ax = playerX + (ficos(angle)*(playerY-Ay)) / fisin(angle);
    } 
    return find_wall_loop(map, x, y, playerX,playerY, xA, yA, Ax, Ay);

}

int modify_angle(int angle, int modif){
    int temp = (angle + modif)%360;

    if(temp < 0) {temp = 360 + temp;}
    return temp;
}

void draw_ASCII(char *map, int x, int y, int px, int py){
    int loopx, loopy;
    for(loopy = 0; loopy < y; loopy++){
         for(loopx = 0; loopx < x; loopx++){
            if(loopx == px/64 && loopy == py/64){
                printf("@");
            }else{
                printf("%c",map[loopy*x+loopx]);
            }
         }
        printf("\n");
    }

}
int dif,rangle;
int can_see(int x2,int y2,int ox2,int oy2,int angle)
{
  int i;
  int diff;
  int x,y,ox,oy;
  x=x2/64;
  y=y2/64;
  ox=ox2/64;
  oy=oy2/64;
  if(y<oy &&(angle>180||angle<360))
  return 0;
  if(y>oy &&(angle<180||angle>360))
  return 0;
    if(x<ox &&(angle>90||angle<270))
  return 0;
      if(x>ox &&(angle<90||angle>270))
  return 0;
  if(x==ox&&y<oy) {
  diff==oy-y;
  for(i=1;i<=diff;i++)
  if(map[x*(y+1)]!='0')
  {
    return 0;
  }
  dif=diff*64;
  
  return 1;
  }
  if(x==ox&&y>oy) {
  diff==y-oy;
  for(i=1;i<=diff;i++)
  if(map[x*(y-1)]!='0')
  {
    return 0;
  }
  dif=diff*64;
  return 1;
  }
  if(y==oy&&x<ox) {
  diff==ox-x;
  for(i=1;i<=diff;i++)
  if(map[y*(x+1)]!='0')
  {
    return 0;
  }
  return 1;
  dif=diff*64;
  }
    if(y==oy&&x>ox) {
  diff==x-ox;
  for(i=1;i<=diff;i++)
  if(map[y*(x-1)]!='0')
  {
    return 0;
  }
  return 1;
  dif=diff*64;
  }
  return 0;
}
  
void draw_walls(SDL_Surface *srf, char *map, int x, int y, int playerX, int playerY, int playerView){
//     draw_ASCII(map,x,y,playerX,playerY);
    int i = 0;
    int angle;
  //  int width = ((wid->w-wid->x)/60)+1;
    int width = ((320-0)/60)+1;
   // int magicHeigthNumber = (fisin(30)*wid->h) / ficos(30);
    int magicHeigthNumber = (fisin(30)*240) / ficos(30);
    magicHeigthNumber = magicHeigthNumber*64;

    for(angle = 30;angle > -30;angle--){
        int rayAngle = modify_angle(playerView,angle);
        int xA;
        int yA;
//         printf("angle %d\n",rayAngle);

        int region = 0;
        /*find the correct region on the einheitskreis*/
        if(rayAngle >= 0 && rayAngle <=90){
            region = 1;
        }else if(rayAngle >= 90 && rayAngle <=180){
            region = 2;
        }else if(rayAngle >= 180 && rayAngle <=270){
            region = 3;
        }else if(rayAngle >= 270 && rayAngle <=360){
            region = 4;
        }
        /*find xA and yA*/
        switch(rayAngle){
            case 0:
                xA = 64;
                yA = 0;
            break;
            case 90:
                xA = 0;
                yA = -64;
            break;
            case 180:
                xA = -64;
                yA = 0;
            break;
            case 270:
                xA = 0;
                yA = 64;
            break;
            default:
                 xA = (ficos(rayAngle)*64) / fisin(rayAngle);
                 yA = (fisin(rayAngle)*64) / ficos(rayAngle);
        }

        int distH = find_wall_distanceH(map,x,y,yA,playerX,playerY,region,rayAngle);
        int distV = find_wall_distanceV(map,x,y,xA,playerX,playerY,region,rayAngle);
        int dist = 0;

       // ttk_color color; //Color of the wall
       Uint32 color;
        if(distH>=distV){
      //      color = ttk_makecol (108,0,2);
           color = SDL_MapRGB(srf->format,wall10,wall11,wall12);
            dist = distV;
        }else{
         //   color = ttk_makecol (185,0,3);
            color = SDL_MapRGB(srf->format,wall20,wall21,wall22);
            dist = distH;
        }

        dist = sqrt(dist);
        dist = (dist * ficos(fabs(angle)))>>14;
    if(dist <= 8000 && dist >0){//draw the wall
            int height = magicHeigthNumber/dist; //8864 = (64*277)/2
          //  ttk_fillrect(srf, i, wid->h/2-height, i+width, wid->h/2+height, color);
SDL_Rect r;
r.x=i;
r.y=240/2-height;
r.w=width;
r.h=height*2;
SDL_FillRect(srf,&r,color);
//char *xy;
//drawTextInt(srf,playerX,0,0,255,255,255);
//drawTextInt(srf,playerY,0,13,255,255,255);

//sprintf(xy,"%i|%i",playerX,playerY);
//drawText(srf,xy,0,0,255,255,255);
//boxColor(srf,i,srf->h/2-height,i+width,srf->h/2+height,color);
//  Draw_FillRect(srf,i,(srf->h/2)-height,i+width,(srf->h/2)+height,color);
        }
        i+=width;
    }
        
             
}
int calc_degree(int px2, int py2,int ox2,int oy2)
{
int py,px,oy,ox;
oy-=py2;//0
ox-=px2;//256
px=ox2;//352
py=oy2;//96
int angle;
 if(ox<0)ox*=-1;
if(oy<0)oy*=-1;
    if(oy>ox) {
      if(oy/2>ox)
      angle=1;
      else angle=2;
    }
    else
    if(ox/2>oy)
    angle=4;
    else
    angle=3;
    
    
    if(py<0 && px<0)
    {
    if(angle==1) angle=9;
    if(angle==2) angle=10;
    if(angle==3) angle=11;
    if(angle==4) angle=12;
    }
    if(py<0 && px>0)
    {
    if(angle==1) angle=5;
    if(angle==2) angle=6;
    if(angle==3) angle=7;
    if(angle==4) angle=8;
    }
    if(py>0 && px <0)
    {
    if(angle==1) angle=13;
    if(angle==2) angle=14;
    if(angle==3) angle=15;
    if(angle==4) angle=16;
    }
  return angle;
}
  int view=90,viewc;

int  draw_arrow(SDL_Surface *srf)
{
if(!showarrow) return 0;
  int angle,temp;
  angle=calc_degree(playerX,playerY,EX,EY);
  int pa;
  
angle+=((playerView-90)/22.5);
angle+=2;
if(angle==0) angle=16;
if(angle==-1) angle=15;
if(angle==17) angle=1;
if(angle==18) angle=2;
//drawTextInt(srf,angle,0,198,255,255,255);
  drawSprite(arrow[angle-1],srf,0,0,0,210,30,30);
  
}

  
  
  
int playerXW,playerYW,playerXW2,playerYW2;
void draw_mymodule (SDL_Surface *srf){
    draw_background(srf);
 
    draw_walls(srf,map,x,y,playerX,playerY,playerView);
    if(showstats || showarrow)
    {
      SDL_Rect z;
      z.x=0;
      z.y=210;
      z.w=320;
      z.h=30;
      SDL_FillRect(srf,&z,SDL_MapRGB(srf->format,0,0,0));
    }
    if(showstats)
{
  drawText(srf,"X:",32,210,255,255,255);

  drawTextInt(srf,playerX,44,210,255,255,255);
    drawText(srf,"Y:",32,223,255,255,255);
  drawTextInt(srf,playerY,44,223,255,255,255);
  drawText(srf,"View:",64,210,255,255,255);
  drawTextInt(srf,playerView,68,223,255,255,255);
  }
  draw_arrow(srf);
  

}
int play()
{
 // char *string;
FILE *g;
srand(time(NULL));
  //sprintf(string,"/mnt/sd/lvl1.m3d");
  start:
 char pth[40];
 sprintf(pth,"AMazing/lvl%i.m3d",(rand()%25));
 if((g=fopen(pth,"r"))==NULL)
 goto start;
  if(!load (pth))
  goto start;
  
  return 0;
}
int playerx2,playery2;
void win(SDL_Surface *screen)
{
SDL_Event event;
int qu=0;
LoadFont(40);	
while(qu==0)
  {
 SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0,0,0)); 

  drawText(screen,"You WIN!",screen->w/2-30,screen->h/2-50,rand()%255,rand()%255,rand()%255);
  while( SDL_PollEvent( &event ) )
		{
			switch( event.type )
			{
				case SDL_JOYBUTTONDOWN:
  qu=1;
  break;
			}
		}
  SDL_Flip(screen);
  }

play();
}
int volume=50;
int load(char *string)
{
	bool quit = false;
	u8 option=1;
bool up,down,left,right;
  int j=0;
  FILE *fp;
  if((fp=fopen(string,"r"))==NULL)
drawText(screen,"lvl1.m3d not found!",0,0,255,255,255);
else {  


 
  int x2=1,y2=1;
  
 fscanf(fp,"%i\n%i\n%i\n%i\n%i\n%i\n%i\n",&x,&y,&playerView,&playerX,&playerY,&EX,&EY);
 playerX=(playerX*64)-32;
 playerY=(playerY*64)-32;
EY=(EY*64)-32;
EX=(EX*64)-32;
playerXW=(EX)-32;
playerXW2=(EX)+32;
playerYW=(EY)-32;
playerYW2=(EY)+32;
  char ch;
 y+=3;
 for(y2=1;y2<y;y2++)
 {
   for(x2=1;x2<x+1;x2++)
   {
     fscanf(fp,"%c",&ch);
     if(ch=='X' || ch=='0'|| ch=='x' || ch=='o'||ch=='O')
     {
      map[j]=ch;
       j++;
     }
   
     //j++;
   }
 }

   
 fclose(fp);
 
 }
 int i;
 //playerView = 90;
int speed=1,vol=0;
right=left=up=down=false;
LoadFont(12);
while (!quit)
	{
		SDL_FillRect(screen, NULL, SDL_MapRGB(screen->format, 0,0,0));
		
draw_mymodule(screen);

		SDL_Flip(screen);
    int playerYTemp,playerXTemp;
		SDL_Event event;
		while( SDL_PollEvent( &event ) )
		{
			switch( event.type )
			{
				case SDL_JOYBUTTONDOWN:

					switch( event.jbutton.button )
					{
case GP2X_BUTTON_UP:
up=1;
                        
                        break;
                        case GP2X_BUTTON_DOWN:
                       down=1;
                            break;
                            case GP2X_BUTTON_LEFT:
                               left=1;
                                 break;
                                 case GP2X_BUTTON_Y:
                                 case GP2X_BUTTON_X:
                               speed+=5;
                                 break;
                                 case GP2X_BUTTON_RIGHT:
                                    right=1;
                                      break;
                                      case GP2X_BUTTON_SELECT:
                                      quit++;
                                      break;
                                      case GP2X_BUTTON_UPLEFT:
                                      up=1;
                                    //  left=1;
                                      break;
                                      case GP2X_BUTTON_UPRIGHT:
                                      up=1;
                                    //  right=1;
                                      break;
                                      case GP2X_BUTTON_DOWNLEFT:
                                      down=1;
                                    //  left=1;
                                      break;
                                      case GP2X_BUTTON_DOWNRIGHT:
                                      down=1;
                                    //  right=1;
                                      break;
                                      case GP2X_BUTTON_VOLUP:
                                      vol=1;
                                      break;
                                       case GP2X_BUTTON_VOLDOWN:
                                      vol=-1;
                                      break;
                case GP2X_BUTTON_L:
                playerx2=playerX;
                playery2=playerY;
                break;
				case GP2X_BUTTON_R:
                playerX=playerx2;
                playerY=playery2;
                break;		
                case GP2X_BUTTON_CLICK:
                 showarrow=showarrow==0?1:0;
                break;
                case GP2X_BUTTON_B:
                 showarrow=showarrow==0?1:0;
                break;
                case GP2X_BUTTON_A:
                showstats=showstats==0?1:0;
                break;
                case GP2X_BUTTON_START:
                LoadFont(20);
                return 1;
                break;
						default:
							break;
					}
					break;
				case SDL_JOYBUTTONUP:

					switch( event.jbutton.button )
					{
case GP2X_BUTTON_UP:
    up=0;
                        
                        break;
                        case GP2X_BUTTON_DOWN:
                 down=0;
                            break;
                            case GP2X_BUTTON_Y:
                              case GP2X_BUTTON_X:
                               speed-=5;
                                 break;
                            case GP2X_BUTTON_LEFT:
                           left=0;
                                 break;
                                 case GP2X_BUTTON_RIGHT:
                                right=0;
                                      break;
                                      case GP2X_BUTTON_START:
                                      return 1;
                                      break;
                                          case GP2X_BUTTON_UPLEFT:
                                      up=0;
                                   //   left=0;
                                      break;
                                      case GP2X_BUTTON_UPRIGHT:
                                      up=0;
                                    //  right=0;
                                      break;
                                      case GP2X_BUTTON_DOWNLEFT:
                                      down=0;
                                      //left=0;
                                      break;
                                      case GP2X_BUTTON_DOWNRIGHT:
                                      down=0;
                                     // right=0;
                                      break;
                                      
						    case GP2X_BUTTON_VOLUP:
                                      vol=0;
                                      break;
                                       case GP2X_BUTTON_VOLDOWN:
                                      vol=-0;
                                      break;
						default:
							break;
					}
					break;
			
			}
		}
	
           if(down==1) {
                           playerYTemp = playerY+(((3+speed)*fisin(playerView))>>14);
                        playerXTemp = playerX-(((3+speed)*ficos(playerView))>>14);
                        if(can_move_to(map, x,y,playerXTemp,playerYTemp)){
                            playerY = playerYTemp;
                            playerX = playerXTemp;}
                     }
                           if(left==1)
                           {
                         
                                 playerView = modify_angle(playerView, -(-2));
                             
                                 }
                              if(right==1)
                               {
                           
                                      playerView = modify_angle(playerView, -(2));
                                       
                                 }
		if(up==1) {
		  playerYTemp = playerY-(((3+speed)*fisin(playerView))>>14);
                        playerXTemp = playerX+(((3+speed)*ficos(playerView))>>14);
                        if(can_move_to(map, x,y,playerXTemp,playerYTemp)){
                        playerY = playerYTemp;
                        playerX = playerXTemp;}
                        
                     }

                     volume+=vol;
                     if(playerX>playerXW && playerX<playerXW2  && playerY>playerYW && playerY<playerYW2)
                     win(screen);
	}

return 0;
}


//////////////////////

int save()
{
  FILE *z=fopen("AMazing/settings.set","w");
  fprintf(z,"%i\n",wall10);
  fprintf(z,"%i\n",wall11);
  fprintf(z,"%i\n",wall12);
 fprintf(z,"%i\n",wall20);
 fprintf(z,"%i\n",wall21);
 fprintf(z,"%i\n",wall22);
fclose(z);
return 0;
}

int main(int argc, char **argv)
{
	bool quit = false,left,right,up,down;
	u8 option=1;
right=left=up=down=0;
	SDL_Init(SDL_INIT_JOYSTICK | SDL_INIT_VIDEO);			// Initialize SDL
																// Disable mouse cursor on gp2x
	screen = SDL_SetVideoMode( 320, 240, 32, SDL_SWSURFACE);								// Set up screen for gp2x
	if(!screen)
	{
		printf("SDL_SetVideoMode screen not initialised.\n");								// debug output example for serial cable
	}
	arrow[0]=SDL_LoadBMP("AMazing/arrow1.bmp");
arrow[1]=SDL_LoadBMP("AMazing/arrow2.bmp");
arrow[2]=SDL_LoadBMP("AMazing/arrow3.bmp");
arrow[3]=SDL_LoadBMP("AMazing/arrow4.bmp");
arrow[4]=SDL_LoadBMP("AMazing/arrow5.bmp");
arrow[5]=SDL_LoadBMP("AMazing/arrow6.bmp");
arrow[6]=SDL_LoadBMP("AMazing/arrow7.bmp");
arrow[7]=SDL_LoadBMP("AMazing/arrow8.bmp");
arrow[8]=SDL_LoadBMP("AMazing/arrow9.bmp");
arrow[9]=SDL_LoadBMP("AMazing/arrow10.bmp");
arrow[10]=SDL_LoadBMP("AMazing/arrow11.bmp");
arrow[11]=SDL_LoadBMP("AMazing/arrow12.bmp");
arrow[12]=SDL_LoadBMP("AMazing/arrow13.bmp");
arrow[13]=SDL_LoadBMP("AMazing/arrow14.bmp");
arrow[14]=SDL_LoadBMP("AMazing/arrow15.bmp");
arrow[15]=SDL_LoadBMP("AMazing/arrow16.bmp");
sprite=SDL_LoadBMP("AMazing/splash.bmp");
													// Sets the window title (not needed for gp2x)
	SDL_JoystickOpen(0);																	// Initialize the joystick
	TTF_Init();		
	FILE *x;
	if((x=fopen("AMazing/settings.set","r"))==NULL)
	{
	  wall10=108;
	  wall11=0;
	  wall12=2;
	  wall20=185;
	  wall21=0;
	  wall22=3;
	  save();
	}
	else {
	fscanf(x,"%i\n",&wall10);																		// Initialize SDL_TTF
	fscanf(x,"%i\n",&wall11);																		// Initialize SDL_TTF
	fscanf(x,"%i\n",&wall12);																		// Initialize SDL_TTF
	fscanf(x,"%i\n",&wall20);																		// Initialize SDL_TTF
	fscanf(x,"%i\n",&wall21);																		// Initialize SDL_TTF
	fscanf(x,"%i\n",&wall22);	
	fclose(x);	
	}																// Initialize SDL_TTF
	
LoadFont(20);																			// load font size 12
SDL_ShowCursor(SDL_DISABLE);
	printf("If you can read this then your Serial Cable is working!\n");								// debug output example for serial cable
		
		drawSprite(sprite,screen,0,0,0,0,320,240);
		drawText(screen,"Press B to continue",75,200,255,255,255);
		SDL_Flip(screen);
	WaitForKey(); 
	sprite=SDL_LoadBMP("AMazing/screenshot.bmp");
int menu=1;
	while (!quit)
	{
		SDL_FillRect(screen, NULL, SDL_MapRGB(screen->format, 0,0,0));
		drawSprite(sprite,screen,0,0,0,0,320,240);
		drawText(screen,"AMazing! 3D",110,0,rand()%255,rand()%255,rand()%255);
		if(menu==1)
		{
	
		
		
		
		
		

		if(option==1) drawText(screen, "Play", 140, 30,rand()%255,rand()%255,rand()%255);
		else
		
			drawText(screen, "Play", 140, 30, 255, 255, 255);
		if(option==2) drawText(screen, "Settings", 125, 50,rand()%255,rand()%255,rand()%255);
		else
		drawText(screen, "Settings", 125, 50, 255, 255, 255);
		if(option==3) drawText(screen, "Info", 140, 70,rand()%255,rand()%255,rand()%255);
		else
		drawText(screen, "Info", 140, 70, 255, 255, 255);
		if(option==4) drawText(screen, "Credits", 130, 90,rand()%255,rand()%255,rand()%255);
		else
		drawText(screen, "Credits", 130, 90, 255, 255, 255);
		if(option==5) drawText(screen, "Quit", 140, 110,rand()%255,rand()%255,rand()%255);
		else
		drawText(screen, "Quit", 140, 110, 255, 255, 255);
		
		
			}
			else if(menu==2)
		{
	
		
		
		
		
		

		if(option==1){ drawText(screen, "Wall 1 R", 110, 30,rand()%255,rand()%255,rand()%255);
		drawTextInt(screen,wall10,190,30,rand()%255,rand()%255,rand()%255);
		}
		else
		{
			drawText(screen, "Wall 1 R", 110, 30, 255, 255, 255);
			drawTextInt(screen,wall10,190,30,255,255,255);	
			}
		if(option==2){ drawText(screen, "Wall 1 G", 110, 50,rand()%255,rand()%255,rand()%255);
		drawTextInt(screen,wall11,190,50,rand()%255,rand()%255,rand()%255);
		}
		else
		{
		drawText(screen, "Wall 1 G", 110, 50, 255, 255, 255);
		drawTextInt(screen,wall11,190,50,255,255,255);
		}
		if(option==3){ drawText(screen, "Wall 1 B", 110, 70,rand()%255,rand()%255,rand()%255);
		drawTextInt(screen,wall12,190,70,rand()%255,rand()%255,rand()%255);
		}
		else
		{
		drawText(screen, "Wall 1 B", 110, 70, 255, 255, 255);
			drawTextInt(screen,wall12,190,70,255,255,255);
		}
		if(option==4){ drawText(screen, "Wall 2 R", 110, 90,rand()%255,rand()%255,rand()%255);
		drawTextInt(screen,wall20,190,90,rand()%255,rand()%255,rand()%255);
		}
		else
		{
		drawText(screen, "Wall 2 R", 110, 90, 255, 255, 255);
		drawTextInt(screen,wall20,190,90,255,255,255);
		}
		if(option==5){ drawText(screen, "Wall 2 G", 110, 110,rand()%255,rand()%255,rand()%255);
		drawTextInt(screen,wall21,190,110,rand()%255,rand()%255,rand()%255);
		}
		else
		{
		drawText(screen, "Wall 2 G", 110, 110, 255, 255, 255);
				drawTextInt(screen,wall21,190,110,255,255,255);
		}
		if(option==6){ drawText(screen, "Wall 2 B", 110, 130,rand()%255,rand()%255,rand()%255);
		drawTextInt(screen,wall22,190,130,rand()%255,rand()%255,rand()%255);
		}
		else
		{
		drawText(screen, "Wall 2 B", 110, 130, 255, 255, 255);
			drawTextInt(screen,wall22,190,130,255,255,255);
		}
		SDL_Rect r;
		r.x=305;
		r.y=50;
		r.w=15;
		r.h=15;
		SDL_FillRect(screen ,&r,SDL_MapRGB(screen->format,wall10,wall11,wall12));
		r.y=100;
		SDL_FillRect(screen ,&r,SDL_MapRGB(screen->format,wall20,wall21,wall22));
			}
			else if(menu==3)
			{
			SDL_FillRect(screen, NULL, SDL_MapRGB(screen->format, 0,0,0));
	
	
			  drawText(screen,"AMazing! 3D is a 3D maze solving",0,0,255,255,255);
			  drawText(screen,"game, featuring over 25 sepperate ",0,21,255,255,255);
			  drawText(screen,"levels andthe ability to create ",0,42,255,255,255);
			  drawText(screen,"your own! ",0,63,255,255,255);
			  drawText(screen,"-----------Instructions---------",0,84,255,255,255);
			  drawText(screen,"Joystick-Move  X-Run",0,105,255,255,255);
			
			  drawText(screen,"B-Show/Hide Compass",0,126,255,255,255);
			  drawText(screen,"R-Save Position A-Show/Hide Stats",0,147,255,255,255);
			  drawText(screen,"L-Jump to saved position",0,168,255,255,255);
			  drawText(screen,"Select-Start new maze",0,189,255,255,255);
			  drawText(screen,"Start- Quit to menu",0,210,255,255,255);
			 
			}
			else if(menu==4)
			{
			SDL_FillRect(screen, NULL, SDL_MapRGB(screen->format, 0,0,0));
	
		
			  drawText(screen,"Lead Programmer       - zacaj",0,0,255,255,255);
			  drawText(screen,"Other Programmes     - asraniel",0,21,255,255,255);
			  drawText(screen,"Graphics                     - zacaj",0,42,255,255,255);
			  drawText(screen,"Level Design               - zacaj",0,63,255,255,255);
			  drawText(screen,"                                  - Haru",0,84,255,255,255);
			  drawText(screen,"Base 3D                     - asraniel",0,105,255,255,255);
			  drawText(screen,"Idea                           - zacaj",0,126,255,255,255);
			  drawText(screen,"Special Thanks",0,147,255,255,255);
			 
			  drawText(screen,"asraniel",0,168,255,255,255);
			  drawText(screen,"Woogal",0,189,255,255,255);
			
			  drawText(screen,"    Thanks for playing!",0,210,255,255,255);
		
}
		SDL_Flip(screen);

		SDL_Event event;
		while( SDL_PollEvent( &event ) )
		{
			switch( event.type )
			{
				case SDL_JOYBUTTONDOWN:

					switch( event.jbutton.button )
					{

						case GP2X_BUTTON_UP :
							option--;
							if(option<=0&&menu==1) option=5;
							if(option<=0&&menu==2) option=6;
							break;
						case GP2X_BUTTON_DOWN :
							option++;
							if(option>=6&&menu==1) option=1;
							if(option>=7&&menu==2) option=1;
							break;
						case GP2X_BUTTON_RIGHT:
						right=1;
						break;
						case GP2X_BUTTON_LEFT:
						left=1;
						break;
						case GP2X_BUTTON_B :
							if(menu==1)
							{
							if(option==1){play();}
							if(option==2){menu=2;}
							if(option==3){menu=3;}
							if(option==4){menu=4;}
							if(option==5){quit=1;}
							}
							else if(menu==3 || menu==4)
							menu==1;
							else if(menu==2)
							{
							  menu=1;
							  save();
							}
							option=1;
							break;
						case GP2X_BUTTON_Y:
						if(menu==1) quit=1;
						else menu=1;
						option=1;
						break;
						default:
							break;
					}
					break;
case SDL_JOYBUTTONUP:
switch(event.jbutton.button)
{
  case GP2X_BUTTON_RIGHT:
  right=0;
  break;
  case GP2X_BUTTON_LEFT:
  left=0;
  break;
}
break;
				case SDL_KEYDOWN:

					switch( event.key.keysym.sym )
					{
						case SDLK_ESCAPE:
							quit=true;
							break;
						case SDL_QUIT:
							quit=true;
							break;
						case SDLK_UP:
							option--;
							if(option<=0&&menu==1) option=5;
							if(option<=0&&menu==2) option=6;
							break;
						case SDLK_DOWN:
								option++;
							if(option>=6&&menu==1) option=1;
							if(option>=7&&menu==2) option=1;
							break;
						case SDLK_s:
							if(menu==1)
							{
							if(option==1){play();}
							if(option==2){menu=2;}
							if(option==3){menu=3;}
							if(option==4){menu=4;}
							if(option==5){quit=1;}
							}
							else if(menu==3 || menu==4)
							menu==1;
							
							else if(menu==2)
							{
							  menu=1;
							  save();
							}
							option=1;
							break;
						default:
							break;
					}
					break;
			}
		}
	if(right==1)
	{
	  if(menu==2)
	  {
	    if(option==1)
	     {
	      wall10++;
	      if(wall10>255)
	      wall10=0;
	    }
	    if(option==2)
	     {
	      wall11++;
	      if(wall11>255)
	      wall11=0;
	    }
	    if(option==3)
	     {
	      wall12++;
	      if(wall12>255)
	      wall12=0;
	    }
	    if(option==4)
	     {
	      wall20++;
	      if(wall10>255)
	      wall10=0;
	    }
	        if(option==5)
	     {
	      wall21++;
	      if(wall11>255)
	      wall11=0;
	    }
	        if(option==6)
	     {
	      wall22++;
	      if(wall12>255)
	      wall12=0;
	    }
	  }
	}
	 
	 
	 	if(left==1)
	{
	  if(menu==2)
	  {
	    if(option==1)
	     {
	      wall10--;
	      if(wall10<0)
	      wall10=255;
	    }
	    if(option==2)
	     {
	      wall11--;
	      if(wall11<0)
	      wall11=255;
	    }
	    if(option==3)
	     {
	      wall12--;
	      if(wall12<0)
	      wall12=255;
	    }
	    if(option==4)
	     {
	      wall20--;
	      if(wall10<0)
	      wall10=255;
	    }
	        if(option==5)
	     {
	      wall21--;
	      if(wall11<0)
	      wall11=255;
	    }
	        if(option==6)
	     {
	      wall22--;
	      if(wall12<0)
	      wall12=255;
	    }
	  }
	}   
	}

	Shutdown();																													// Shutdown program

	return 0;
}

