

#define GP2X_BUTTON_UP              (0)//
#define GP2X_BUTTON_DOWN            (4)//
#define GP2X_BUTTON_LEFT            (2)//
#define GP2X_BUTTON_RIGHT           (6)//
#define GP2X_BUTTON_UPLEFT          (1)//
#define GP2X_BUTTON_UPRIGHT         (7)//
#define GP2X_BUTTON_DOWNLEFT        (3)//
#define GP2X_BUTTON_DOWNRIGHT       (5)//
#define GP2X_BUTTON_CLICK           (18)//
#define GP2X_BUTTON_A               (12)
#define GP2X_BUTTON_B               (13)//
#define GP2X_BUTTON_X               (14)//
#define GP2X_BUTTON_Y               (15)
#define GP2X_BUTTON_L               (10)//
#define GP2X_BUTTON_R               (11)//
#define GP2X_BUTTON_START           (8)//
#define GP2X_BUTTON_SELECT          (9)
#define GP2X_BUTTON_VOLUP           (16)//
#define GP2X_BUTTON_VOLDOWN         (17)//

typedef unsigned char u8;

const int WINDOW_WIDTH = 320;
const int WINDOW_HEIGHT = 240;
const char* WINDOW_TITLE = "SDL Library Test";
SDL_Surface* screen;
SDL_Surface* sprite;
TTF_Font* font;
 
int textc[2],wall1c[2],wall2c[2],skyc[2],groundc[2];
void Shutdown()
{	
	SDL_FreeSurface(screen);																// Release the memory allocated to screen
	SDL_FreeSurface(sprite);																// Release the memory allocated to sprite
																			// Close SDL_Mixer Audio
	TTF_CloseFont(font);																		// Release the memory allocated to font
	TTF_Quit();																							// Close SDL_TTF
	
	#ifndef GP2X																						// if GP2X isnt defined (i.e. PC) close SDL 
		SDL_Quit();
	#endif

	#ifdef GP2X																							// if GP2X is defined return to menu
		chdir("/usr/gp2x");
		execl("/usr/gp2x/gp2xmenu", "/usr/gp2x/gp2xmenu", NULL);
	#endif
}

void LoadFont(u8 size)
{
	font = TTF_OpenFont("AMazing/arial.ttf", size);
}

void drawText(SDL_Surface* screen, char* string, int x, int y, int fR, int fG, int fB)
{
	SDL_Color foregroundColor = { fR, fG, fB};
	SDL_Surface* textSurface =  TTF_RenderText_Blended(font,string, foregroundColor);
	SDL_Rect textLocation = { x, y, 0, 0 };
	SDL_BlitSurface(textSurface, NULL, screen, &textLocation);
	SDL_FreeSurface(textSurface);
}

void drawTextInt(SDL_Surface* screen, int number, int x, int y, int fR, int fG, int fB)
{
	char tmp_num[16];
	sprintf((char*)tmp_num, "%d", number);
	SDL_Color foregroundColor = { fR, fG, fB };
	SDL_Surface* textSurface =  TTF_RenderText_Blended(font,tmp_num, foregroundColor);
	SDL_Rect textLocation = { x, y, 0, 0 };
	SDL_BlitSurface(textSurface, NULL, screen, &textLocation);
	SDL_FreeSurface(textSurface);
}

void drawSprite(SDL_Surface* imageSurface, SDL_Surface* screenSurface, int srcX, int srcY, int dstX, int dstY, int width, int height)
{
	SDL_Rect srcRect;
	srcRect.x = srcX;
	srcRect.y = srcY;
	srcRect.w = width;
	srcRect.h = height;

	SDL_Rect dstRect;
	dstRect.x = dstX;
	dstRect.y = dstY;
	dstRect.w = width;
	dstRect.h = height;

	SDL_BlitSurface(imageSurface, &srcRect, screenSurface, &dstRect);
}

void WaitForKey()
{
	bool quit = false;
	while(!quit)
	{
		SDL_Event event;

		while( SDL_PollEvent( &event ) )
		{
			switch( event.type )
			{
				case SDL_JOYBUTTONDOWN:														// GP2X buttons

					switch( event.jbutton.button )
					{
						case GP2X_BUTTON_X :
							quit=true;
							break;
						default:
							quit=true;
							break;
					}

				case SDL_KEYDOWN:																	// PC buttons

					switch( event.key.keysym.sym )
					{
						case SDLK_ESCAPE:
							Shutdown();
							break;
						case SDL_QUIT:
							Shutdown();
							break;						
						case SDLK_s:
							quit=true;
							break;
						default:
							quit=true;
							break;
					}
			}
		}
	}
}
