/*
* libCam2X - Webcam Library for GP2X
*
* by Lithosphere
*/

/* threaded not finished yet */
#define CAM2X_NO_PTHREAD 1

#ifndef H_CAM2X
#define H_CAM2X

#include <linux/types.h>
#include <linux/videodev.h>

#ifndef CAM2X_NO_PTHREAD
#include <pthread.h>
#endif


typedef struct{
	int fd;							/* Video Device */
	struct video_capability cap;	/* Video Capability */
	struct video_window win;		/* Video Window */
	struct video_picture vpic;		/* Video Picture */

	unsigned char *buffer;
	
#ifndef CAM2X_NO_PTHREAD
	unsigned char* double_buff[2];
	int current_frame;
	int new_frame;
	int active_grab;
	pthread_t capture_thread;
	pthread_mutex_t conditional_mutex;
	pthread_mutex_t conditional_mutex_new_frame;
	pthread_cond_t conditional_cond;
#endif

} Cam2X_Device;

Cam2X_Device* Cam2X_OpenCamera();
Cam2X_Device* Cam2X_OpenCameraDevice(char* videodevice, int width, int height, int depth, int palette);

int Cam2X_SetWidthHeightDepth(Cam2X_Device* cam2x, int width, int height, int depth, int palette);
void Cam2X_GetWidthHeightDepth(Cam2X_Device* cam2x);
int Cam2X_AdjustBrightness(Cam2X_Device* cam2x);

void Cam2X_GetNewFrame(Cam2X_Device* cam2x);

#ifndef CAM2X_NO_PTHREAD
void* Cam2X_Threaded(void* cam2x_arg);
int Cam2X_CheckNewFrame(Cam2X_Device* cam2x);
#endif

void Cam2X_CloseCamera(Cam2X_Device* cam2x);

#endif
