// Main 
#ifndef MAIN_H
#define MAIN_H
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "game.h"

extern struct Game game;
extern enum DrawMode { DM_NORMAL, DM_INTRO, DM_SUBWAY } drawMode;
/**
** x = x posistion
** y = y posistion
** tile = info about what the tile is
** frame = which animation frame
**/
void drawTile(int x, int y, struct Tile *tile, int frame);
void drawCell(int x,int y,const char *fname);
void freeCells();		// Frees all loaded cells
void playWav(const char *fname);	// non-blocking
void freeWavs();
void drawMessage(int x,int y, enum FontId fontId, const char *message);
void extentMessage(int *w,int *h, enum FontId fontId, const char *message);
void drawFilledRect(int x,int y,int width, int height,unsigned int color);
void playSfx(enum Sfx id);

#endif
