// Verticies and their data structures.

#define MAXVERTPEROCTANT 300

typedef struct Vertex3DCNP {
	unsigned long color;
	float nx,ny,nz;
	float x,y,z;
} Vertex3DCNP;

typedef struct Vertex3DCP {
	unsigned long color;
	float x,y,z;
} Vertex3DCP;

typedef struct Vertex3DP {
	float x,y,z;
} Vertex3DP;

typedef struct Octtree {
		float center[3];
		float width;
		int vertCount;
		Vertex3DCNP *vert;
		struct Octtree *child[8];
		// purely debug:
		int descendants;
		int descendantVerts;
} Octtree;

struct Item {
	char name[64];
	float matrix[16];
	struct Octtree *oct;
	int vertCount;
	Vertex3DCNP *vert;
	int polyCount;
	unsigned short *poly;
};

Octtree *createOcttree(Vertex3DCNP *vert,int vertCount,int *octant,int id,float width,float center[3]);
void optimizeItem(struct Item *item);
void freeOcttree(Octtree *octtree);
void drawOcttree(Octtree *octtree);
